@extends('layouts.app')
@section('content')
@include('drawings.modal')

<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')</span>
        </div>
        <div class="tools"> </div> 
         <!--div class="btn-group pull-right">
            @permission('services-export')
               
                <a href="{{route('systemAlerts.create')}}">
                              <button class="btn btn-success">
                                  <i class="fa fa-plus"></i> @lang('layout.AddNew')
                              </button>
                </a>
            @endpermission
        </div-->
    </div>
 </div>


 

    <div class="row" >
        
        <ul class="nav nav-tabs">  
            <li class="active">
              <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
               <i class="fa  "></i><b> @lang('layout.Gift') </b></a>
            </li> 
             <!-- <li class="">
              <a href="#ex-transport" data-toggle="tab" id="tab-trasnport" style="color: red">
               <i class="fa  "></i><b> @lang('layout.Payment') </b></a>
             </li>  -->
           </ul> 
        <div class="portlet light bordered">
           

            <div class="portlet-body">
 
                <table class="table table-striped table-bordered table-hover" id="sales_gift">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.ItemName')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.ItemGift')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th> 
                        <th>@lang('layout.Action')</th>
                   
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
     Vue.component("v-select", VueSelect.VueSelect);
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        getRecord();
    } );

    function getRecord()
    {
           // var from_date=document.getElementById('range-from-example').value;
           // var to_date=document.getElementById('range-to-example').value;
           var from_date = null;
           var to_date = null;
            $('#sales_gift').DataTable( {
             ajax:{
                    url:'{{route("systemAlerts.salesFiftAlert")}}',
                    data:{category:vmf.category,from_date:from_date,to_date:to_date,title:vmf.title,description:vmf.description,attachment_class_id:vmf.attachment_class_id}
                },
            pageLength:'{{getPageRows()}}',
            order: [[0,"{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            destroy: true,
            serverSide: true,
            columns: [
                { data: 'id',            name: 'id',searchable:false},
                { data: 'customer',        name: 'members.name' },
                { data: 'item_name',    name: 'items.name' },
                { data: 'quantity',    name: 'quantity' },
                { data: 'measure',         name: 'measure_units.name' },
                { data: 'item_gift',       name: 'item_gift.name' },
                { data: 'gift_quantity',   name: 'gift_quantity'},
                { data: 'date',    name: 'date'},
                { data: 'status',    name: 'sales_gifts_alert.status'},
                { data: 'action',       name: 'action',orderable:false,searchable:false }
            ]
        } );
    }
// start app

var vmf = new Vue({
    el: '#app',
    data:{
         from_date:null,
        to_date:null,
        title:null,
        number:null,
        description:null,
        
    },
    methods:{
         getData(){

           getRecord();
    }
    }
})


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
 

        
        
</script>
@endpush

