@extends('layouts.app')
@section('content')
@include('loans.modal')


<div class="">

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.Alerts')</span>
            </div>
            <div class="tools"> </div> 
             <!--div class="btn-group pull-right">
                @permission('services-export')
                   
                    <a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
                    </a>
                @endpermission
            </div-->
        </div>
     </div>
  
  
  <div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">  
    <li class="active">
      <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
       <i class="fa  "></i><b> @lang('menu.Sales') </b></a>
     </li> 
     <li class="">
      <a href="#ex-transport" data-toggle="tab" id="tab-trasnport" style="color: red">
       <i class="fa  "></i><b> @lang('layout.Purchase') </b></a>
     </li> 
     <li class="">
      <a href="#ex-nega_sale" data-toggle="tab" id="tab-nega_sale" style="color: red">
       <i class="fa  "></i><b> @lang('layout.ShowNegativeSale') </b></a>
     </li> 


   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="both">
     <div class="row">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('menu.Sales') </span>
            </div>
            <div class="tools"> </div> 
               <div class="pull-right">
                @permission('customers-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="sale_alert"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                @endpermission
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="sale_alert">
                <thead>
                <tr> 
                         <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Member')</th>
                         <th>@lang('layout.Type') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.OverdueDate')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>

                </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
      </div>
    </div>
  </div> 

  <div class="tab-pane" id="ex-transport">
   <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.Purchase')</span>
            </div>
            <div class="tools"> </div> 
            <div class="btn-group pull-right">
                  @permission('driver-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="purchase_alert"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                    @endpermission 
             </div>



        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="purchase_alert">
                <thead>
                  <tr> 
                        <th>@lang('layout.Number') </th>
                        <th>@lang('layout.Vendor') </th>
                        <th>@lang('layout.Type') </th>
                        <th>@lang('layout.Date') </th>
                        <th>@lang('layout.OverdueDate')</th>
                        <th>@lang('layout.Amount') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
</div>  


  <div class="tab-pane" id="ex-nega_sale">
   <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ShowNegativeSale')</span>
            </div>
            <div class="tools"> </div> 
            <div class="btn-group pull-right">
                  @permission('driver-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="invoicelist"/>
                    <input type="hidden" name="negative_sale" value="ok">
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                    @endpermission 
             </div>



        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="nagative_sale_alert">
                <thead>
                    <tr> 
                        <th>@lang('layout.InvoiceNumber')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.CustomerName')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
</div>  


</div>
</div>

  
</div>

@stop

@push('scripts')

<script>


      // delete item by ajax
      function  DisableItemAjax(element,datatableId) {
        var e = $(element);  
        var form = e.parent('form').get(0);
        var url= $(form).get(0).action;
        var table=$(datatableId).DataTable();
        
       swal({
           title: "@lang('layout.AreYouSure?')",
           icon: "warning",
           buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
           dangerMode: true,
       }).then((willDelete) => {
           if (willDelete) {
                    $.ajax({
                    type:'PATCH',
                    url:url,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function(result)
                    {
                       // swal("{{__('message.DSuccess')}}",result.message);
                       
                        toastr.success('',result.message);
                        table.ajax.reload();
                    },
                    error:function(error){
                         swal("{{__('message.Warning')}}",error.responseJSON.message);
                        
                    }
                });
           } else {
               swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
               });
               return false;
           }
       });

   }




    $('#sale_alert').DataTable( {
			ajax:{
				url:'{{route("systemAlerts.sale_purchase_alert")}}',
				data:{type:'sale_alert'}
			  },
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
			destroy:true,
            columns: [  
                    {data: 'number', name: 'sales.number'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'type', name: 'sales.type'},
                    {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'date', name: 'date'},
                    {data: 'overdue_date', name: 'overdue_date'},
                    {data: 'discount', name: 'sales.discount'},
                    {data: 'description', name: 'sales_orders.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}




            ] 



    }); 


$(document).ready(function(){
   $('#tab-trasnport').on('shown.bs.tab', function(event){
    $('#purchase_alert').DataTable( {
      ajax:{
        url:'{{route("systemAlerts.sale_purchase_alert")}}',
        data:{type:'purchase_alert'}
        },
            scrollCollapse: true,
            serverSide: true,
            paging: true,
      destroy:true,
            columns: [  
                    {data: 'number', name: 'number'},
                    {data: 'vendor', name: 'members.name'},
                    {data: 'type', name: 'purchases.type', orderable: false, searchable: false},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'overdue_date', name: 'overdue_date', orderable: false, searchable: false},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'currency', name: 'currency', width: "10%", orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', width: "10%", orderable: false, searchable: false},
                    {data: 'description', name: 'purchases.description', width: "10%"},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}

            ] 

    }); 
    }); 
});



$(document).ready(function(){
   $('#tab-nega_sale').on('shown.bs.tab', function(event){
    $('#nagative_sale_alert').DataTable( {
      ajax:{
        url:'{{route("systemAlerts.sale_purchase_alert")}}',
        data:{type:'nagative_sale_alert'}
        },
            scrollCollapse: true,
            serverSide: true,
            paging: true,
      destroy:true,
            columns: [
                {data: 'number', name: 'sales.number'},
                {data: 'ref_no', name: 'sales.ref_no'},
                {data: 'member_name', name: 'members.name'},
                {data: 'account_name', name: 'account_name', orderable: false, searchable: false},
                {data: 'date', name: 'sales.date'},
                {data: 'username', name: 'username', orderable: false, searchable: false},
                {data: 'description', name: 'sales.description'},
                {data: 'actions', name: 'account', orderable: false, searchable: false}
            ] 

    }); 
    }); 
});





//Start Export Modal
 var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});


 // start app
new Vue({
    el: '#app',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});
 // start app
new Vue({
    el: '#app2',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});

$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
}) 
$('#print_pdf_all2').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
}) 

//End Export Modal


</script>


@endpush