@extends('layouts.app')
@section('content')
@section('style')
<style>
    .modal-container {
        width: 50% !important;
    }
</style>
@endsection

@include('loans.modal')
@include('drawings.modal')

</style>
  <!-- new modal -->

  <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'receive_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>  

<div id="print-modal-pay">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'pay_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>

<!-- /new modal -->



<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')-- <span style="color: red">@lang('menu.ReceiveAndPayment')</span></span>
        </div>
        <div class="tools"> </div>
    </div>
</div>


<div class="tabbable-line tabbable-custom-profile">
    <ul class="nav nav-tabs">
                
        <li class="active">
            <a href="#tab2" data-toggle="tab">@lang('menu.Receive')</a>
        </li>
        <li >
            <a href="#tab3" data-toggle="tab">@lang('menu.Payment')</a>
        </li>
    </ul>
    <div class="tab-content padding" style="padding: 0px;">
        <div class="tab-pane active" id="tab2">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('menu.Receive') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            <span id="anchore-modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="recevieAlertTable">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Name')</th>
                                    <th>@lang('layout.Account')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                    <th>@lang('layout.Type')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.OverdueDate')</th>
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Description')</th>
                                    @if(systemConfig()[5] != 0 )
                                    <th>@lang('layout.Status')</th>
                                    @endif
                                    <th>@lang('layout.Actions')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>        
        
        <div class="tab-pane" id="tab3">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('menu.Payment') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            <span id="anchore-modal-pay">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="payAlertTable">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Name')</th>
                                    <th>@lang('layout.Account')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.OverdueDate')</th>
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Status')</th>
                                    <th>@lang('layout.Actions')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
       


    </div>
</div>


@stop
@include('print.modal')

@push('scripts')

<script>

// Disable item by ajax
function DisableItemAjax(element, datatableId) {
    var e = $(element);
    var form = e.parent('form').get(0);
    var url = $(form).get(0).action;
    var table = $(datatableId).DataTable();

    swal({
        title: "@lang('layout.AreYouSure?')",
        icon: "warning",
        buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: 'PATCH',
                url: url,
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                success: function(result) {
                    // swal("{{__('message.DSuccess')}}",result.message);

                    toastr.success('', result.message);
                    table.ajax.reload();
                },
                error: function(error) {
                    swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        } else {
            swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
            });
            return false;
        }
    });

}
   
    
//DataTable Part
$(document).ready(function() {
    $('#recevieAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.receiveAndPay")}}',
            data: {
                type: 'recevies'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {data: 'number', name: 'receivable_payments.number'},
            {data: 'ref_no', name: 'receivable_payments.ref_no'},
            {data: 'name', name: 'members.name'},
            {data: 'account', name: 'account', orderable: false, searchable: false},
            {data: 'currency', name: 'currency', orderable: false, searchable: false},
            {data: 'rate', name: 'rate', orderable: false, searchable: false},
            {data: 'type', name: 'type', orderable: false, searchable: false},
            {data: 'amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'date', name: 'receivable_payments.date' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'overdue_date', name: 'receivable_payments.overdue_date'},
            {data: 'username', name: 'username', orderable: false, searchable: false},
            {data: 'description', name: 'receivable_payments.description' @if(getGeneralSearch()) , searchable: false @endif},
            @if(systemConfig()[5] != 0 )
            {data: 'status', name: 'receivable_payments.status', searchable: false},
            @endif
            {data: 'actions', name: 'actions', orderable: false, searchable: false},
        ]
    });   
}); 

$(document).ready(function() {
    $('#payAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.receiveAndPay")}}',
            data: {
                type: 'pay'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {data: 'payment_number', name: 'payments.number'},
            {data: 'ref_no', name: 'payments.ref_no'},
            {data: 'Name', name: 'members.name'},
            {data: 'Account', name: 'Account', orderable: false, searchable: false},
            {data: 'currency', name: 'currency', orderable: false, searchable: false},
            {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
            {data: 'amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'Date', name: 'payments.date' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'overdue_date', name: 'payments.overdue_date'},
            {data: 'username', name: 'username', orderable: false, searchable: false},
            {data: 'Description', name: 'payments.description' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'payment_status', name: 'payment_status', orderable: false, searchable: false},
            {data: 'actions', name: 'actions', orderable: false, searchable: false},
        ]
    });   
});       
    


//Print Modal     
var vm = new Vue({
    el: '#print-modal',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal',
    methods: {
        showModal: function () {
            vm.$data.is_show = true;
        }
    }
});

var vml = new Vue({
    el: '#print-modal-pay',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal-pay',
    methods: {
        showModal: function () {
            vml.$data.is_show = true;
        }
    }
});


</script>


@endpush