@extends('layouts.app')
@section('content')
@include('loans.modal')

<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET-->


<!-- BEGIN Change Item -->
<div id="app" v-cloak>
   {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
  <input type="hidden" name="type" value="change_item_alert"/>
  <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false" >
    <div slot="body">
        <div class="row">
            <div class="form-group">

            <div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    <option  value="on">@lang('layout.On')</option>
                    <option  value="off">@lang('layout.Off')</option>
                    <option  value="pending">@lang('layout.Pending')</option>
                 
                </select>
            </div>


        </div>

    </div>
  
</div>
<div slot="footer">
    <button type="submit" class="btn btn-success" @click="ok">
        @lang('layout.Submit')
    </button>
    <button type="button" class="btn btn-danger" @click="close">
        @lang('layout.Cancel')
    </button>
</div>
</modal>
{{Form::close()}}
</div>
<!-- End Change Item -->
<!-- BEGIN Change Item -->
<div id="app2" v-cloak>
   {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
  <input type="hidden" name="type" value="of_pendig_alert"/>
  <button id="show-modal2" style="display: none" type="button" @click="editExample">Show Modal</button>
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false" >
    <div slot="body">
        <div class="row">
            <div class="form-group">

            <div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    <option  value="off">@lang('layout.Off')</option>
                    <option  value="pending">@lang('layout.Pending')</option>
                 
                </select>
            </div>


        </div>

    </div>
  
</div>
<div slot="footer">
    <button type="submit" class="btn btn-success" @click="ok">
        @lang('layout.Submit')
    </button>
    <button type="button" class="btn btn-danger" @click="close">
        @lang('layout.Cancel')
    </button>
</div>
</modal>
{{Form::close()}}
</div>
<!-- End Change Item -->

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
             <!--div class="btn-group pull-right">
                @permission('services-export')
                   
          					<a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
          					</a>
                @endpermission
            </div-->
        </div>
     </div>
	
	
	<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">  
    <li class="active">
        <a href="#expenseAlls" data-toggle="tab" id="expenseAll"> @lang('layout.ExpenseList') </i></a>
     </li> 
     <li class="">
        <a href="#DailyExpenses" data-toggle="tab" id="DailyExpense"> @lang('layout.DailyExpense') </i></a>
     </li>
     <li>
        <a href="#deliveryItems" data-toggle="tab" id="deliveryItemsTab"> @lang('layout.ProjectDelivery') </a>
    </li>
    <li>
        <a href="#projectDeliveryService" data-toggle="tab" id="projectDeliveryServiceTab"> @lang('layout.ProjectDeliveryService') </a>
    </li>
    <li>
        <a href="#paySalaryExpenses" data-toggle="tab" id="paySalaryExpense"> @lang('layout.PayrollList')</a>
    </li>
    <li>
        <a href="#receivablePayment" data-toggle="tab" id="recevie"> @lang('layout.ProjectRecevies') </i></a>
    </li>
   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="expenseAlls">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.ExpenseList')</span>
            </div>
            <div class="actions">
            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="ExpenseList"/>
            <input type="hidden" name="status" value="pending"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
            {{Form::close()}}
            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="ExpenseList"/>
            <input type="hidden" name="status" value="pending"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="expenseAlls_table">
                <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Project')</th>
                        <th>@lang('layout.Vendor')</th>
                        <th>@lang('layout.Account') </th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions') </th>
                    </tr>
                </thead>
            </table>
        </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 
    <div class="tab-pane" id="DailyExpenses">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.DailyExpense')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="dailyExpenses"/>
                    <input type="hidden" name="status" value="pending"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="dailyExpenses"/>
                    <input type="hidden" name="status" value="pending"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="dailyExpenses_table">
                        <thead>
                            <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Project')</th>
                            <th>@lang('layout.BankAccount')</th>
                            <th>@lang('layout.ExpenseAccount') </th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Actions') </th>
                            </tr>
                        </thead>
                    </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 

    <div class="tab-pane" id="deliveryItems">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.ProjectDelivery')</span>
                </div>
                <div class="actions">
                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="deliveryItems"/>
                <input type="hidden" name="status" value="pending"/>
                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                {{Form::close()}}
                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="deliveryItems"/>
                <input type="hidden" name="status" value="pending"/>
                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="deliveryItems_table">
                    <thead>
                        <tr>
                                <th>@lang('layout.Project')</th>
                                <th>@lang('layout.Item')</th>
                                <th>@lang('layout.Site')</th>
                                <th>@lang('layout.Quantity')</th>
                                <th>@lang('layout.Measure')</th>
                                <th>@lang('layout.Cost')</th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Status')</th>
                                <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 

    <div class="tab-pane" id="projectDeliveryService">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ProjectDeliveryService')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="ProjectDelivery_service_details"/>
                    <input type="hidden" name="status" value="pending"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="ProjectDelivery_service_details"/>
                    <input type="hidden" name="status" value="pending"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="projectDeliveryService_table">
                    <thead>
                        <tr>
                        <th>@lang('layout.Project')</th>
                        <th>@lang('layout.ItemName')</th>
                        <th>@lang('layout.MeasureUnit')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Price')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 

    <div class="tab-pane" id="paySalaryExpenses">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.PayrollList')</span>
                </div>
                <div class="actions">
                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="all_payrolls"/>
                <input type="hidden" name="status" value="pending"/>
                <!-- <input type="hidden" name="category" value="1"/> -->
                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                {{Form::close()}}
                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="all_payrolls"/>
                <input type="hidden" name="status" value="pending"/>
                <!-- <input type="hidden" name="category" value="1"/> -->
                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="paySalaryExpenses_table">
                        <thead>
                            <tr>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.BasicSalary')</th>
                            <th>@lang('layout.Tax')</th>
                            <th>@lang('layout.WorkedDay')</th>
                            <th>@lang('layout.AbsentDays')</th>
                            <th>@lang('layout.NetPayable')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.ExpenseAccount')</th>
                            <th>@lang('layout.FromDate')</th>
                            <th>@lang('layout.ToDate')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Project')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Actions')</th>
                            </tr>
                        </thead>
                    </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 

    <div class="tab-pane" id="receivablePayment">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.Recevies')</span>
            </div>
            <div class="actions">
            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="receivablePaymentShow"/>
            <input type="hidden" name="status" value="pending"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
            {{Form::close()}}
            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="receivablePaymentShow"/>
            <input type="hidden" name="status" value="pending"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="receivablePayment_table">
                    <thead>
                        <tr>
                            <!-- <th>@lang('layout.Name')</th> -->
                            <th>@lang('layout.Project')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
        </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

</div>
</div>


<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop

@push('scripts')

<script>


      // delete item by ajax
      function  DisableItemAjax(element,datatableId) {
        var e = $(element);  
        var form = e.parent('form').get(0);
        var url= $(form).get(0).action;
        var table=$(datatableId).DataTable();
        
       swal({
           title: "@lang('layout.AreYouSure?')",
           icon: "warning",
           buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
           dangerMode: true,
       }).then((willDelete) => {
           if (willDelete) {
                    $.ajax({
                    type:'PATCH',
                    url:url,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function(result)
                    {
                       // swal("{{__('message.DSuccess')}}",result.message);
                       
                        toastr.success('',result.message);
                        table.ajax.reload();
                    },
                    error:function(error){
                         swal("{{__('message.Warning')}}",error.responseJSON.message);
                        
                    }
                });
           } else {
               swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
               });
               return false;
           }
       });

   }



$(document).ready(function(){
    $('#expenseAlls_table').DataTable({  
        scrollCollapse: true,
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        serverSide: true,
        paging: true,
        retrieve: true,
        ajax:{
        url:'{{route("projects.pending")}}',
        data:{type:'expenseAll'}
        },
        columns: [
        {data: 'number', name: 'number'},
        {data: 'project', name: 'projects.name'},
        {data: 'vendor', name: 'members.name'},
        {data: 'account', name: 'accounts.name'},
        {data: 'date', name: 'purchases.date'},
        {data: 'amount', name: 'transactions.amount'},
        {data: 'currency', name: 'currency', orderable: false, searchable: false},
        {data: 'status', name: 'expenses.status', searchable: false},
        {data: 'username', name: 'username', orderable: false, searchable: false},
        {data: 'description', name: 'purchases.description'},
        {data: 'actions', name: 'actions', orderable: false, searchable: false}
        ]
    });  
});	


$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#DailyExpense').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#dailyExpenses_table').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
            url:'{{route("projects.pending")}}',
            data:{type:'DailyExpense'}
            },
            columns: [
            {data: 'number', name: 'number'},
            {data: 'project_name', name: 'projects.name'},
            {data: 'Bank', name: 'accounts.name'},
            {data: 'expense_account', name: 'accounts.name'},
            {data: 'date', name: 'daily_expenses.date'},
            {data: 'amount', name: 'transactions.amount'},
            {data: 'currency', name: 'currency', orderable: false, searchable: false},
            {data: 'username', name: 'username', orderable: false, searchable: false},
            {data: 'description', name: 'daily_expenses.description'},
            {data: 'status', name: 'daily_expenses.status', searchable: false},
            {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ]
        });  
    });
});
	
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#deliveryItemsTab').on('shown.bs.tab', function(event){
       $('#deliveryItems_table').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
            url:'{{route("projects.pending")}}',
            data:{type:'deliveryItems'}
            },
            columns: [  
            {data: 'project', name: 'project'},
            {data: 'item', name: 'item'},
            {data: 'site', name: 'site'},
            {data: 'qty', name: 'qty'},
            {data: 'measure', name: 'measure'},
            {data: 'cost', name: 'cost'},
            {data: 'date', name: 'date'}, 
            {data: 'status', name: 'status'}, 
            {data: 'actions', name: 'actions'}, 
            ]
        });  
    });
});

$(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#projectDeliveryServiceTab').on('shown.bs.tab', function(event){
        $('#projectDeliveryService_table').DataTable({  
            retrieve: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
			ajax:{
                url:'{{route("projects.pending")}}',
                data:{type:'deliveryServiceItems'}
                },
            columns: [
                { data: 'project', name: 'project' },
                { data: 'item', name: 'item' },
                { data: 'measure', name: 'measure_unit' },
                { data: 'qty', name: 'qty' },
                { data: 'cost', name: 'cost' },
                {data: 'date', name: 'date'}, 
                {data: 'status', name: 'status'}, 
                {data: 'actions', name: 'actions'}, 
        ]
        });  
    });
});

$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#paySalaryExpense').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#paySalaryExpenses_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url:'{{route("projects.pending")}}',
                data:{type:'paySalaryExpenses'}
                },
              columns: [
                    {data: 'Employee', name: 'members.name'},
                    {data: 'BasicSalary', name: 'BasicSalary', orderabel: false, searchable: false},
                    {data: 'tax_amount', name: 'tax_amount', orderabel: false, searchable: false},
                    {data: 'Worked_Days', name: 'Worked_Days', orderabel: false, searchable: false},
                    {data: 'absent_day', name: 'absent_day', orderabel: false, searchable: false},
                    {data: 'Net_Payable', name: 'Net_Payable', orderabel: false, searchable: false},
                    {data: 'Curreny', name: 'Curreny', orderabel: false, searchable: false},
                    {data: 'account', name: 'account', orderabel: false, searchable: false},
                    {data: 'exAccount', name: 'exAccount', orderabel: false, searchable: false},
                    {data: 'From_Date', name: 'From_Date', orderabel: false, searchable: false},
                    {data: 'To_Date', name: 'To_Date', orderabel: false, searchable: false},
                    {data: 'Date', name: 'Date', orderabel: false, searchable: false},
                    {data: 'project_name', name: 'projects.name'},
                    {data: 'status', name: 'payrolls.status', searchable: false},
                    {data: 'description', name: 'payrolls.description'},
                    {data: 'actions', name: 'actions', orderabel: false, searchable: false},
              ]
          });  
          });
});

$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#recevie').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#receivablePayment_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("projects.pending")}}',
                data:{type:'receivablePayment'}
                },
              columns: [
                  // { data: 'name',         name: 'members.name' },
                  { data: 'project',      name: 'project'},
                  { data: 'account',      name: 'account',orderable:false,searchable:false },
                  { data: 'currency',     name: 'currency',orderable:false,searchable:false },
                  { data: 'rate',         name: 'rate',orderable:false,searchable:false },
                  { data: 'type',         name: 'type' ,orderable:false,searchable:false},
                  { data: 'amount',       name: 'amount',orderable:false,searchable:false },
                  { data: 'date',         name: 'date' ,orderable:false,searchable:false},
                  {data: 'status', name: 'status', searchable: false},
                  {data: 'actions', name: 'actions', orderable: false, searchable: false},
              ]
          });  
    });
});

//Start Export Modal
 var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});


 // start app
new Vue({
    el: '#app',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});
 // start app
new Vue({
    el: '#app2',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});

$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
}) 
$('#print_pdf_all2').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
}) 

//End Export Modal


</script>


@endpush