@extends('layouts.app')
@section('content')
@include('loans.modal')


<div class="">

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.Alerts')</span>
            </div>
            <div class="tools"> </div>
            <!--div class="btn-group pull-right">
                @permission('services-export')
                   
                    <a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
                    </a>
                @endpermission
            </div-->
        </div>
    </div>

    <div class="tabbable-line tabbable-custom-profile">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
                    <i class="fa  "></i><b> @lang('menu.DepositAndWithdrawal') </b></a>
            </li>
            <li class="">
                <a href="#ex-transfer" data-toggle="tab" id="tab-transfer" style="color: red">
                    <i class="fa  "></i><b> @lang('menu.Cheque') </b></a>
            </li>
            <li class="">
                <a href="#ex-currencyExchange" data-toggle="tab" id="tab-currencyExchange" style="color: red">
                    <i class="fa  "></i><b> @lang('menu.CurrencyExchange') </b></a>
            </li>
            <li class="">
                <a href="#ex-memberTransfer" data-toggle="tab" id="tab-memberTransfer" style="color: red">
                    <i class="fa  "></i><b> @lang('menu.MemberTransfer') </b></a>
            </li>

        </ul>
        <div class="tab-content padding" style="padding: 0px;">
            <div class="tab-pane active" id="both">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('menu.DepositAndWithdrawal')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="pull-right">
                                    {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="loan_alert" />
                                    <input type="hidden" name="due_date" value="on" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}} --}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="loan">
                                    <thead>
                                        <tr>
                                        <th>@lang('layout.Number')</th>
                                        <th>@lang('layout.ReferenceNumber')</th>
                                        <th>@lang('layout.Member')</th>
                                        <th>@lang('layout.Account')</th>
                                        <th>@lang('layout.Amount')</th>
                                        <th>@lang('layout.Currency')</th>
                                        <th>@lang('layout.Rate')</th>
                                        <th>@lang('layout.Type')</th>
                                        <th>@lang('layout.TransactionType')</th>
                                        <th>@lang('layout.User')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>
            
            <div class="tab-pane" id="ex-transfer">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('menu.Cheque')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="pull-right">
                                    {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="loan_alert" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}} --}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="cheque">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.ReferenceNumber')</th>
                                            <th>@lang('layout.Member')</th>
                                            <th>@lang('layout.Account')</th>
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Type')</th>
                                            <th>@lang('layout.TransactionType')</th>
                                            <th>@lang('layout.User')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="ex-currencyExchange">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('menu.CurrencyExchange')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="pull-right">
                                    {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="loan_alert" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}} --}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="currencyExchange">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.ReferenceNumber')</th>
                                            <th>@lang('layout.Member')</th>
                                            <th>@lang('layout.Account')</th>
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Type')</th>
                                            <th>@lang('layout.TransactionType')</th>
                                            <th>@lang('layout.User')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="ex-memberTransfer">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('menu.MemberTransfer')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="pull-right">
                                    {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="loan_alert" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}} --}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="memberTransfer">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.Member')</th>
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.TransactionType')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>

        </div>
    </div>


</div>

@stop

@push('scripts')

<script>
    // delete item by ajax
    function DisableItemAjax(element, datatableId) {
        var e = $(element);
        var form = e.parent('form').get(0);
        var url = $(form).get(0).action;
        var table = $(datatableId).DataTable();

        swal({
            title: "@lang('layout.AreYouSure?')",
            icon: "warning",
            buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: 'PATCH',
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    success: function(result) {
                        // swal("{{__('message.DSuccess')}}",result.message);

                        toastr.success('', result.message);
                        table.ajax.reload();
                    },
                    error: function(error) {
                        swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            } else {
                swal({
                    buttons: "@lang('layout.Confirm')",
                    title: "@lang('layout.FileIsSave')",
                });
                return false;
            }
        });

    }


    $(document).ready(function() {

        $('#loan').DataTable({
            ajax: {
                url: '{{route("systemAlerts.positionAlerts")}}',
                data: {
                    type: 'loan'
                }
            },
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            destroy: true,
            columns: [
                {
                    data: 'number',
                    name: 'number'
                },
                {
                    data: 'ref_no',
                    name: 'ref_no'
                },
                {
                    data: 'Member',
                    name: 'Member'
                },
                {
                    data: 'Account',
                    name: 'Account',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'tr_amount',
                    name: 'tr_amount'
                },
                {
                    data: 'currency',
                    name: 'currency',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'type',
                    name: 'type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'trans_type',
                    name: 'trans_type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'user',
                    name: 'user',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'Date',
                    name: 'Date'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });


        $('#tab-transfer').on('shown.bs.tab', function(event) {

            $('#cheque').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.positionAlerts")}}',
                    data: {
                        type: 'cheque'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [
                    {
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'ref_no',
                        name: 'ref_no'
                    },
                    {
                        data: 'Member',
                        name: 'Member'
                    },
                    {
                        data: 'Account',
                        name: 'Account',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'tr_amount',
                        name: 'tr_amount'
                    },
                    {
                        data: 'currency',
                        name: 'currency',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate',
                        name: 'rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'type',
                        name: 'type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'trans_type',
                        name: 'trans_type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'user',
                        name: 'user',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'Date',
                        name: 'Date'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

        });

        $('#tab-currencyExchange').on('shown.bs.tab', function(event) {

            $('#currencyExchange').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.positionAlerts")}}',
                    data: {
                        type: 'currencyExchange'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [
                    {
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'ref_no',
                        name: 'ref_no'
                    },
                    {
                        data: 'Member',
                        name: 'Member'
                    },
                    {
                        data: 'Account',
                        name: 'Account',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'tr_amount',
                        name: 'tr_amount'
                    },
                    {
                        data: 'currency',
                        name: 'currency',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate',
                        name: 'rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'type',
                        name: 'type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'trans_type',
                        name: 'trans_type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'user',
                        name: 'user',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'Date',
                        name: 'Date'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

        });
        
        $('#tab-memberTransfer').on('shown.bs.tab', function(event) {

            $('#memberTransfer').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.positionAlerts")}}',
                    data: {
                        type: 'memberTransfer'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [
                    {
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'Member',
                        name: 'Member'
                    },
                    {
                        data: 'tr_amount',
                        name: 'tr_amount'
                    },
                    {
                        data: 'currency',
                        name: 'currency',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate',
                        name: 'rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'trans_type',
                        name: 'trans_type'
                    },
                    {
                        data: 'Date',
                        name: 'Date'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

        });
        
    });


    //Start Export Modal
    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });


    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    // start app
    new Vue({
        el: '#app2',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    $('#print_pdf_all').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    })
    $('#print_pdf_all2').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    })

    //End Export Modal
</script>


@endpush