@extends('layouts.app')
@section('content')
@include('loans.modal')


<div class="row">

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.OnlineOrders')</span>
            </div>
            <div class="tools"> </div> 
            <div class="pull-right">
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="onlineOrder"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
            </div>
        </div>
  
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="onlineOrder">
                <thead>
                <tr> 
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.Customer')</th>
                    <th>@lang('layout.Phone')</th>
                    <th>@lang('layout.Currency')</th>
                    <th>@lang('layout.Date')</th>
                    <th>@lang('layout.DeliveryDate')</th>
                    <th>@lang('layout.Amount')</th>
                    <th width="20%">@lang('layout.Description')</th>
                    <th>@lang('layout.Action')</th>
                </tr>
                </thead>
            </table>
        </div>
  
        </div>
</div>

@stop

@push('scripts')

<script>


      // delete item by ajax
      function  DisableItemAjax(element,datatableId) {
        var e = $(element);  
        var form = e.parent('form').get(0);
        var url= $(form).get(0).action;
        var table=$(datatableId).DataTable();
        
       swal({
           title: "@lang('layout.AreYouSure?')",
           icon: "warning",
           buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
           dangerMode: true,
       }).then((willDelete) => {
           if (willDelete) {
                    $.ajax({
                    type:'PATCH',
                    url:url,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function(result)
                    {
                       // swal("{{__('message.DSuccess')}}",result.message);
                       
                        toastr.success('',result.message);
                        table.ajax.reload();
                    },
                    error:function(error){
                         swal("{{__('message.Warning')}}",error.responseJSON.message);
                        
                    }
                });
           } else {
               swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
               });
               return false;
           }
       });

   }

    $(document).ready(function(){
        $('#onlineOrder').DataTable( {
                ajax:{
                    url:'{{route("systemAlerts.onlineOrder")}}',
                    data:{type:'sale_order'}
                },
                scrollCollapse: true,
                serverSide: true,
                paging:         true,
                destroy:true,
                columns: [  
                    {data: 'number', name: 'number'},
                    {data: 'name', name: 'name'},
                    {data: 'phone', name: 'phone'},
                    {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'date', name: 'date'},
                    {data: 'delivery_date', name: 'delivery_date'},
                    {data: 'price', name: 'price', orderable: false, searchable: false},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ] 



        }); 

    });





//Start Export Modal
 var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});


 // start app
new Vue({
    el: '#app',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});
 // start app
new Vue({
    el: '#app2',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});

$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
}) 
$('#print_pdf_all2').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
}) 

//End Export Modal


</script>


@endpush