@extends('layouts.app')
@section('content')
@include('loans.modal')

<!-- END PAGE HEADER-->

<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'AlertListMin'"
                  @closed="closeModal">
                  <div slot="body">
                    <div class="row">
                        <div class="col-md-6">
                            <label for=""> @lang('layout.SelectSite') </label>
                            <v-select label="name"
                            v-model="selectedInventorySite" :options="inventorySite">
                          </v-select> 
                          <input type="hidden" name="site_id"
                             v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id"> 
                        </div>
                    </div> 
                </div>
    </report-modal>
</div>


<div id="printModalMax">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'AlertListMax'" 
                  @closed="closeModalMax">
                  <div slot="body">
                    <div class="row">
                        <div class="col-md-6">
                            <label for=""> @lang('layout.SelectSite') </label>
                            <v-select label="name"
                            v-model="selectedInventorySite" :options="inventorySite">
                          </v-select> 
                          <input type="hidden" name="site_id"
                             v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id"> 
                        </div>
                    </div> 
                </div>
    </report-modal>
</div>

<!-- BEGIN TAB PORTLET-->


<!-- BEGIN Change Item -->
<div id="app" v-cloak>
   {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
  <input type="hidden" name="type" value="change_item_alert"/>
  <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false" >
    <div slot="body">
        <div class="row">
            <div class="form-group">

            <div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    <option  value="on">@lang('layout.On')</option>
                    <option  value="off">@lang('layout.Off')</option>
                    <option  value="pending">@lang('layout.Pending')</option>
                 
                </select>
            </div>

        </div>

    </div>
  
</div>
<div slot="footer">
    <button type="submit" class="btn btn-success" @click="ok">
        @lang('layout.Submit')
    </button>
    <button type="button" class="btn btn-danger" @click="close">
        @lang('layout.Cancel')
    </button>
</div>
</modal>
{{Form::close()}}
</div>
<!-- End Change Item -->
<!-- BEGIN Change Item -->
<div id="app2" v-cloak>
   {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
  <input type="hidden" name="type" value="of_pendig_alert"/>
  <button id="show-modal2" style="display: none" type="button" @click="editExample">Show Modal</button>
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false" >
    <div slot="body">
        <div class="row">
            <div class="form-group">

            <div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    <option  value="off">@lang('layout.Off')</option>
                    <option  value="pending">@lang('layout.Pending')</option>
                 
                </select>
            </div>


        </div>

    </div>
  
</div>
<div slot="footer">
    <button type="submit" class="btn btn-success" @click="ok">
        @lang('layout.Submit')
    </button>
    <button type="button" class="btn btn-danger" @click="close">
        @lang('layout.Cancel')
    </button>
</div>
</modal>
{{Form::close()}}
</div>
<!-- End Change Item -->



    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
             <!--div class="btn-group pull-right">
                @permission('services-export')
                   
          					<a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
          					</a>
                @endpermission
            </div-->
        </div>
     </div>
	
	
	<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">  
    <li class="active">
      <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
       <i class="fa  "></i><b> @lang('layout.MinItem') </b></a>
     </li> 
     <li class="">
      <a href="#MaxItem" data-toggle="tab" id="tab-max" style="color:red">
       <i class="fa  "></i><b> @lang('layout.MaxItem') </b></a>
     </li> 
     <li class="">
      <a href="#qut-in" data-toggle="tab" id="tab-off" style="color: red">
       <i class="fa  "></i><b> @lang('layout.ItemDateExpiar') </b></a>
     </li>
     <li class="">
      <a href="#item_expiar_code" data-toggle="tab" id="item-expiar-code" style="color: red">
       <i class="fa  "></i><b> @lang('layout.ExpiarModelItem') </b></a>
     </li>
    


   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="both">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="row" id="search_data">
                <div class="col-md-3" style="margin-bottom: 10px;">
                <label for=""> @lang('layout.SelectSite') </label> 
                <select name="site_id"  @input="getData()"   v-model="site_id" class="form-control">
                    <option value="0">@lang('layout.SelectSite')</option>
                    @foreach($inventorySite as $row)
                    <option value="{{$row['id']}}">{{$row['name']}}</option>
                    @endforeach
                </select> 
                </div>
            </div>
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
               <div class="pull-right">
                @permission('services-export')
                    {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="AlertListMin"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}} --}}

                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                           <i class="fa fa-print"></i>
                        </a>
                    </span>
                    
                    {{-- {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="AlertListMin"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    --}}
                @endpermission
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="alertList_on">
                <thead>
                <tr> 
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.MeasureUnit')</th>
                    <th>@lang('layout.OnHand')</th>
                    <th>@lang('layout.Min')</th>
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
      </div>
  </div>  
  <div class="tab-pane" id="MaxItem">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="row" id="search_data_max">
                <div class="col-md-3" style="margin-bottom: 10px;" >
                <label for=""> @lang('layout.SelectSite') </label>
                <select name="site_id_max" @input="getDataMax()"  v-model="site_id_max" class="form-control">
                    <option value="0">@lang('layout.SelectSite')</option>
                    @foreach($inventorySite as $row)
                    <option value="{{$row['id']}}">{{$row['name']}}</option>
                    @endforeach
                </select> 

                </div>
            </div>

            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
               <div class="pull-right">
                @permission('services-export')
                    {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="AlertListMax"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}

                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="AlertListMax"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}} --}}

                    <span id="anchoreModalMax">
                        <a href="#" @click.prevent="showModalMax" id="" class="btn  btn-success">
                           <i class="fa fa-print"></i>
                        </a>
                    </span>

                   
                @endpermission
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="alertList_max">
                <thead>
                <tr> 
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.MeasureUnit')</th>
                    <th>@lang('layout.OnHand')</th>
                    <th>@lang('layout.Max')</th>
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
      </div>
  </div> 
  <div class="tab-pane" id="qut-in">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
            <div class="btn-group pull-right">
				@permission('services-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="ItemDateExpiar"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                @endpermission            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="alertList_off">
                <thead>
                <tr> 
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.MeasureUnit')</th>
                    <th>@lang('layout.OnHand')</th>
                    <th>@lang('layout.Date')</th>
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

  <div class="tab-pane" id="item_expiar_code">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
            <div class="btn-group pull-right">
				@permission('services-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="ItemDateExpiarCode"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                @endpermission            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="item_expiar_code_data">
                <thead>
                <tr> 
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.MeasureUnit')</th>
                    <th>@lang('layout.OnHand')</th>
                    <th>@lang('layout.Date')</th>
                    <th>@lang('layout.Actions')</th>
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>


</div>
</div>

	

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@push('scripts')

<script>


      // delete item by ajax
      function  DisableItemAjax(element,datatableId) {
        var e = $(element);  
        var form = e.parent('form').get(0);
        var url= $(form).get(0).action;
        var table=$(datatableId).DataTable();
        
       swal({
           title: "@lang('layout.AreYouSure?')",
           icon: "warning",
           buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
           dangerMode: true,
       }).then((willDelete) => {
           if (willDelete) {
                    $.ajax({
                    type:'PATCH',
                    url:url,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function(result)
                    {
                       // swal("{{__('message.DSuccess')}}",result.message);
                       
                        toastr.success('',result.message);
                        table.ajax.reload();
                    },
                    error:function(error){
                         swal("{{__('message.Warning')}}",error.responseJSON.message);
                        
                    }
                });
           } else {
               swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
               });
               return false;
           }
       });

   }

   let data_table;
   function getRecord() {
    data_table = $('#alertList_on').DataTable({
                ajax: {
                    ajax: '{{route("systemAlerts.minItem")}}',
                    data: {
                        site_id: vtr.site_id,
                        type:'min_item'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy:true,
                columns: [  
                { data: 'number', name: 'number', searchable: false },
                { data: 'name', name: 'items.name' },
                { data: 'measure', name: 'measure', searchable: false },
                { data: 'inve_amount', name: 'inve_amount', searchable: false },
                { data: 'min', name: 'min', searchable: false },
                ] 

        }); 
   } 
   $(document).ready(function() {
        getRecord();
    });


let data_table_max; 
function getRecordMax() {
    data_table_max = $('#alertList_max').DataTable( {
            ajax: {
                ajax: '{{route("systemAlerts.minItem")}}',
                data: {
                    site_id_max: vtrmax.site_id_max,
                    type:'max_item'
                }
            },
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
			destroy:true,
            columns: [  
            { data: 'number', name: 'number', searchable: false },
            { data: 'name', name: 'items.name' },
            { data: 'measure', name: 'measure', searchable: false },
            { data: 'inve_amount', name: 'inve_amount', searchable: false },
            { data: 'max', name: 'max', searchable: false },
            ] 
    });  
}

$(document).ready(function() {
        getRecordMax();
    });


$(document).ready(function(){
  $('#tab-off').on('shown.bs.tab', function(event){

    $('#alertList_off').DataTable( {
			ajax:{
				url:'{{route("systemAlerts.minItem")}}',
				data:{type:'dateExpiar'}
			  },
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
			destroy:true,
            columns: [  
            { data: 'number', name: 'number', searchable: false },
            { data: 'name', name: 'items.name' },
            { data: 'measure', name: 'measure', searchable: false },
            { data: 'inve_amount', name: 'inve_amount', searchable: false },
            { data: 'date', name: 'date', searchable: false },
            ] 
    });  
  });
});	

$(document).ready(function(){
  $('#item-expiar-code').on('shown.bs.tab', function(event){

    $('#item_expiar_code_data').DataTable( {
			ajax:{
				url:'{{route("systemAlerts.minItem")}}',
				data:{type:'item_expiar_code'}
			  },
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
			destroy:true,
            columns: [  
            { data: 'code', name: 'code', orderable: false, searchable: false },
            { data: 'name', name: 'items.name' },
            { data: 'measure', name: 'measure', orderable: false, searchable: false },
            { data: 'inve_amount', name: 'inve_amount', orderable: false, searchable: false },
            { data: 'date', name: 'date', orderable: false, searchable: false },
            { data: 'actions', name: 'actions', orderable: false, searchable: false},
            ] 
    });  
  });
});	
	

//Start Export Modal
 var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});


    var inventorySite = {!! $inventorySite !!};
 // start app
new Vue({
    el: '#app',
    data: {
        showModal: false,
        inventorySite: inventorySite,
        selectedInventorySite: null,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});
 // start app
new Vue({
    el: '#app2',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});

$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
}) 
$('#print_pdf_all2').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
}) 

//End Export Modal


        var vtr = new Vue({
            el: '#search_data',
            data: {
                site_id: 0,
                loadingSourceSel: 0,
                loadingDestinationSel: 0,
                load_type: 0,
            },
            methods: {
                getData() {
                    // console.log(322, this.site_id,this.loadingSourceSel,this.loadingDestinationSel);
                    setTimeout(() => {
                        getRecord();
                    }, 200);
                }
            }
        });
        var vtrmax = new Vue({
            el: '#search_data_max',
            data: {
                site_id_max : 0
            },
            methods: {
                getDataMax() {
                    // console.log(322, this.site_id_max);
                    setTimeout(() => {
                        getRecordMax();
                    }, 200);
                }
            }
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                inventorySite: inventorySite,
                selectedInventorySite : null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        var vmmax = new Vue({
            el: '#printModalMax',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                inventorySite: inventorySite,
                selectedInventorySite : null,
            },
            methods: {
                closeModalMax: function () {
                    this.is_show = !this.is_show
                }, 
            }
        });

        new Vue({
            el: '#anchoreModalMax',
            methods: {
                showModalMax: function () {
                    console.log('trr')
                    vmmax.$data.is_show = true;
                }
            }
        });


</script>


@endpush