@extends('layouts.app')
@section('content')
@include('loans.modal')
@include('drawings.modal')

</style>
  <!-- new modal -->

  <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'installment_alert_all'"
                  @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                   
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Customer')</label>
                        <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_employee"></v-select>
                        <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                    </div>

                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.SaleArea')</label>
                        <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                        <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                    
                    </div>


                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.MemberClass') </label>
                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                    
                    </div>
                    
   
                </div>
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>

                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<!-- /new modal -->



<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')-- <span style="color: red">@lang('layout.Installments')</span></span>
        </div>
        <div class="tools"> </div>
        <!--div class="btn-group pull-right">
                @permission('services-export')
                   
                    <a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
                    </a>
                @endpermission
            </div-->
    </div>
</div>


<div class="tabbable-line tabbable-custom-profile">
    <ul class="nav nav-tabs">
                
        <li class="active">
            <a href="#tab2" data-toggle="tab">@lang('layout.Installments') @lang('menu.Sales')</a>
        </li>
        <li class="">
            <a href="#tab3" data-toggle="tab">@lang('layout.Installments') @lang('menu.DepositAndWithdrawal')</a>
        </li>
    </ul>
    <div class="tab-content padding" style="padding: 0px;">
        <div class="tab-pane active" id="tab2">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Installments') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="installment_alert_all" />
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}} --}}
                            <span id="anchore-modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="sale_installment_all">
                            <thead>
                                <tr>
                                    <th>@lang('layout.InvoiceNumber')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.Customer')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('menu.Currency')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Status') </th>
                                    <th>@lang('layout.Action')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
        <div class="tab-pane" id="tab3">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">






                      <!-- new modal -->

  <div id="print-modaltwo">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_showtwo"
                  :value-type="'loan_installment_alert_all'"
                  @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                   
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Customer')</label>
                        <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_employee"></v-select>
                        <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                    </div>


                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.MemberClass') </label>
                        <v-select label="name" :options="memberClass" v-model="selected_classtwo" @input="memberClassChange()"></v-select>
                        <input type="hidden" name="class_id" :value="!selected_classtwo?null:selected_classtwo.id">
                    
                    </div>
                    
   
                </div>
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>

                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<!-- /new modal -->





                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Installments') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="loan_installment_alert_all" />
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}} --}}
                            <span id="anchore-modaltwo">
                                <a href="#" @click.prevent="showModaltwo" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="loan_installment_all">
                            <thead>
                                <tr>
                                    <th>@lang('layout.DepositAndWithdrawalNumber')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.Customer')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('menu.Currency')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Status') </th>
                                    <th>@lang('layout.Action')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>


       


    </div>
</div>


@stop
@include('print.modal')

@push('scripts')

<script>
    // delete item by ajax
    function DisableItemAjax(element, datatableId) {
        var e = $(element);
        var form = e.parent('form').get(0);
        var url = $(form).get(0).action;
        var table = $(datatableId).DataTable();

        swal({
            title: "@lang('layout.AreYouSure?')",
            icon: "warning",
            buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: 'PATCH',
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    success: function(result) {
                        // swal("{{__('message.DSuccess')}}",result.message);

                        toastr.success('', result.message);
                        table.ajax.reload();
                    },
                    error: function(error) {
                        swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            } else {
                swal({
                    buttons: "@lang('layout.Confirm')",
                    title: "@lang('layout.FileIsSave')",
                });
                return false;
            }
        });

    }



   
    

    $(document).ready(function() {
            $('#sale_installment_all').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.installment")}}',
                    data: {
                        type: 'sale_installment'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [
                    {
                        data: 'sale_number',
                        name: 'sales.number',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'date',
                        name: 'installments.date',
                        orderable: false,
                        searchable: false
                    }, 
                    
                    {
                        data: 'member_name',
                        name: 'members.name'
                    },{
                        data: 'amount',
                        name: 'installments.amount',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'currency',
                        name: 'installments.currency',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'installments.description',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'status',
                        name: 'installments.status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ]

            });   

            $('#loan_installment_all').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.installment")}}',
                    data: {
                        type: 'loan_installment'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [
                    {
                        data: 'loan_number',
                        name: 'loans.number',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'date',
                        name: 'installments.date',
                        orderable: false,
                        searchable: false
                    }, 
                    
                    {
                        data: 'member_name',
                        name: 'members.name'
                    },{
                        data: 'amount',
                        name: 'installments.amount',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'currency',
                        name: 'installments.currency',
                        orderable: false,
                        searchable: false
                    },
                    
                    {
                        data: 'description',
                        name: 'installments.description',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'status',
                        name: 'installments.status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ]

            });
    });       
    





    //Start Export Modal
    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });


    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
          
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    // start app
    new Vue({
        el: '#app2',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    $('#print_pdf_all').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    })
    $('#print_pdf_all2').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    })

    //End Export Modal

    var saleArea = {!! $saleArea !!};
    var memberClass = {!! $memberClass !!};

    
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',
                selectedMember: null,
                member: null,
                customer:[],
                selected_employee:null,
                memberClass: memberClass,
                selected_class: null,
                saleArea: saleArea,
                selected_area: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

             
                
            MemberSearch: _.debounce((search, loading) => {  
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Customer'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vm.customer = [];
                    vm.customer = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

 
            },
            mounted: function() {
                if (response.data.form.class_id) {
                            vm.selected_class = _.find(v.memberClass, (c) => c.id == response.data.form.class_id);
                        }
                        if (response.data.form.sale_area_id) {
                            vm.selected_area = _.find(this.saleArea, (s) => s.id == response.data.form.sale_area_id);
                        }

            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });




















        // This is for modal print Two ....................................
        var memberClasstwo = {!! $memberClass !!};

    
        var vmtwo = new Vue({
            el: '#print-modaltwo',
            data: {
                is_showtwo: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',
                selectedMember: null,
                member: null,
                customer:[],
                selected_employee:null,
                memberClasstwo: memberClasstwo,
                selected_classtwo: null,
              
            },
            methods: {
                closeModal: function () {
                    this.is_showtwo = !this.is_showtwo
                },

             
                
            MemberSearch: _.debounce((search, loading) => {  
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Customer'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vmtwo.customer = [];
                    vmtwo.customer = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

 
            },
            mounted: function() {
                if (response.data.form.class_id) {
                            vmtwo.selected_classtwo = _.find(v.memberClass, (c) => c.id == response.data.form.class_id);
                        }
                       

            }
        });

        new Vue({
            el: '#anchore-modaltwo',
            methods: {
                showModaltwo: function () {
                    // console.log('trr')
                    vmtwo.$data.is_showtwo = true;

                }
            }
        });
</script>


@endpush