@extends('layouts.app')
@section('content')
@include('loans.modal')



<!-- END PAGE HEADER-->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'AlertActiveGift'"
        @closed="closeModal">  
        <div slot="body">
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop"> 
                    <ul class="nav nav-tabs"> 
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li> 
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <div class="col-md-3" style="margin-bottom: 20px;">
                                            <label for=""> @lang('layout.Status') </label>
                                            <select name="status" id="" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                <option value="on">@lang('layout.Active')</option>
                                                <option value="off">@lang('layout.InActive')</option>
                                                <option value="rejected">@lang('layout.Rejected')</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                           
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example"
                                                            v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example"
                                                            v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </report-modal>
</div>
<!-- BEGIN TAB PORTLET-->


<!-- BEGIN Change Item -->
<div id="app" v-cloak>
   {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
  <input type="hidden" name="type" value="change_item_alert"/>
  <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false" >
    <div slot="body">
        <div class="row">
            <div class="form-group">

            <div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    <option  value="on">@lang('layout.On')</option>
                    <option  value="off">@lang('layout.Off')</option>
                    <option  value="pending">@lang('layout.Pending')</option>
                 
                </select>
            </div>


        </div>

    </div>
  
</div>
<div slot="footer">
    <button type="submit" class="btn btn-success" @click="ok">
        @lang('layout.Submit')
    </button>
    <button type="button" class="btn btn-danger" @click="close">
        @lang('layout.Cancel')
    </button>
</div>
</modal>
{{Form::close()}}
</div>
<!-- End Change Item -->
<!-- BEGIN Change Item -->
<div id="app2" v-cloak>
   {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
  <input type="hidden" name="type" value="of_pendig_alert"/>
  <button id="show-modal2" style="display: none" type="button" @click="editExample">Show Modal</button>
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false" >
    <div slot="body">
        <div class="row">
            <div class="form-group">

            <div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    <option  value="off">@lang('layout.Off')</option>
                    <option  value="pending">@lang('layout.Pending')</option>
                 
                </select>
            </div>


        </div>

    </div>
  
</div>
<div slot="footer">
    <button type="submit" class="btn btn-success" @click="ok">
        @lang('layout.Submit')
    </button>
    <button type="button" class="btn btn-danger" @click="close">
        @lang('layout.Cancel')
    </button>
</div>
</modal>
{{Form::close()}}
</div>
<!-- End Change Item -->

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
             <!--div class="btn-group pull-right">
                @permission('services-export')
                   
          					<a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
          					</a>
                @endpermission
            </div--> 
        </div>
     </div>
	
	
	<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">  
    <li class="active">
      <a href="#both" data-toggle="tab" id="tab-on" style="color:green;">
       <i class="fa  "></i><b> @lang('layout.GiftList') </b></a>
     </li> 

     @if(checkGift() =='true')    
     @if(\Entrust::can('SalesGift-create'))
    <li>
      <a href="#salesGiftOn" data-toggle="tab" id="tab-on" style="color:green;">
       <i class="fa  "></i><b> @lang('layout.ActiveGift') </b></a>
     </li> 


    <li>
      <a href="#SalesAllGift" data-toggle="tab" id="tab-on" style="color:green;">
       <i class="fa  "></i><b> @lang('layout.AllGift') </b></a>
     </li> 
     @endif
     @endif


     <!-- li class="">
      <a href="#qut-in" data-toggle="tab" id="tab-off" style="color: red">
       <i class="fa  "></i><b> @lang('layout.ItemDateExpiar') </b></a>
     </li -->
    


   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="both">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.GiftList')</span>
            </div>
            <div class="tools"> </div> 
               <div class="pull-right">
                @permission('services-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="AlertListGift"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                @endpermission
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="alertList_on">
                <thead>
                <tr> 
                    <th>@lang('layout.ID')</th>
                    <th>@lang('layout.Customer')</th>
                    <th>@lang('layout.ItemName')</th>
                    <th>@lang('layout.MeasureUnit')</th>
                    <th>@lang('layout.Quantities')</th>
                    <th>@lang('layout.Percentage')</th>
                    <th>@lang('layout.SaleQty')</th>
                    <th>@lang('layout.GiftQuantity')</th>
                    <th>@lang('layout.FromDate')</th>
					<th>@lang('layout.Actions')</th>
					
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
      </div>
  </div> 




  <div class="tab-pane" id="salesGiftOn">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
  <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
              <i class="icon-settings font-dark"></i>&nbsp;
              <span class="caption-subject bold uppercase">@lang('layout.GiftList')</span>
          </div>
          <div class="tools"> </div> 
             <div class="pull-right">
              @permission('SalesGift-show')
                  {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                  <input type="hidden" name="type" value="AlertActiveGift"/>
                  <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                  {{Form::close()}} --}} 

                  {{-- <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span> --}}


              @endpermission
          </div>
      </div>
      <div class="portlet-body">
 
        <table class="table table-striped table-bordered table-hover" id="sales_gift">
            <thead>
            <tr>
                <th>#</th>
                <th>@lang('layout.Customer')</th>
                <th>@lang('layout.ItemName')</th>
                <th>@lang('layout.Quantity')</th>
                <th>@lang('layout.Measure')</th>
                <th>@lang('layout.ItemGift')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Status')</th> 
                <th>@lang('layout.Action')</th>
           
            </tr>
            </thead>

        </table>
    </div>
  </div>
  <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div> 



  <div class="tab-pane" id="SalesAllGift">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
  <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
              <i class="icon-settings font-dark"></i>&nbsp;
              <span class="caption-subject bold uppercase">@lang('layout.GiftList')</span>
          </div>
          <div class="tools"> </div> 
             <div class="pull-right">
              @permission('services-export')
                  {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                  <input type="hidden" name="type" value="AlertGiftLists"/>
                  <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                  {{Form::close()}} --}}

                  <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
                 
              @endpermission
          </div>
      </div>
      <div class="portlet-body">
 
        <table class="table table-striped table-bordered table-hover" id="sales_gift_all">
            <thead>
            <tr>
                <th>#</th>
                <th>@lang('layout.Customer')</th>
                <th>@lang('layout.ItemName')</th>
                <th>@lang('layout.Quantity')</th>
                <th>@lang('layout.Measure')</th>
                <th>@lang('layout.ItemGift')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Status')</th> 
                <th>@lang('layout.Action')</th>
           
            </tr>
            </thead>
        </table>
    </div>
  </div>
  <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div> 







  <div class="tab-pane" id="qut-in">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SystemAlertlist')</span>
            </div>
            <div class="tools"> </div> 
            <div class="btn-group pull-right">
				@permission('services-export')
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="ItemDateExpiar"/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                   
                @endpermission            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="alertList_off">
                <thead>
                <tr> 
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.MeasureUnit')</th>
                    <th>@lang('layout.OnHand')</th>
                    <th>@lang('layout.Date')</th>
                </tr>
                </thead>

            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>


</div>
</div>


<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop

@push('scripts')
@include('print.modal')

<script>


      // delete item by ajax
      function  DisableItemAjax(element,datatableId) {
        var e = $(element);  
        var form = e.parent('form').get(0);
        var url= $(form).get(0).action;
        var table=$(datatableId).DataTable();
        
       swal({
           title: "@lang('layout.AreYouSure?')",
           icon: "warning",
           buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
           dangerMode: true,
       }).then((willDelete) => {
           if (willDelete) {
                    $.ajax({
                    type:'PATCH',
                    url:url,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function(result)
                    {
                       // swal("{{__('message.DSuccess')}}",result.message);
                       
                        toastr.success('',result.message);
                        table.ajax.reload();
                    },
                    error:function(error){
                         swal("{{__('message.Warning')}}",error.responseJSON.message);
                        
                    }
                });
           } else {
               swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
               });
               return false;
           }
       });

   }



$(document).ready(function(){
    $('#alertList_on').DataTable( {
			ajax:{
				url:'{{route("systemAlerts.gift")}}',
				data:{type:'gift'}
			  },
            scrollCollapse: true,
            serverSide: true,
            paging: true,
			destroy:true,
            columns: [  
            { data: 'id', name: 'id' },
            { data: 'member', name: 'member' ,searchable:false},
            { data: 'item_name', name: 'item_name',searchable:false },
            { data: 'gift_unit', name: 'gift_unit',orderable:false,searchable:false },
            { data: 'gift_qty', name: 'gift_qty',orderable:false,searchable:false },
            { data: 'percentage', name: 'percentage',orderable:false,searchable:false },
            { data: 'qut_out', name: 'qut_out',orderable:false,searchable:false },
            { data: 'start_date', name: 'start_date',searchable:false },
            { data: 'actions', name: 'actions',orderable:false,searchable:false },
            ] 

    }); 
});	


        $('#sales_gift').DataTable({
            ajax:{
                url:'{{route("systemAlerts.salesFiftAlert")}}',
                data:{type:'on'}
            },
            pageLength:'{{getPageRows()}}',
            order: [[0,"{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            destroy: true,
            serverSide: true,
            columns: [
            { data: 'id',            name: 'id',searchable:false},
            { data: 'customer',        name: 'members.name' },
            { data: 'item_name',    name: 'items.name' },
            { data: 'quantity',    name: 'quantity' },
            { data: 'measure',         name: 'measure_units.name' },
            { data: 'item_gift',       name: 'item_gift.name' },
            { data: 'date',    name: 'date'},
            { data: 'status',    name: 'sales_gifts_alert.status'},
            { data: 'action',       name: 'action',orderable:false,searchable:false }
            ]
        });


        $('#sales_gift_all').DataTable({
            ajax:{
                url:'{{route("systemAlerts.salesGiftAlertAll")}}',
            },
            pageLength:'{{getPageRows()}}',
            order: [[0,"{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            destroy: true,
            serverSide: true,
            columns: [
            { data: 'id',            name: 'id',searchable:false},
            { data: 'customer',        name: 'members.name' },
            { data: 'item_name',    name: 'items.name' },
            { data: 'quantity',    name: 'quantity' },
            { data: 'measure',         name: 'measure_units.name' },
            { data: 'item_gift',       name: 'item_gift.name' },
            { data: 'date',    name: 'date'},
            { data: 'status',    name: 'sales_gifts_alert.status'},
            { data: 'action',       name: 'action',orderable:false,searchable:false }
            ]
        });


$(document).ready(function(){
  $('#tab-off').on('shown.bs.tab', function(event){

    $('#alertList_off').DataTable( {
			ajax:{
				url:'{{route("systemAlerts.minItem")}}',
				data:{type:'dateExpiar'}
			  },
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
			destroy:true,
            columns: [  
            { data: 'number', name: 'number' },
            { data: 'name', name: 'name' },
            { data: 'measure', name: 'measure' },
            { data: 'inve_amount', name: 'inve_amount' },
            { data: 'date', name: 'date' },
            ] 
    });  
  });
});	
	

//Start Export Modal
 var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});


 // start app
new Vue({
    el: '#app',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});
 // start app
new Vue({
    el: '#app2',
    data: {
        showModal: false,
    },
    methods:{
      ok:function(){
        this.showModal = !this.showModal;
      },
      close:function(e)
      {
          this.showModal = !this.showModal;
      },
      editExample : function(){

          //Your other code that launches the modal
          this.showModal= true;
          this.$nextTick(function(){
              $(document).ready(function(){
                  $(".date").persianDatepicker(modelDate());
              });
          })
      }
      },
});

$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
}) 
$('#print_pdf_all2').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
}) 

//End Export Modal

var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
               
                
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });


        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });





</script>


@endpush