@extends('layouts.app')
@section('content')
@include('loans.modal')


<div class="">

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.Alerts')</span>
            </div>
            <div class="tools"> </div>
            <!--div class="btn-group pull-right">
                @permission('services-export')
                   
                    <a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
                    </a>
                @endpermission
            </div-->
        </div>
    </div>


    <div class="tabbable-line tabbable-custom-profile">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
                    <i class="fa  "></i><b> @lang('menu.Customers') </b></a>
            </li>
            <li class="">
                <a href="#ex-transport" data-toggle="tab" id="tab-trasnport" style="color: red">
                    <i class="fa  "></i><b> @lang('menu.TransportCompany') </b></a>
            </li>

            <li class="">
                <a href="#ex-vendor" data-toggle="tab" id="tab-vendor" style="color: red">
                    <i class="fa  "></i><b> @lang('layout.Member') </b></a>
            </li>



        </ul>
        <div class="tab-content padding" style="padding: 0px;">
            <div class="tab-pane active" id="both">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('menu.Customers')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="pull-right">
                                    @permission('customers-export')
                                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="expired_customers" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}

                                    @endpermission
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="expired_customers">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Code')</th>
                                            <th>@lang('layout.Name')</th>
                                            <th>@lang('layout.SSID')</th>
                                            <th>@lang('layout.PassportNumber')</th>
                                            <th>@lang('layout.Phone')</th>
                                            <th>@lang('layout.Email')</th>
                                            <th>@lang('layout.BossName')</th>
                                            <th>@lang('layout.LicenseIssueDate')</th>
                                            <th>@lang('layout.LicenseExpireDate')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="ex-transport">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('menu.TransportCompany')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="btn-group pull-right">
                                    @permission('driver-export')
                                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="expired_transport_company" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}

                                    @endpermission
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="expired_transport_company">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Code')</th>
                                            <th>@lang('layout.LicenseNumber')</th>
                                            <th>@lang('layout.Name')</th>
                                            <th>@lang('layout.Phone')</th>
                                            <th>@lang('layout.Email')</th>
                                            <th>@lang('layout.Address')</th>
                                            <th>@lang('layout.RegDate')</th>
                                            <th>@lang('layout.ExpireDate')</th>
                                        </tr>
                                    </thead>

                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="ex-vendor">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>&nbsp;
                                    <span class="caption-subject bold uppercase">@lang('layout.Member')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="btn-group pull-right">
                                    @permission('vendor-export')
                                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="expired_vendors" />
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}

                                    @endpermission
                                </div>



                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="expired_vendors">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Code')</th>
                                            <th>@lang('layout.Name')</th>
                                            <th>@lang('layout.Type')</th>
                                            <th>@lang('layout.SSID')</th>
                                            <th>@lang('layout.PassportNumber')</th>
                                            <th>@lang('layout.Phone')</th>
                                            <th>@lang('layout.Email')</th>
                                            <th>@lang('layout.BossName')</th>
                                            <th>@lang('layout.LicenseIssueDate')</th>
                                            <th>@lang('layout.LicenseExpireDate')</th>
                                        </tr>
                                    </thead>

                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>


        </div>
    </div>


</div>

@stop

@push('scripts')

<script>
    // delete item by ajax
    function DisableItemAjax(element, datatableId) {
        var e = $(element);
        var form = e.parent('form').get(0);
        var url = $(form).get(0).action;
        var table = $(datatableId).DataTable();

        swal({
            title: "@lang('layout.AreYouSure?')",
            icon: "warning",
            buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: 'PATCH',
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    success: function(result) {
                        // swal("{{__('message.DSuccess')}}",result.message);

                        toastr.success('', result.message);
                        table.ajax.reload();
                    },
                    error: function(error) {
                        swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            } else {
                swal({
                    buttons: "@lang('layout.Confirm')",
                    title: "@lang('layout.FileIsSave')",
                });
                return false;
            }
        });

    }




    $('#expired_customers').DataTable({
        ajax: {
            url: '{{route("systemAlerts.expiredTransportCompany")}}',
            data: {
                type: 'expired_customers'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [{
                data: 'code',
                name: 'code'
            },
            {
                data: 'name',
                name: 'name'
            },
            {
                data: 'ss_id',
                name: 'ss_id'
            },
            {
                data: 'passport',
                name: 'passport'
            },
            {
                data: 'phone',
                name: 'phone'
            },
            {
                data: 'email',
                name: 'email'
            },
            {
                data: 'boss_name',
                name: 'boss_name'
            },
            {
                data: 'license_issue_date',
                name: 'license_issue_date'
            },
            {
                data: 'license_expire_date',
                name: 'license_expire_date'
            },
        ]
    });


    $(document).ready(function() {
        $('#tab-trasnport').on('shown.bs.tab', function(event) {
            $('#expired_transport_company').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.expiredTransportCompany")}}',
                    data: {
                        type: 'expired_transport_company'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [{
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'license_number',
                        name: 'license_number'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'phone',
                        name: 'phone'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'address',
                        name: 'address'
                    },
                    {
                        data: 'reg_date',
                        name: 'reg_date'
                    },
                    {
                        data: 'expire_date',
                        name: 'expire_date'
                    },
                ]

            });
        });
    });

    $(document).ready(function() {
        $('#tab-vendor').on('shown.bs.tab', function(event) {
            $('#expired_vendors').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.expiredTransportCompany")}}',
                    data: {
                        type: 'expired_vendors'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [{
                        data: 'code',
                        name: 'code'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'type',
                        name: 'type', orderable: false, searchable: false
                    },
                    {
                        data: 'ss_id',
                        name: 'ss_id'
                    },
                    {
                        data: 'passport',
                        name: 'passport'
                    },
                    {
                        data: 'phone',
                        name: 'phone'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'boss_name',
                        name: 'boss_name'
                    },
                    {
                        data: 'license_issue_date',
                        name: 'license_issue_date'
                    },
                    {
                        data: 'license_expire_date',
                        name: 'license_expire_date'
                    },
                ]

            });
        });
    });



    //Start Export Modal
    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });


    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    // start app
    new Vue({
        el: '#app2',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    $('#print_pdf_all').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    })
    $('#print_pdf_all2').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    })

    //End Export Modal
</script>


@endpush