@extends('layouts.app')
@section('content')
@section('style')
<style>
    .modal-container {
        width: 50% !important;
    }
</style>
@endsection

@include('loans.modal')
@include('drawings.modal')

</style>
  <!-- new modal -->

  <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'dailyExpense_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>  

<div id="print-modal-expense">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'expense_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>

<!-- /new modal -->



<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')-- <span style="color: red">@lang('menu.DailyExpenses') -- @lang('menu.Expense')</span></span>
        </div>
        <div class="tools"> </div>
    </div>
</div>


<div class="tabbable-line tabbable-custom-profile">
    <ul class="nav nav-tabs">
                
        <li class="active">
            <a href="#tab2" data-toggle="tab">@lang('menu.DailyExpenses')</a>
        </li>
        <li >
            <a href="#tab3" data-toggle="tab">@lang('menu.Expense')</a>
        </li>
    </ul>
    <div class="tab-content padding" style="padding: 0px;">
        <div class="tab-pane active" id="tab2">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('menu.DailyExpenses') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            <span id="anchore-modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="dailyExpenseAlertTable">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.OverdueDate')</th>
                                    @if(systemConfig()[5] != 0 )
                                    <th>@lang('layout.Status')</th>
                                    @endif
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Actions')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>        
        
        <div class="tab-pane" id="tab3">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('menu.Expense') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            <span id="anchore-modal-expense">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="expensesAlertTable">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.ExpenseNumber')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.OverdueDate')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Actions') </th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
       


    </div>
</div>


@stop
@include('print.modal')

@push('scripts')

<script>

// Disable item by ajax
function DisableItemAjax(element, datatableId) {
    var e = $(element);
    var form = e.parent('form').get(0);
    var url = $(form).get(0).action;
    var table = $(datatableId).DataTable();

    swal({
        title: "@lang('layout.AreYouSure?')",
        icon: "warning",
        buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: 'PATCH',
                url: url,
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                success: function(result) {
                    // swal("{{__('message.DSuccess')}}",result.message);

                    toastr.success('', result.message);
                    table.ajax.reload();
                },
                error: function(error) {
                    swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        } else {
            swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
            });
            return false;
        }
    });

}
   
    
//DataTable Part
$(document).ready(function() {
    $('#dailyExpenseAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.expenses")}}',
            data: {
                type: 'daily_expense'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {data: 'number', name: 'daily_expenses.number'},
            {data: 'Description', name: 'daily_expenses.description'},
            {data: 'amount', name: 'transactions.amount'},
            {data: 'Currency', name: 'Currency', orderable: false, searchable: false},
            {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
            {data: 'Date', name: 'daily_expenses.Date' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'overdue_date', name: 'daily_expenses.overdue_date' @if(getGeneralSearch()) , searchable: false @endif},
            @if(systemConfig()[5] != 0 )
            {data: 'status', name: 'daily_expenses.status', searchable: false},
            @endif
            {data: 'username', name: 'username', orderable: false, searchable: false},
            {data: 'actions', name: 'actions', orderable: false, searchable: false},
        ]
    });   
}); 

$(document).ready(function() {
    $('#expensesAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.expenses")}}',
            data: {
                type: 'expenses'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {data: 'number', name: 'number'},
            {data: 'expense_number', name: 'purchases.expense_number'},
            {data: 'expense_ref', name: 'expense_ref'},
            {data: 'date', name: 'purchases.date' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'overdue_date', name: 'purchases.overdue_date' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'amount', name: 'transactions.amount'},
            {data: 'currency', name: 'currency', orderable: false, searchable: false},
            {data: 'username', name: 'username', orderable: false, searchable: false},
            {data: 'description', name: 'purchases.description' @if(getGeneralSearch()) , searchable: false @endif},
            {data: 'actions', name: 'actions', orderable: false, searchable: false}
        ]
    });   
});       
    


//Print Modal     
var vm = new Vue({
    el: '#print-modal',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal',
    methods: {
        showModal: function () {
            vm.$data.is_show = true;
        }
    }
});

var vml = new Vue({
    el: '#print-modal-expense',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal-expense',
    methods: {
        showModal: function () {
            vml.$data.is_show = true;
        }
    }
});


</script>


@endpush