@extends('layouts.app')
@section('content')
@include('loans.modal')
@include('drawings.modal')

</style>
  <!-- new modal -->

  <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'contractLoadingDate_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>

<!-- /new modal -->



<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')-- <span style="color: red">@lang('layout.ContractLoadingDate')</span></span>
        </div>
        <div class="tools"> </div>
        <div class="pull-right">
            <span id="anchore-modal">
                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                   <i class="fa fa-print"></i>
                </a>
               </span>
        </div>
    </div>
    <div class="portlet-body">
        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="contractLoadingDateAlertTable">
            <thead>
                <tr>
                    <th>@lang('layout.Record')</th>
                    <th>@lang('layout.ContractName')</th>
                    <th>@lang('layout.ContractNumber')</th>
                    <th>@lang('layout.Vendor')</th>
                    <th>@lang('layout.Date')</th>
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.LoadingDate')</th>
                    <th>@lang('layout.Description')</th>
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Actions')</th>

                </tr>
            </thead>
        </table>
    </div>
    
</div>




@stop
@include('print.modal')

@push('scripts')

<script>

// Disable item by ajax
function DisableItemAjax(element, datatableId) {
    var e = $(element);
    var form = e.parent('form').get(0);
    var url = $(form).get(0).action;
    var table = $(datatableId).DataTable();

    swal({
        title: "@lang('layout.AreYouSure?')",
        icon: "warning",
        buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: 'PATCH',
                url: url,
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                success: function(result) {
                    // swal("{{__('message.DSuccess')}}",result.message);

                    toastr.success('', result.message);
                    table.ajax.reload();
                },
                error: function(error) {
                    swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        } else {
            swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
            });
            return false;
        }
    });

}
   
    
//DataTable Part
$(document).ready(function() {
    $('#contractLoadingDateAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.contractLoadingDate")}}'
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {data: 'id', name: 'id'},
            {data: 'contract_name', name: 'contracts.company_name'},
            {data: 'contract_no', name: 'contracts.contract_no'},
            {data: 'member_name', name: 'members.name'},
            {data: 'contract_date', name: 'contract_date',orderable: false, searchable: false},
            {data: 'number', name: 'contract_loading_dates.number'},
            {data: 'date', name: 'contract_loading_dates.date'},
            {data: 'description', name: 'contract_loading_dates.description'},
            {data: 'user', name: 'user', orderable: false, searchable: false},
            {data: 'actions', name: 'actions', orderable: false, searchable: false}
        ]
    });   

});       
    


//Print Modal     
var vm = new Vue({
    el: '#print-modal',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal',
    methods: {
        showModal: function () {
            vm.$data.is_show = true;
        }
    }
});


</script>


@endpush