@extends('layouts.app')
@section('content')
@include('drawings.modal')

<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')</span>
        </div>
        <div class="tools"> </div> 
         <!--div class="btn-group pull-right">
            @permission('services-export')
               
                <a href="{{route('systemAlerts.create')}}">
                              <button class="btn btn-success">
                                  <i class="fa fa-plus"></i> @lang('layout.AddNew')
                              </button>
                </a>
            @endpermission
        </div-->
    </div>
 </div>


 

    <div class="row" >
        
        <ul class="nav nav-tabs">  
            <li class="active">
              <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
               <i class="fa  "></i><b> @lang('menu.AttachmentsManagement') </b></a>
            </li> 
             <!-- <li class="">
              <a href="#ex-transport" data-toggle="tab" id="tab-trasnport" style="color: red">
               <i class="fa  "></i><b> @lang('layout.Payment') </b></a>
             </li>  -->
           </ul> 
        <div class="portlet light bordered">
           

            <div class="portlet-body">
 
                <table class="table table-striped table-bordered table-hover" id="attachments">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('menu.AttachmentClass')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.InDate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.FileType')</th>
                        <th>@lang('layout.OpeningDate')</th>
                        <th>@lang('layout.ExpireDate')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Action')</th>
                   
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
     Vue.component("v-select", VueSelect.VueSelect);
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        getRecord();
    } );

    function getRecord()
    {
           // var from_date=document.getElementById('range-from-example').value;
           // var to_date=document.getElementById('range-to-example').value;
           var from_date = null;
           var to_date = null;
            $('#attachments').DataTable( {
             ajax:{
                    url:'{{route("systemAlerts.attachmentList")}}',
                    data:{category:vmf.category,from_date:from_date,to_date:to_date,title:vmf.title,description:vmf.description,attachment_class_id:vmf.attachment_class_id}
                },
            pageLength:'{{getPageRows()}}',
            order: [[0,"{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            destroy: true,
            serverSide: true,
            columns: [
                { data: 'id',            name: 'id',searchable:false},
                { data: 'number',        name: 'number' },
                { data: 'ref_number',    name: 'ref_number' },
                { data: 'attachment_class_name',    name: 'attachment_class_name',orderable:false,searchable:false},
                { data: 'table_name',    name: 'table_name',orderable:false,searchable:false},
                { data: 'title',         name: 'title' },
                { data: 'in_date',       name: 'in_date' },
                { data: 'description',   name: 'description'},
                { data: 'created_at',    name: 'created_at'},
                { data: 'status',    name: 'status'},
                { data: 'file_type',     name: 'file_type',orderable:false,searchable:false},
                { data: 'start_date',    name: 'start_date'},
                { data: 'end_date',    name: 'end_date'},
                { data: 'user',          name: 'users.name'},
                { data: 'actions',       name: 'actions',orderable:false,searchable:false }
            ]
        } );
    }
// start app

var vmf = new Vue({
    el: '#app',
    data:{
         from_date:null,
        to_date:null,
        title:null,
        number:null,
        description:null,
        
    },
    methods:{
         getData(){

           getRecord();
    }
    }
})


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
 

        
        
</script>
@endpush

