@extends('layouts.factor-master')
@section('content')
  <?php 
    $report = customeReportNew('new_systemTransactions_index');
      $_number = !in_array('number', $report);
      $_transactionID = !in_array('transactionID', $report);
      $_name = !in_array('name', $report);
      $_amount = !in_array('amount', $report);
      $_rate = !in_array('rate', $report);
      $_unit = !in_array('unit', $report);
      $_date = !in_array('date', $report);
      $_user = !in_array('user', $report);
      $_memo = !in_array('memo', $report);
      $_memo1 = !in_array('memo1', $report);

    $report_percent = customeReportNewPercent('new_systemTransactions_index');
      $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
      $_transactionID_percent= (array_key_exists('transactionID___percent', $report_percent))?$report_percent['transactionID___percent']:null;
      $_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
      $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
      $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
      $_unit_percent= (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
      $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
      $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
      $_memo_percent= (array_key_exists('memo___percent', $report_percent))?$report_percent['memo___percent']:null;
      $_memo1_percent= (array_key_exists('memo1___percent', $report_percent))?$report_percent['memo1___percent']:null;
  ?>
  <h2 class="center">@lang('layout.SystemTransactions')</h2>  
  <table class="main-table">
    <tr class="bg">
      @if($_number)
        <th class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>
      @endif
      @if($_transactionID)
        <th class="center" @if($_transactionID_percent) width="{{$_transactionID_percent}}%" @endif>@lang('layout.TransactionID')</th>
      @endif
      @if($_name)
        <th class="center" @if($_name_percent) width="{{$_name_percent}}%" @endif>@lang('layout.Name')</th>
      @endif
      @if($_amount)
        <th class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif>@lang('layout.Amount')</th>
      @endif
      @if($_rate)
        <th class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif>@lang('layout.Rate')</th>
      @endif
      @if($_unit)
        <th class="center" @if($_unit_percent) width="{{$_unit_percent}}%" @endif>@lang('layout.Unit')</th>
      @endif
      @if($_date)
        <th class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>
      @endif
      @if($_user)
        <th class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</th>
      @endif
      @if($_memo)
        <th class="center" @if($_memo_percent) width="{{$_memo_percent}}%" @endif>@lang('layout.Memo')</th>
      @endif
      @if($_memo1)
        <th class="center" @if($_memo1_percent) width="{{$_memo1_percent}}%" @endif>@lang('layout.Memo')</th>
      @endif
    </tr>
    <?php 
      $count = 0;
      $total_home_currency = 0;
      $currencies = [];
    ?>
    @foreach($data as $record)
      <?php
        if(systemConfig()[30] == 1){
          $total_home_currency += $record->amount / $record->static_rate * $record->rate;
        }else{
          $total_home_currency += $record->amount / $record->rate;
        } 
        if (array_key_exists($record->currency, $currencies)) {
          $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
        } else { 
          $currencies[$record->currency] = $record->amount;
        }
      ?>
      <tr>
        @if($_number)
          <td class="center">{{++$count}}</td>
        @endif
        @if($_transactionID)
          <td class="center">{{$record->id}}</td>
        @endif
        @if($_name)
          <td class="center">{{$record->name}}</td>
        @endif
        @if($_amount)
          <td class="center">{{$record->amount}}</td>
        @endif
        @if($_rate)
          <td class="center">{{$record->rate}}</td>
        @endif
        @if($_unit)
          <td class="center">{{$record->currency}}</td>
        @endif
        @if($_date)
          <td class="center">{{convertDate($record->date)}}</td>
        @endif
        @if($_user)
          <td class="center">{{$record->user}}</td>
        @endif
        @if($_memo)
          <td class="center">{{$record->remark_en}}</td>
        @endif
        @if($_memo1)
          <td class="center">{{$record->remark_fa}}</td>
        @endif
      </tr>
    @endforeach
  </table>
  <table class="main-table" style="margin-top: 10px;">
    <tr class="bg">
      <td colspan="3" style="font-weight: bold;">
        <div class="center">@lang('layout.PerCurrency')</div>
      </td>
    </tr>
    <tr class="bg">
      <th>
        <div class="center">  @lang('layout.Record') </div>
      </th>
      <th>
        <div class="center"> @lang('layout.Currency') </div>
      </th>
      <th>
        <div class="center"> @lang('layout.Amount') </div>
      </th>
    </tr>
    <?php
      $count = 0;
      foreach($currencies As $key=>$currency )
      {
    ?>
    <tr>
      <td class="center">
        <div class="center">{{++$count}}</div>
      </td>
      <td class="center">
        <div class="center">{{$key}}</div>
      </td>
      <td class="center">
        <div class="center">{{round($currency,2)}}</div>
      </td>
    </tr>
    <?php
      }
    ?>
    <tr class="bg">
      <td colspan="2" class="center" style="font-weight: bold;">
        <div class="center">@lang('layout.HomeCurrencyTotal')</div>
      </td>
      <td class="center" style="font-weight: bold;">
        <div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}  </div>
      </td>
    </tr>
  </table>
  <!--signature-->
  <table style="width: 100%" class="signtable">
    <tr>
      @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
          <table>
            <tr>
              <td align="right" class="signsize">{{$info['name']}}</td>
            </tr>
          </table>
        </td>
      @endforeach
    </tr>
  </table>
  <!--End signature-->
@endsection