@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'systemTransactions_Report'" @closed="closeModal"> 
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop"> 
                        <ul class="nav nav-tabs"> 
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="form-group">
                                                {{-- <div class="col-md-12">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div> --}}
                                                {{-- <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.Name')</label>
                                                        <v-select label="name" v-model="selectedName" :options="names">
                                                        </v-select>
                                                        <input type="hidden" name="selected_name" v-model.number="(!selectedName)?null:selectedName.id">
                                                    </div>
                                                </div> --}}
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.Currency')</label>
                                                    <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                                    <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Bank') </label>
                                                    <v-select class="vue-select2" v-model="selected_bank" label="name" :options="bank" @search="searchAccount" >
                                                    </v-select>
                                                    <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id">
                                                </div> 
                                                {{-- <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.User')</label>
                                                    <v-select v-model="selectedUser" label="name" :options="allUsers" > </v-select>
                                                    <input type="hidden" name="allUsers" v-bind:value="(!selectedUser)?null:selectedUser.name">
                                                </div> --}}
                                                <div class="col-md-12" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"><i class="fa fa-calendar"></i> @lang('layout.BetweenTwoDates')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" name="from_date1" v-model="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" name="to_date" v-model="to_date" autocomplete="off"> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="new_systemTransactions_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('layout.Bank')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group" style="margin: 4px 0px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button type="button" style="margin-top: 10px;" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button type="button" style="margin-top: 10px;" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                        <hr>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i> &nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.SystemTransactions')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('SystemTransactions-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="anchore-modal-link" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="systemTransactions">
                    <thead>
                        <tr>
                            {{--<th>Code</th>--}}
                            <th>#</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Unit')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Remark')</th>
                            <th>@lang('layout.Remark')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('new_systemTransactions_index')!!};
        var names = {!!$names!!};
        var currency ={!! $currency !!}
        var allUsers ={!! $allUsers !!}
        let data = {
            selected: '{!! getCompanyID() !!}'
        };
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table = null;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#systemTransactions').DataTable({
                ajax: '{{route("systemTransactions.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                order: [[0, "desc"]],
                columns: [
                    {data: 'id', name: 'transactions.id'},
                    {data: 'name', name: 'accounts.name'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'rate', name: 'transactions.rate'},
                    {data: 'currency', name: 'accounts.currency'},
                    {data: 'date', name: 'transactions.date', searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'remark_en', name: 'remark_en', orderable: false, searchable: false},
                    {data: 'remark_fa', name: 'remark_fa', orderable: false, searchable: false}
                ]
            });
        });
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    console.log('company emitted from child',event.company);
                    data.selected = event.company;
                    try{
                        if (data_table != null &&  typeof  data_table =='object')
                        {
                            data_table.clear();
                            data_table.ajax.reload();
                        }
                    }catch (e) {
                    }
                }
            }
        });
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                selectedCurrency: null,
                selectedUser: null,
                selected_bank:null,
                bank:[],
                currency: currency,
                allUsers: allUsers,
                selectedName: null,
                names: names,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                financial_classes: {!!getFinancialClassList()!!},
                selected: '',
                customReportData:
                [
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.TransactionID")', column_name: 'transactionID',checkedColumn:(cust_rep.transactionID)?'checked':'',column_percentage:(cust_rep.transactionID___percent)?cust_rep.transactionID___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Memo")', column_name: 'memo',checkedColumn:(cust_rep.memo)?'checked':'',column_percentage:(cust_rep.memo___percent)?cust_rep.memo___percent:''},
                 {Name: '@lang("layout.Memo")', column_name: 'memo1',checkedColumn:(cust_rep.memo1)?'checked':'',column_percentage:(cust_rep.memo1___percent)?cust_rep.memo1___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                        // console.log(3232, period);
                        if (period != 'CustomDates') {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'getDatesByPeriod',
                                    period: period,
                                }
                            })
                            .then(function(response) {
                                vm.from_date = null;
                                vm.to_date = null;
                                if (response.data) {
                                    vm.from_date = response.data.start;
                                    vm.to_date = response.data.end;
                                    // console.log('data', response.data);
                                }
                            })
                            .catch(function(error) {
                                vm.period = 'CustomDates';
                                vm.from_date = null;
                                vm.to_date = null;
                            })
                        } else {
                            vm.from_date = null;
                            vm.to_date = null;
                        }
                    }
                },
                searchAccount(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'accounts',
                            filterColumn: 'type',
                        }
                    })
                    .then(function (response) {
                        vm.bank = [];
                        if (response.data.length > 0) {
                            vm.bank = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }
            }
        });
        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                },
            }
        });
    </script>
@endpush