@extends('layouts.app')
@section('style')

<style type="text/css">
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th,
    #main td {
        border: 1px solid #6f6e6e;
        padding: 8px;
    }

    /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
    #main tr:hover {
        background-color: #ddd;
    }

    #main th {
        padding-top: 12px;
        padding-bottom: 12px;
        font-weight: bold;
        background-color: #768585;
        color: white;
    }

    #bg td {
        background-color: #e0e0e0;
        font-weight: bold;
    }

    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
    }

    .modal-mask {
        position: fixed;
        z-index: 9998;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .5);
        display: table;
        transition: opacity .3s ease;
    }

    .modal-wrapper {
        display: table-cell;
        vertical-align: middle;
    }

    .modal-container {
        width: 80%;
        max-width: 90%;
        margin: 0px auto;
        padding: 20px 30px;
        background-color: #fff;
        border-radius: 2px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
        transition: all .3s ease;
        font-family: Helvetica, Arial, sans-serif;
    }

    .modal-header h3 {
        margin-top: 0;
        color: #42b983;
    }

    .modal-body {
        margin: 20px 0;
    }

    .modal-default-button {
        float: right;
    }

    .modal-enter {
        opacity: 0;
    }

    .modal-leave-active {
        opacity: 0;
    }

    .modal-enter .modal-container,
    .modal-leave-active .modal-container {
        -webkit-transform: scale(1.1);
        transform: scale(1.1);
    }
</style>
@stop
@section('content')

<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'dailyFinancialStatement'" @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div id="date_part" class="hidden-print" >

            <div class="col-md-2  col-sm-2">
                <select class="form-control" v-model="selected_currency" >
                    <option value="" selected>@lang('layout.Currency')</option>
                    <option v-for="curre in currencies" :value="(curre)?curre.code:null" >@{{ curre.code }}</option>
                </select>
            </div>

            {{Form::open(['route' => 'cashBook.dailyCashbook','method' => 'GET','class' => 'form-horizontal'])}}
            {{ csrf_field() }}
            <div class="col-md-5 col-sm-5">
                <input type="hidden" name="currency" v-bind:value="selected_currency"/>
                <div class="input-group">
                    <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" value="{{$from_date}}" autocomplete="off" />
                    <span class="input-group-addon" style="background-color: rgb(80, 129, 141) !important;color: white;"> @lang('layout.To') </span>
                    <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" value="{{$to_date}}" autocomplete="off" />
                    <span class="input-group-addon btn" style="padding: 0px;"> <input type="submit" style="padding: 0px 8px;background-color: rgb(80, 129, 141) !important; border: 1px solid rgb(80, 129, 141);color: white;" value="@lang('layout.Search')"> </span>
                </div>
            </div>
            {!! Form::close() !!}
            {{Form::open(['route' => 'cashBook.dailyCashbook','method' => 'GET','class' => 'form-horizontal'])}}
            {{ csrf_field() }}
            <div class="col-md-3 col-sm-3">
                <input type="hidden" name="currency" v-bind:value="selected_currency"/>
                <div class="input-group">
                    <input name="date" class="form-control date" ref="date" placeholder="@lang('layout.Date')" value="{{$date}}" autocomplete="off" />
                    <span class="input-group-addon btn" style="padding: 0px;"> <input type="submit" style="padding: 0px 8px;background-color: rgb(80, 129, 141) !important; border: 1px solid rgb(80, 129, 141);color: white;" value="@lang('layout.Search')"> </span>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
        <div class="portlet-title">
            <div class="caption font-dark">
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right">
                <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
            </div>
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table id="main" class="main-table">
                <tr>
                    <th colspan="4" style="background-color: #e8edff; color:#669;">
                        <center><b>@lang('menu.DailyTransactions') @if(getCompanyID() == 'all') ( @lang('layout.All') ) @else {!! company()['name'] !!} @endif @lang('layout.FromDate') ( {{$from_date}} ) @lang('layout.ToDate') ( {{$to_date}} ) </b></center>
                    </th>
                </tr>
            </table>
            
            <div class="row" style="overflow-x: scroll; margin: 0px !important;">
            <table id="main" class="main-table">
                <thead>
                    <tr>
                        <th class="center"> #</th>
                        <th class="center"> @lang('layout.Date')</th>
                        <th class="center"> @lang('layout.Description')</th>
                        <th class="center"> @lang('layout.Account')</th>
                        <th class="center"> @lang('layout.User')</th>
                        <th class="center"> @lang('layout.Unit')</th>
                        <th class="center"> @lang('layout.Dr')</th>
                        <th class="center"> @lang('layout.Cr')</th>
                        <th class="center"> @lang('layout.Rate')</th>
                        @if($currency)<th class="center"> @lang('layout.Balance') {{$currency}}</th> @endif
                        <th class="center"> @lang('layout.Balance'){{getHomeCurrency()[getCurrencyType()]}}</th>
                    </tr>
                </thead>

                @if($beforeTotalAmount || $beforeTotalBaseAmount)
                <tr id="bg">
                    <td colspan="9" class="center"><center>@lang('layout.PreviousBalance')</center></td>
                    @if($currency)<td class="center">{{myRound($beforeTotalAmount)}} {{$currency}}</td> @endif
                    <td class="center">{{myRound($beforeTotalBaseAmount)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
                </tr>
                @endif

                <?php
                $count = 0;
                $balance = ($beforeTotalBaseAmount) ? $beforeTotalBaseAmount : 0;
                $balance1 = ($beforeTotalAmount) ? $beforeTotalAmount : 0;
                $tp = 0;
                $tn = 0;

                $tn_currency = 0;
                $tp_currency = 0;
                ?>
                @foreach($main_data AS $record)
                <?php
                $balance += $record['amount'] / $record['rate'];
                $balance1 += $record['amount'];

                if ($record['amount'] < 0) {
                    $tn += $record['amount'] / $record['rate'];
                }

                if ($record['amount'] > 0) {
                    $tp += $record['amount'] / $record['rate'];
                }


                //  total in currency

                if ($record['amount'] < 0) {
                    $tn_currency += $record['amount'];
                }

                if ($record['amount'] > 0) {
                    $tp_currency += $record['amount'];
                }

                ?>


                <tr>
                    <td class="center">{{++$count}}</td>
                    <td class="center">{{convertDate($record['date'])}}</td>
                    <td class="center">@if($record['remark'] == $record['remark1'])
                        <?php
                        $des = wordwrap($record['remark'], 40, "<br/>\n", false);
                        echo $des;
                        ?>
                        @else
                        <?php
                        $des = wordwrap($record['remark1'] . $record['remark'], 40, "<br/>\n", false);
                        echo $des;
                        ?>
                        @endif</td>
                    <td class="center">{{$record['account']}}</td>
                    <td class="center">{{$record['name']}}</td>
                    <td class="center">{{$record['unit']}}</td>
                    <td class="center">
                        @if($record['amount']>0)
                        {{myRound($record['amount'])}}
                        @endif
                    </td>
                    <td class="center">
                        @if($record['amount']<0) {{myRound($record['amount'])}} @endif </td>
                    <td class="center">{{myRound($record['rate'])}}</td>
                    @if($currency)<td class="center">{{myRound($balance1)}}</td>@endif
                    <td class="center">{{myRound($balance)}}</td>
                </tr>
                @endforeach

                <tr id="bg">
                    <td colspan="5" class="center"><center>@lang('layout.Total')</center></td>
                    <td colspan="2" class="center"><center>@lang('layout.Cr') : {{myRound($tp)}}</center></td>
                    <td colspan="2" class="center"><center>@lang('layout.Dr') : {{myRound($tn)}}</center></td>
                    @if($currency)<td class="center">{{myRound($balance1)}} {{$currency}}</td> @endif
                    <td class="center">{{myRound($balance)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
                </tr>

            </table>
            </div>
            <br/>

            @if($statement && $statement !=[])
            <div class="row" style="overflow-x: scroll; margin: 0px !important;">
            <h3 class="table-caption" style="text-align: center; background-color: #e8edff; color:#669;" >@lang('layout.Receivable') / @lang('layout.Payable')</h3>
            <table id="main" class="main-table">
                <thead>
                    <tr>
                        <th>
                            <div class="center">@lang('layout.Number')</div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Name') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Phone') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Description') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Currency') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Rate') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Receivable') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Payable') </div>
                        </th>
                        <th>
                            <div class="center"> @lang('layout.Balance') </div>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $count = 0;
                    $tempName = '';
                    $totalP = 0;
                    $totalR = 0;

                    ?>
                    @foreach($statement AS $key=>$value)

                    @foreach($value['Currency'] AS $key1=>$rec)
                    <tr>
                    <td class="center">{{++$count}}</td>
                    <td class="center">{{$key}}</td>
                    <td class="center">{{$value['Phone']}}</td>
                    <td class="center">
                        <?php
                        $des = wordwrap($value['Description'], 40, "<br/>\n", false);
                        echo $des;
                        ?>
                    </td>
                    <td class="center">{{$key1}}</td>
                    <td class="center"> {{$rec['Rate']}}</td>
                    <td class="center">{{myRound($rec['Receivable'])}}</td>
                    <td class="center"> {{myRound($rec['Payable'])}}</td>
                    <td class="center">
                        <?php
                        $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                        $p1 = $result1['a'];
                        $r1 = $result1['b'];


                        if ($p1 != 0) {

                        $totalP += ($p1 / $rec['Rate']);
                        // echo round($p1,2).' '.__('layout.Payable');
                        } elseif ($r1 != 0) {
                        $totalR += ($r1 / $rec['Rate']);
                        // echo round($r1,2).' '.__('layout.Receivable');
                        } else {
                        echo '0';
                        }


                        ?>
                        @if($r1 !=0)
                        {{myRound($r1)}}:
                        @lang('layout.Receivable')

                        @elseif($p1 !=0)

                        {{myRound($p1)}}:
                        @lang('layout.Payable')

                        @endif
                    </td>


                    </tr>
                    @endforeach
                    @endforeach
                </tbody>
            </table>
            <table id="main" class="main-table">
                <tr id="bg">
                    <td width="25%">
                    <div class="center"> @lang('layout.Payable') </div>
                    </td>
                    <td width="25%">
                    <div class="center"> {{myRound($totalP)}} {{getHomeCurrency()[getCurrencyType()]}}   </div>
                    </td>
                    <td width="25%">
                    <div class="center"> @lang('layout.Receivable') </div>
                    </td>
                    <td width="25%">
                    <div class="center"> {{myRound($totalR)}}  {{getHomeCurrency()[getCurrencyType()]}}  </div>
                    </td>
                </tr>
            </table>
            </div>
            @endif

        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- BEGIN TAB PORTLET-->
<!-- BEGIN TAB PORTLET-->
<div class=" pull-right">


</div>
<br>
<br>





@endsection
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
<script type="text/javascript">
    var vm = new Vue({
        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route("export.PDFAll") !!}',
            excelRoute: '{!! route("export.PDFAll") !!}',
            items: null,


        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },

        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true
            }
        }
    });

    // start app
    Vue.component('v-select', VueSelect.VueSelect)

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload();
            }
        }
    });


    var currencies = {!! $currency_list !!};
    new Vue({
        el: '#date_part',
        data: {
            currencies: currencies,
            selected_currency: "{!! $currency !!}",
        },
        methods: {
            
        }
    });
</script>
@endpush