@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
@stop


@section('content') 

    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">

                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>

            </div>
        @endif

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewCustomer')</span>
                    {{-- <span class="caption-helper">some info...</span> --}}
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div  class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'customer.store','method'=>'POST','class'=>'form-horizontal','files'=> true)) !!}
                {{ csrf_field() }}

                 <div class="form-body">
                    <h3 class="form-section">@lang('layout.PersonInfoo')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.FullName')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' =>__('layout.FullName'),'class' => 'form-control','autocomplete'=>'off')) !!} 
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.UserId')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code',$code, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Class')</label>
                                <div class="col-md-9">
                                    {{Form::select('class',$class,Null,['class' => 'form-control','placeholder' => __('layout.CustomerClass')])}}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>

                     <div class="row">
                        <div class="col-md-6">
                             <div class="form-group">
                                 <label class="control-label col-md-3">@lang('layout.Type')</label>
                                 <div class="col-md-9">
                                     <select role="button"    name="type[]" multiple="multiple"  class="list-style form-control" id="type">
                                         @foreach($type as $key=>$value)
                                             @if($value == 'Customer')
                                                 <option selected value="{{$key}}">{{$value}}</option>
                                             @else
                                                 <option value="{{$key}}">{{$value}}</option>
                                             @endif
                                         @endforeach
                                     </select>
                                 </div>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                 <div class="col-md-9">
                                     {!! Form::file('photo', null, array('placeholder' => 'photo','class' => 'form-control')) !!}
                                 </div>
                             </div>
                         </div>

                     </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Gender')</label>
                                <div class="col-md-9">
                                    <div >
                                        <label class="radio-inline">
                                            <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="gender" value="female" >
                                            @lang('layout.Female') </label>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                <div class="col-md-9">
                                    <input type="text" id="date_of_birth" name="date_of_birth"  class="form-control date" autocomplete="off">
                                     
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                     <!--/row-->
                    <div class="row">
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Membership')</label>
                                <div class="col-md-9">
                                    <div>
                                        <label class="radio-inline">
                                            <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="membership" value="professiona" >
                                            @lang('layout.Professional') </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Date')</label>
                                <div class="col-md-9">
                                    <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off">
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="app" v-cloak>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsReceivable')</label>
                                <div class="col-md-9">
                                    <v-select label="name" v-model="selected_receivable" :options="receivable">
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsPayable')</label>
                                <div class="col-md-9">
                                      <v-select label="name" v-model="selected_payable" :options="payable">
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3 class="form-section">@lang('layout.Address')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address1')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address2')</label>
                                <div class="col-md-9">
                                    {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-9">
                                    {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.PostCode')</label>
                                <div class="col-md-9">
                                     {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9">
                                    <select  class="form-control" name="country">
                                        <option value="Afghanistan">@lang('layout.Afghanistan')</option>
                                        <option value="Iran">@lang('layout.Iran')</option>
                                        <option value="Pakistan">@lang('layout.Pakistan')</option>
                                        <option value="China">@lang('layout.China')</option>
                                        <option value="us">@lang('layout.USA')</option>
                                        <option value="india">@lang('layout.India')</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                   
                    <!--/row-->
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    
                                    <!-- <button type="button" onClick="regForm(this)" class="btn green">@lang('layout.Submit')</button> -->
                                     <button type="submit"  class="btn green">@lang('layout.Submit')</button>

                                     <a href="{{route('customer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>


@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
      Vue.component('v-select', VueSelect.VueSelect);
    $('#type').multiselect({
        columns: 4,
        placeholder: 'Select Type',
    });

    
 
    var Modal = Vue.component('cmodal',
    {
        template:'#cmodal-template',
        props: ['show'],
    });



  var receivable={!! $receivable !!};
  var payable={!! $payable !!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
    },

    methods:{
        
    },
    mounted:function(){
        if(this.payable)
        {
            this.selected_payable=this.payable[0];

        }
         if(this.receivable)
        {
            this.selected_receivable=this.receivable[0];
        }
    }
  });

  


</script>


@endpush