<!DOCTYPE html>
<html>

<head>
    <title>system package</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <meta name="csrf-token" content=" {{csrf_token()}}">

    <link href="{{url('/assets/app/css/app.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/assets/app/pages/login.css')}}" rel="stylesheet" type="text/css" />

    <style>
        .red-text {
            color: #e3342f;
        }
    </style>
</head>

<body>

    <div class="portlet light bg-inverse">
        @if(Session::has('error'))
        <h2 style="color: red">{{Session::get('error')}}</h2>
        @endif
        <h2 style="color: red; margin: 10px">System package selection for customers</h2>
        <div class="portlet-body form" id="app">
            <!-- BEGIN FORM-->
            <form method="post" id="config_form" action="{{route('systemConfig.store')}}" accept-charset="utf-8" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label">System package type</label>
                                <select class="form-control" name="package_name" required>
                                    <option value="">Select Type</option>
                                    <option value="selver_package" @if($group_settings && $group_settings->package_name =='selver_package')
                                        selected
                                        @endif
                                        >Silver Package
                                    </option>
                                    <option value="gold_package" @if($group_settings && $group_settings->package_name =='gold_package')
                                        selected
                                        @endif>Gold Package
                                    </option>
                                    <option value="platinume_package" @if($group_settings && $group_settings->package_name =='platinume_package')
                                        selected
                                        @endif>Platinume Package
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.ThemeColor')</label>
                                <select class="form-control" name="theme_color" required>
                                    <option value="">@lang('layout.SelectColor')</option>
                                    <option value="newTheme" @if($group_settings && $group_settings->theme_color =='newTheme')
                                        selected
                                        @endif>@lang('layout.Default')
                                    </option>
                                    <option value="default" @if($group_settings && $group_settings->theme_color =='default')
                                        selected
                                        @endif>Dark Grey</option>
                                    <option value="blue" @if($group_settings && $group_settings->theme_color =='blue')
                                        selected
                                        @endif>@lang('layout.Blue')</option>
                                    <option value="darkblue">@lang('layout.DarkBlue')</option>
                                    <option value="grey" @if($group_settings && $group_settings->theme_color =='grey')
                                        selected
                                        @endif>@lang('layout.Grey')</option>
                                    <option value="light" @if($group_settings && $group_settings->theme_color =='light')
                                        selected
                                        @endif>@lang('layout.Light')</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label">Package Logo</label>
                                <input type="file" class="form-control" name="logo">
                            </div>
                        </div>
                    </div>
                    <br/>
                    <hr/>
                    <div class="row">

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label" for="advertisment" >Advertisment</label>
                                @if($group_settings)
                                <input type="checkbox" class="form-control" name="advertisment" {{($group_settings->advertisment)?'checked':''}} id="advertisment" value="1" />
                                @else
                                <input type="checkbox" class="form-control" name="advertisment" id="advertisment" value="1" />
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label" for="company_number" >Company Number</label>
                                <input type="text" class="form-control" name="company_number" id="company_number" value="{{($group_settings)?$group_settings->company_number:1}}" />
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label" for="site_link" >Advertisment Site Link</label>
                                <input type="text" class="form-control" name="site_link" value="{{($group_settings)?$group_settings->site_link:''}}" id="site_link" placeholder="http://www.cas.com" />
                            </div>
                        </div>
                    </div>
                    <br/>
                    <hr/>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label" for="back_site_link" >Backend Site Link For Online Site</label>
                                <input type="text" class="form-control" name="back_site_link" value="{{($group_settings)?$group_settings->back_site_link:''}}" id="back_site_link" placeholder="http://www.cas.com" />
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label" for="back_site_link" >WhatsApp message</label>
                                <input type="number" class="form-control" name="message" value="{{$fileDataM}}" />
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="col-md-12">
                                <label class="control-label" for="back_site_link" >Sended WhatsApp message</label>
                                <input type="number" class="form-control" name="send_message" value="{{$fileData}}" />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <h5 class="text-info" style="margin: 10px">
                                <b> Note:</b> Please note that the main branch always has tag of 1
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-12 col-lg-12 table-responsive" style="margin: 7px">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <td style="max-width: 10%">Branch Tag</td>
                                        <td style="max-width: 90%">Branch Specification</td>
                                        <td>Delete</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(branch,index) in branches" :key="branch.tag">
                                        <td>
                                            @{{ branch.tag}}
                                        </td>
                                        <td>

                                            <div class="row">
                                                <input type="hidden" :name="'ids['+index+']'" v-model="branch.id">
                                                <input type="hidden" :name="'tag['+index+']'" v-model="branch.tag">
                                                <input type="hidden" :name="'taken['+index+']'" v-model="branch.taken">

                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <div class="">
                                                        <label class="control-label">Number of users</label>
                                                        <input type="number" required :name="'user_count['+index+']'" class="form-control" v-model="branch.user_count">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <div class="">
                                                        <label class="control-label">Number of inventory site</label>
                                                        <input type="number" class="form-control" required :name="'inventory_count['+index+']'" v-model="branch.inventory_count">
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12">
                                                    <div class="">
                                                        <label class="control-label">Number of Financial Class</label>
                                                        <input type="number" class="form-control" required :name="'financial_class_count['+index+']'" v-model="branch.financial_class_count">
                                                    </div>
                                                </div> 
                                                <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12">
                                                    <div class="">
                                                        <label class="control-label">Number of Mobile Device</label>
                                                        <input type="number" class="form-control" required :name="'mobile_device_count['+index+']'" v-model="branch.mobile_device_count">
                                                    </div>
                                                </div>

                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <div class="">
                                                        <label class="control-label">@lang('layout.DataStoringMethod')</label>
                                                        <select :name="'data_storing_method['+index+']'" v-model="branch.data_storing_method" class="form-control" required>
                                                            <option value="standard">@lang('layout.Standard')</option>
                                                            <option value="traditional">@lang('layout.Traditional')</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <!--/span-->
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <input type="checkbox" :id="'mainPart-'+branch.tag" :name="'mainPart['+index+']'" v-model="branch.mainPart" true-value="1" false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'mainPart-'+branch.tag">
                                                                    Main Part of System
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'custom-'+branch.tag" :name="'custom_report['+index+']'" v-model="branch.custom_report" true-value="1" false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'custom-'+branch.tag">
                                                                    custom report module
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'build-'+branch.tag" :name="'build['+index+']'" v-model="branch.build" true-value="1" false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'build-'+branch.tag">
                                                                    build module
                                                                </label>
                                                            </span>
                                                            <br />


                                                            <input type="checkbox" :id="'oil-'+branch.tag" :name="'oil_and_gas['+index+']'" v-model="branch.oil_and_gas" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'oil-'+branch.tag">
                                                                    Oil & Gas module
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'tax-'+branch.tag" :name="'tax['+index+']'" v-model="branch.tax" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'tax-'+branch.tag">
                                                                    Tax module
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'online-'+branch.tag" :name="'online['+index+']'" v-model="branch.online" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'online-'+branch.tag">
                                                                    Online Site
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'farmer_contract-'+branch.tag" :name="'farmer_contract['+index+']'" v-model="branch.farmer_contract" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'farmer_contract-'+branch.tag">
                                                                    Farmer Contract
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'close_year-'+branch.tag" :name="'close_year['+index+']'" v-model="branch.close_year" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'close_year-'+branch.tag">
                                                                    close Year
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'edit_company-'+branch.tag" :name="'edit_company['+index+']'" v-model="branch.edit_company" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'edit_company-'+branch.tag">
                                                                    Edit Company
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'contract-'+branch.tag" :name="'contract['+index+']'" v-model="branch.contract" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'contract-'+branch.tag">
                                                                    Contract
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'carpet_contract-'+branch.tag" :name="'carpet_contract['+index+']'" v-model="branch.carpet_contract" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'carpet_contract-'+branch.tag">
                                                                    Carpet Contract
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'cargo_contract-'+branch.tag" :name="'cargo_contract['+index+']'" v-model="branch.cargo_contract" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'cargo_contract-'+branch.tag">
                                                                    Cargo Contract
                                                                </label>
                                                            </span>
                                                            <br /> 
                                                            
                                                            <input type="checkbox" :id="'cheque-'+branch.tag" :name="'cheque['+index+']'" v-model="branch.cheque" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'cheque-'+branch.tag">
                                                                    Havaleh / Cheque
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'centeral_bank_exchange-'+branch.tag" :name="'centeral_bank_exchange['+index+']'" v-model="branch.centeral_bank_exchange" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'centeral_bank_exchange-'+branch.tag">
                                                                    Centeral Bank Exchange
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'static_rate-'+branch.tag" :name="'static_rate['+index+']'" v-model="branch.static_rate" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'static_rate-'+branch.tag">
                                                                    Static Currency Rate
                                                                </label>
                                                            </span>
                                                            <br />


                                                        </div>

                                                        <div class="col-md-6">

                                                            <input type="checkbox" :id="'prophil-'+branch.tag" :name="'prophil['+index+']'" v-model="branch.prophil" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'prophil-'+branch.tag">
                                                                    Prophil Project
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'prophilBuild-'+branch.tag" :name="'prophilBuild['+index+']'" v-model="branch.prophilBuild" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'prophilBuild-'+branch.tag">
                                                                    Prophil Build
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'shoes-'+branch.tag" :name="'shoes['+index+']'" v-model="branch.shoes" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'shoes-'+branch.tag">
                                                                    Shoes Project
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'pvc-'+branch.tag" :name="'pvc['+index+']'" v-model="branch.pvc" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'pvc-'+branch.tag">
                                                                    Project
                                                                </label>
                                                            </span>

                                                            <br />

                                                            <input type="checkbox" :id="'lang_translation-'+branch.tag" :name="'lang_translation['+index+']'" v-model="branch.lang_translation" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'lang_translation-'+branch.tag">
                                                                    Lang Translation
                                                                </label>
                                                            </span>

                                                            <br />

                                                            <input type="checkbox" :id="'bill_edit-'+branch.tag" :name="'bill_edit['+index+']'" v-model="branch.bill_edit" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'bill_edit-'+branch.tag">
                                                                    Bill Edit
                                                                </label>
                                                            </span>

                                                            <br />

                                                            <input type="checkbox" :id="'duplicate_code-'+branch.tag" :name="'duplicate_code['+index+']'" v-model="branch.duplicate_code" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'duplicate_code-'+branch.tag">
                                                                    Duplicate Code
                                                                </label>
                                                            </span>
                                                            <br />

                                                            <input type="checkbox" :id="'tailoring-'+branch.tag" :name="'tailoring['+index+']'" v-model="branch.tailoring" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'tailoring-'+branch.tag">
                                                                    Tailoring
                                                                </label>
                                                            </span>
                                                            <br /> 

                                                            <input type="checkbox" :id="'NGOProject-'+branch.tag" :name="'NGOProject['+index+']'" v-model="branch.NGOProject" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'NGOProject-'+branch.tag">
                                                                    NGO Project
                                                                </label>
                                                            </span> 
                                                            <br />

                                                            <input type="checkbox" :id="'currency_exchange-'+branch.tag" :name="'currency_exchange['+index+']'" v-model="branch.currency_exchange" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'currency_exchange-'+branch.tag">
                                                                    Currency Exchange
                                                                </label>
                                                            </span> 
                                                            <br />
                                                           
                                                            <input type="checkbox" :id="'financial_class-'+branch.tag" :name="'financial_class['+index+']'" v-model="branch.financial_class" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'financial_class-'+branch.tag">
                                                                    Financial Class
                                                                </label>
                                                            </span> 
                                                            <br />
                                                           
                                                            <input type="checkbox" :id="'service-'+branch.tag" :name="'service['+index+']'" v-model="branch.service" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'service-'+branch.tag">
                                                                    Service
                                                                </label>
                                                            </span> 
                                                            <br />
                                                           
                                                            <input type="checkbox" :id="'gas_station-'+branch.tag" :name="'gas_station['+index+']'" v-model="branch.gas_station" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'gas_station-'+branch.tag">
                                                                    Gas Station
                                                                </label>
                                                            </span> 
                                                            <br />
                                                            
                                                            <input type="checkbox" :id="'mobile_device-'+branch.tag" :name="'mobile_device['+index+']'" v-model="branch.mobile_device" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'mobile_device-'+branch.tag">
                                                                    Mobile Device
                                                                </label>
                                                            </span> 
                                                            <br />
                                                            
                                                            <input type="checkbox" :id="'simple_website-'+branch.tag" :name="'simple_website['+index+']'" v-model="branch.simple_website" :true-value="1" :false-value="0">
                                                            <span style="color: red">
                                                                <label :for="'simple_website-'+branch.tag">
                                                                    Simple Website
                                                                </label>
                                                            </span> 
                                                            <br />


                                                           
                                                           

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <a href="#" class="btn btn-warning" @click="deleteBranch(index)">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">

                                        </td>
                                        <td>
                                            <a class="btn btn-success" @click.prevent="pushNewBranch()">
                                                <i class="fa fa-plus"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-6">

                                </div>
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-offset-3 col-md-9">
                                            <button type="submit" class="btn green" @click.prevent="send()">@lang('layout.Submit')</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            <!-- END FORM-->
        </div>
    </div>
    <script src="{{url('assets/app/js/app.js')}}"></script>

    <script>
        let b = [];
        @if($config)
        b = {!! json_encode($config) !!}
        @endif

        new Vue({
            el: '#app',
            data: {
                branches: []
            },
            created() {
                if (b.length >= 1) {
                    console.log('config has branch');
                    b.forEach((a) => {
                        console.log(a);
                        this.branches.push({
                            id: a.id,
                            tag: a.tag,
                            taken: a.taken,
                            user_count: a.user_count,
                            inventory_count: a.inventory_site_count,
                            financial_class_count: a.financial_class_count,
                            custom_report: a.custom_report,
                            mainPart: a.mainPart,
                            build: a.build,
                            oil_and_gas: a.oil_and_gas,
                            tax: a.tax,
                            online: a.online,
                            prophil: a.prophil,
                            prophilBuild: a.prophilBuild,
                            shoes: a.shoes,
                            pvc: a.pvc,
                            lang_translation: a.lang_translation,
                            bill_edit: a.bill_edit,
                            duplicate_code: a.duplicate_code,
                            tailoring: a.tailoring,
                            NGOProject: a.NGOProject,
                            farmer_contract: a.farmer_contract,
                            close_year: a.close_year,
                            edit_company: a.edit_company,
                            contract: a.contract,
                            carpet_contract: a.carpet_contract,
                            cargo_contract: a.cargo_contract,
                            currency_exchange: a.currency_exchange,
                            financial_class: a.financial_class,
                            service: a.service,
                            gas_station: a.gas_station,
                            cheque: a.cheque,
                            centeral_bank_exchange: a.centeral_bank_exchange,
                            static_rate: a.static_rate,
                            data_storing_method: a.data_storing_method,
                            mobile_device:a.mobile_device,
                            mobile_device_count:a.mobile_device_count,
                            simple_website:a.simple_website
                        })
                    });
                } else
                    this.pushNewBranch();
                console.log('branch', this.branches);
            },

            methods: {
                pushNewBranch() {
                    let las_tag = this.branches.length >= 1 ? Number.parseFloat(this.branches[this.branches.length - 1].tag) + 1 : 1;
                    let taken = this.branches.length >= 1 ? 0 : 1;
                    this.branches.push({
                        id: null,
                        tag: las_tag,
                        taken: taken,
                        user_count: 1,
                        inventory_count: 1,
                        financial_class_count: 1,
                        custom_report: 0,
                        mainPart: 0,
                        build: 0,
                        oil_and_gas: 0,
                        tax: 0,
                        online: 0,
                        prophil: 0,
                        prophilBuild: 0,
                        shoes: 0,
                        pvc: 0,
                        lang_translation: 0,
                        bill_edit: 0,
                        duplicate_code: 0,
                        tailoring: 0,
                        NGOProject: 0,
                        farmer_contract: 0,
                        close_year: 0,
                        edit_company: 0,
                        contract: 0,
                        currency_exchange: 0,
                        financial_class: 0,
                        service: 0,
                        gas_station: 0,
                        carpet_contract: 0,
                        cargo_contract: 0,
                        cheque: 0,
                        centeral_bank_exchange: 0,
                        static_rate: 0,
                        mobile_device: 0,
                        mobile_device_count: 1,
                        simple_website:0

                    })
                },
                send() {
                    if (this.branches.length) {
                        document.getElementById("config_form").submit();
                    } else alert("You have not declared any branch")
                },
                deleteBranch(index) {

                    this.branches.splice(index, 1)
                }
            },
        });
    </script>
</body>

</html>