@extends('layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-left">
                <h2> @lang('layout.AddNewCurrency')</h2>
            </div>
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('support.currency.index') }}">@lang('layout.Back') </a>
            </div>
        </div>
    </div>


    {!! Form::open(array('route' => 'support.currency.store','method'=>'POST')) !!}
    {{ csrf_field() }}


    <div class="row">

        <div class="col-md-4">
            <div class="form-group">
                <label for="name" class="form-label">@lang('layout.Name')</label>
                <input type="text" id="name" class="form-control" name="name" placeholder="@lang('layout.Name')" required>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label for="code" class="form-label">@lang('layout.Code')</label>
                <input type="text" name="code" class="form-control" id="code" placeholder="@lang('layout.Code')" required>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label for="symbol" class="form-label">@lang('layout.Symbol')</label>
                <input type="text" name="symbol" class="form-control" placeholder="@lang('layout.Symbol')" required>
            </div>
        </div>



        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
        </div>

    </div>
    {!! Form::close() !!}
@endsection
@push('scripts')
    <script type="text/javascript">

        $(".js-example-basic-multiple").select2();
    </script>

    <select class="js-example-basic-multiple" multiple="multiple">
        x

        <!-- END PAGE LEVEL PLUGINS -->

        <!-- BEGIN PAGE LEVEL SCRIPTS -->

        <script src="{{url('/')}}/currencyPeker/dist/js/bootstrap-formhelpers.js" type="text/javascript"></script>
        <script src="{{url('/')}}/BootstrapFormHelpers/js/bootstrap-formhelpers-currencies.js" type="text/javascript"></script>
        <script src="{{url('/')}}/BootstrapFormHelpers/js/bootstrap-formhelpers-selectbox.js" type="text/javascript"></script>


        <!-- END PAGE LEVEL SCRIPTS -->

@endpush