@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('statement');
   
    $_date = !in_array('date', $report);
    $_account = !in_array('account', $report);
    $_type = !in_array('type', $report);
    $_receivable = !in_array('receivable', $report);
    $_payable = !in_array('payable', $report);
    $_currency = !in_array('currency', $report);
    $_rate = !in_array('rate', $report);
    $_receivable_home_currency = !in_array('receivable_home_currency', $report);
    $_payable_home_currency = !in_array('payable_home_currency', $report);
    $_description = !in_array('description', $report);
    $_item = !in_array('item', $report);
    $_name = !in_array('name', $report);
    $_quantity = !in_array('quantity', $report);
    $_measure = !in_array('measure', $report);
    $_price = !in_array('price', $report);
    $_total = !in_array('total', $report);
    $_number = !in_array('number', $report);
    $_receivable_total = !in_array('receivable_total', $report);
    $_payable_total = !in_array('payable_total', $report);
    $_details = !in_array('details', $report);
    $_balance = !in_array('balance', $report);
    $_area = !in_array('area', $report);
    $_member_class = !in_array('member_class', $report);
    $_total_item = !in_array('total_item', $report);
    $_report_total = !in_array('report_total', $report);
    $_hesab_sabiqa = !in_array('hesab_sabiqa', $report);
    $_customer_summary = !in_array('customer_summary', $report);

    ?>

    <?php
    if($member){
    ?>
    <h4>
    </h4>
    <table class="main-table">
        <tr class="center">
            <td>@lang('layout.Name') : {{$member[0]->name}}</td>
            <td>@lang('layout.Code') : {{$member[0]->code}}</td>
            <td>@lang('layout.JobTitle') : {{$member[0]->job_name}}</td>
            <td>@lang('layout.Email') : {{$member[0]->email}}</td>
            <td>@lang('layout.Phone') : {{$member[0]->phone}}, {{$member[0]->phone2}}</td>

        </tr>
    </table>
    <?php
    }
    ?>
    <br>
    <?php
    $count = 0;
    $currency_data = [];
    $total_payable = 0;
    $total_receivable = 0;
    $balance = 0;
    $statement_flag = '';
    $statement_flag_change = '';

    $check_duplicate=[];

    ?>
    @if(count($memberRecord))
        <h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>

            @if($from_date || $to_date)
            @if($_hesab_sabiqa)
            <div class="col-md-6">
                <div class="portlet sale-summary">
                    <div class="portlet-title">
                        <div class="caption font-red sbold" style="font-size: 20px"> @lang('layout.HesabSabiqa') </div>
                        <div class="tools">
                            <a class="reload" href="javascript:;"> </a>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-scrollable">
                            <table class="main-table border-blue-soft">
                                <thead>
                                <tr style="background-color: #2AB4C0">
                                    <th>
                                        <i class="fa fa-briefcase"></i> @lang('layout.Currency')
                                    </th>
                                    <th class="hidden-xs">
                                        <i class="fa fa-user"></i> @lang('layout.SReceivable')</th>
                                    <th>
                                        <i class="fa fa-briefcase"></i> @lang('layout.SPayable') </th>

                                </tr>
                                </thead>
                                <tbody>

                                   
                                @foreach(getStatementDate($member[0]->id,$from_date) AS $rec)
                                    <tr>
                                        <td class="highlight">
                                            {{$rec['currency']}}
                                        </td>
                                        <td class=""> {{ $rec['invoice'] }}</td>
                                        <td> {{ $rec['payment'] }}</td>

                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>

    @endif
    @endif
    <br>


        <table class="main-table">
            <thead>
            <tr class="bg">
                <td>
                    <div class="center"> @lang('layout.Record') </div>
                </td>
                @if($_date)
                    <td>
                        <div class="center"> @lang('layout.Date') </div>
                    </td>@endif
                    @if($_account)
                    <td>
                        <div class="center"> @lang('layout.Account') </div>
                    </td>
                    @endif
                @if($_type)
                    <td>
                        <div class="center"> @lang('layout.Type') </div>
                    </td>@endif
                 @if($_area)
                    <td>
                        <div class="center"> @lang('layout.SaleArea') </div>
                    </td>@endif
                @if($_member_class)
                    <td>
                        <div class="center"> @lang('layout.MemberClass') </div>
                    </td>@endif

                @if($_receivable)
                    <td>
                        <div class="center"> @lang('layout.SReceivable')</div>
                    </td>@endif
                @if($_payable)
                    <td>
                        <div class="center"> @lang('layout.SPayable')</div>
                    </td>@endif
                @if($_currency)
                    <td>
                        <div class="center"> @lang('layout.Currency') </div>
                    </td>@endif
                @if($_rate)
                    <td>
                        <div class="center"> @lang('layout.Rate') </div>
                    </td>@endif
                @if($_receivable_home_currency)
                    <td>
                        <div class="center"> @lang('layout.SReceivable') {{getHomeCurrency()['code']}}</div>
                    </td>@endif
                @if($_payable_home_currency)
                    <td>
                        <div class="center"> @lang('layout.SPayable') {{getHomeCurrency()['code']}}</div>
                    </td>@endif
                @if($_balance)
                    <td>
                        <div class="center">@lang('layout.Balance')</div>
                    </td>@endif
                @if($_description)
                    <td class="center">
                        <div class="center"> @lang('layout.Description') </div>
                    </td>@endif
            </tr>
            </thead>

            @foreach($memberRecord AS $record)
                <?php

                    $can_show=true;

                    // if(array_key_exists(__('type.'.$record->Type.$record->number.$record['Amount']), $check_duplicate))
                    // {

                    //     $can_show=false;
                    // }
                    // else
                    // {

                    //     $check_duplicate[__('type.'.$record->Type.$record->number.$record['Amount'])]=1;
                    // }

                ?>
                <tr>
                    <td class="center">{{++$count}}</td>
                    @if($_date)
                        <td class="center">{{convertDate($record->Date)}}</td>
					@endif
                    @if($_account)
                        <td class="center">{{$record->Account}}</td>
                    @endif
                    @if($_type)

                        <td class="center"><span>{{__('type.'.$record->Type)}}</span>:
                            {{$record->number}}
							
                            @if($record->Type=='BillRoll' && $record->orderNumber != null)
                            {{__('layout.Contract')}} ( {{$record->orderNumber}} )
                            @endif
							@if($record->Type !='BillRoll' && $record->orderNumber != null)
                            {{$record->purchases_num}} {{__('layout.Contract')}} ( {{$record->orderNumber}} )
                            @endif
							@if($record->Type !='BillRoll' && $record->purchases_num != null && $record->orderNumber == null)
                            {{$record->purchases_num}}
                            @endif
							
                            @if($record->Type=='adjustment')
                            {{adjustmentTransactionDetail($record->id)}}
                            @endif
                        </td>@endif
                    @if($_area)

                        <td class="center"><span>{{$record->areaName}}</span>
                            
                        </td>@endif
                    @if($_member_class)

                        <td class="center"><span>{{$record->className}}</span>
                            
                        </td>@endif
                    <?php
                    $p = 0;
                    $r = 0;
                    $tpp=0;
                    $trr=0;

                    if($can_show)
                    {
                        $r = ($record->type == 'r' OR $record->type == "rr") ? $record['Amount'] : 0;

                        $p = ($record['type'] == 'p' OR $record['type'] == 'pp') ? $record['Amount'] : 0;

                        $totalg = SumToNumber($p, $r);
                        $tpp = $totalg['a'];
                        $trr = $totalg['b'];
                        if (array_key_exists($record->Currency, $currency_data)) {
                            $total_payable += $tpp / $record->Rate;
                            $total_receivable += $trr / $record->Rate;

                            $p_p = $currency_data[$record->Currency]['p'];
                            $p_r = $currency_data[$record->Currency]['r'];

                            $currency_data[$record->Currency] = [
                                'p' => $tpp + $p_p,
                                'r' => $trr + $p_r,
                            ];
                        } else {
                            $total_payable += $tpp / $record->Rate;
                            $total_receivable += $trr / $record->Rate;
                            $currency_data[$record->Currency] = [
                                'p' => $tpp,
                                'r' => $trr,
                            ];
                        }
                    }
                    //end check show

                    // begin check for balance
                    if ($statement_flag == '') {
                        if ($tpp) {
                            $statement_flag = 'payable';
                            $statement_flag_change = 'receivable';
                            $balance += $tpp / $record->Rate;
                        } else {
                            $statement_flag = 'receivable';
                            $statement_flag_change = 'payable';
                            $balance += $trr / $record->Rate;
                        }
                    } else {
                        if ($trr) {
                            ($statement_flag == 'receivable') ? $balance += $trr / $record->Rate : $balance -= $trr / $record->Rate;
                        } else {
                            ($statement_flag == 'payable') ? $balance += $tpp / $record->Rate : $balance -= $tpp / $record->Rate;
                        }
                    }
                    // end check balance
                    ?>
                    @if($_receivable)
                        <td class="center ltr" >
                            <BDO DIR="LTR">

                                @if(getHomeCurrency()['code'] !=$record->Currency)
                                    {{($trr)?Currency()->format($trr,$record->Currency):''}}
                                @endif
                            </BDO>
                        </td>
                    @endif
                    @if($_payable)
                        <td class="center ltr">
                            <BDO DIR="LTR">

                                @if(getHomeCurrency()['code'] !=$record->Currency)
                                    {{($tpp)?Currency()->format($tpp,$record->Currency):''}}
                                @endif
                            </BDO>
                        </td>
                    @endif
                    @if($_currency)
                        <td class="center">{{$record->Currency}}</td>@endif
                    @if($_rate)
                        <td class="center">{{round($record->Rate,2)}}</td>@endif


                    @if($_receivable_home_currency)
                        <td class="center ltr">

                            {{($trr)?Currency()->format($trr/$record->Rate):''}}
                        </td>@endif
                    @if($_payable_home_currency)
                        <td class="center ltr">

                            {{($tpp)?Currency()->format($tpp/$record->Rate):''}}

                        </td>@endif
                    @if($_balance)
                        <td class="center ltr">
                            @if($balance>0)
                                {{myRound(abs($balance))}}
                                {{getHomeCurrency()['code']}}
                                :{{__('layout.'.ucfirst($statement_flag))}}
                            @else
                                {{myRound(abs($balance))}}
                                {{getHomeCurrency()['code']}}
                                :{{__('layout.'.ucfirst($statement_flag_change))}}
                            @endif

                        </td>
                    @endif
                    @if($_description)
                        <td class="center">
                            <?php 
                            $des = wordwrap($record->Description,70,"<br/>\n",false);
                            echo $des;
                            ?>
                        </td>@endif
                </tr>
            @endforeach

        </table>
        <br>
    @endif

    @if(count($items))
        <?php

        $measure_total = [];
        $check_duplicate=[];
        ?>
        <table class="main-table">


            <tr class="bg">
                <td>
                    <div class="center"> @lang('layout.Record') </div>
                </td>
                @if($_date)
                    <td>
                        <div class="center"> @lang('layout.Date') </div>
                    </td>@endif
                @if($_type)
                    <td>
                        <div class="center"> @lang('layout.Type') </div>
                    </td>@endif
                @if($_area)
                    <!--td>
                        <div class="center"> @lang('layout.SaleArea') </div>
                    </td-->@endif
                @if($_member_class)
                    <!--td>
                        <div class="center"> @lang('layout.MemberClass') </div>
                    </td-->@endif
                @if($_receivable)
                    <td>
                        <div class="center"> @lang('layout.SReceivable')  </div>
                    </td>@endif
                @if($_payable)
                    <td>
                        <div class="center"> @lang('layout.SPayable') </div>
                    </td>@endif
                @if($_currency)
                    <td>
                        <div class="center"> @lang('layout.Currency') </div>
                    </td>@endif
                @if($_rate)
                    <td>
                        <div class="center"> @lang('layout.Rate') </div>
                    </td>@endif
                @if($_receivable_home_currency)
                    <td>
                        <div class="center"> @lang('layout.SReceivable') {{getHomeCurrency()['code']}} </div>
                    </td>@endif
                @if($_payable_home_currency)
                    <td>
                        <div class="center"> @lang('layout.SPayable') {{getHomeCurrency()['code']}} </div>
                    </td>@endif
                @if($_description)
                    <td style="display: <?=(!show('description', $report)) ? 'none' : '';?>">
                        <div class="center"> @lang('layout.Description') </div>
                    </td>@endif


                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Item') </div>
                    </td>@endif
                @if($_quantity)
                    <td>
                        <div class="center"> @lang('layout.Quantity') </div>
                    </td>@endif
                @if($_measure)
                    <td>
                        <div class="center"> @lang('layout.Measure') </div>
                    </td>@endif
                @if($_price)
                    <td>
                        <div class="center"> @lang('layout.Price') </div>
                    </td>@endif
                @if($_total)
                    <td>
                        <div class="center"> @lang('layout.Total') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Balance') </div>
                    </td>@endif
            </tr>
            @foreach($items AS $item)
                <?php

                


                $p = 0;
                $r = 0;
                $r = ($item['type'] == 'r' OR $item['type'] == "rr") ? $item['Amount'] : 0;

                $p = ($item['type'] == 'p' OR $item['type'] == 'pp') ? $item['Amount'] : 0;

                $totalg = SumToNumber($p, $r);
                $tpp = $totalg['a'];
                $trr = $totalg['b'];
                if (array_key_exists($item['Currency'], $currency_data)) {
                    $total_payable += $tpp / $item['Rate'];
                    $total_receivable += $trr / $item['Rate'];

                    $p_p = $currency_data[$item['Currency']]['p'];
                    $p_r = $currency_data[$item['Currency']]['r'];

                    $currency_data[$item['Currency']] = [
                        'p' => $tpp + $p_p,
                        'r' => $trr + $p_r,
                    ];
                } else {
                    $total_payable += $tpp / $item['Rate'];
                    $total_receivable += $trr / $item['Rate'];
                    $currency_data[$item['Currency']] = [
                        'p' => $tpp,
                        'r' => $trr,
                    ];
                }


               
                ?>




                @if($item['items'])
                    @foreach($item['items'] AS $detail)

                        <?php
                        // begin check for balance
                        if ($statement_flag == '') {
                            if ($tpp) {
                                $statement_flag = 'payable';
                                $statement_flag_change = 'receivable';
                                $balance += $detail['Cost']*$detail['Qty'] / $item['Rate'];
                            } else {
                                $statement_flag = 'receivable';
                                $statement_flag_change = 'payable';
                                $balance += $detail['Cost']*$detail['Qty'] / $item['Rate'];
                            }
                        } else {
                            if ($trr) {
                                ($statement_flag == 'receivable') ? $balance += $detail['Cost']*$detail['Qty'] / $item['Rate'] : $balance -= $detail['Cost']*$detail['Qty'] / $item['Rate'];
                            } else {
                                ($statement_flag == 'payable') ? $balance += $detail['Cost']*$detail['Qty'] / $item['Rate'] : $balance -= $detail['Cost']*$detail['Qty'] / $item['Rate'];
                            }
                        }
                        // end check balance
                        $can_show=true;

                        // if(array_key_exists(__('type.'.$item['Type'].$item['number']), $check_duplicate))
                        // {

                        //     $can_show=false;
                        // }
                        // else
                        // {

                        //     $check_duplicate[__('type.'.$item['Type'].$item['number'])]=1;
                        // }



                        if (array_key_exists($detail['Measure'], $measure_total)) {
                            $p_q = $measure_total[$detail['Measure']]['qty'];
                            $p_t = $measure_total[$detail['Measure']]['total'];

                            $measure_total[$detail['Measure']]['qty'] = $p_q + $detail['Qty'];
                            $measure_total[$detail['Measure']]['total'] = $p_t + $detail['Cost'] * $detail['Qty'];
                        } else {
                            $measure_total[$detail['Measure']] = [
                                'qty' => $detail['Qty'],
                                'total' => $detail['Cost'] * $detail['Qty'],
                            ];
                        }
                        ?>


                        <tr>
                            <td>
                                <div class="center">{{++$count}}</div>
                            </td>
                            @if($_date)
                                <td class="center">{{convertDate($item['Date'])}}</td>@endif
                            @if($_type)
                                <td>
                                    <div class="center">
                                        <span>{{__('type.'.$item['Type'])}}</span><span>:</span><span>{{$item['number']}}

                                        </span>
                                        @if($item['Type']=='adjustment')
                                        {{adjustmentTransactionDetail($item['id'])}}
                                        @endif
                                    </div>
                                </td>@endif
                            @if($_area)
                                <!--td class="center"></td-->@endif
                            @if($_member_class)
                                <!--td class="center"></td -->@endif


                            @if($_receivable)
                                <td class="center ltr">
                                    <BDO DIR="LTR">
                                        @if(getHomeCurrency()['code'] !=$item['Currency'] && $can_show)
                                            {{($trr)?Currency()->format($trr,$item['Currency']):''}}
                                        @endif
                                    </BDO>
                                </td>@endif

                            @if($_payable)
                                <td class="center ltr">
                                    <BDO DIR="LTR">
                                        @if(getHomeCurrency()['code'] !=$item['Currency'] && $can_show)
                                            {{($tpp)?Currency()->format($tpp,$item['Currency']):''}}
                                        @endif
                                    </BDO>
                                </td>@endif

                            @if($_currency)
                                <td class="center">{{$item['Currency']}}</td>@endif
                            @if($_rate)
                                <td class="center">{{round($item['Rate'],2)}}</td>@endif
                            @if($_receivable_home_currency)
                                <td class="center">
                                    @if($can_show)
                                    {{($trr)?Currency()->format($trr/$item['Rate']):''}}
                                    @endif
                                </td>@endif
                            @if($_payable_home_currency)
                                <td class="center">
                                    @if($can_show)
                                    {{($tpp)?Currency()->format($tpp/$item['Rate']):''}}
                                    @endif
                                </td>@endif


                            @if($_description)
                                <td class="center">{{$item['description']}}</td>@endif
                            @if($_item)
                                <td>{{$detail['ItemName']}}</td>@endif
                            @if($_quantity)
                                <td>{{$detail['Qty']}}</td>@endif
                            @if($_measure)
                                <td>{{$detail['Measure']}}</td>@endif
                            @if($_price)
                                <td>{{$detail['Cost']}}</td>@endif
                            @if($_total)
                                <td>{{Currency()->format(($detail['Cost']*$detail['Qty']),$item['Currency'])}}</td>@endif
                            @if($_item)
                                <td>
                                    @if($balance>0)
                                        {{round(abs($balance),2)}}
                                        {{getHomeCurrency()['code']}}
                                        :{{__('layout.'.ucfirst($statement_flag))}}
                                    @else
                                        {{round(abs($balance),2)}}
                                        {{getHomeCurrency()['code']}}
                                        :{{__('layout.'.ucfirst($statement_flag_change))}}
                                    @endif
                                </td>@endif

                        <tr>
                    @endforeach
                @endif





            @endforeach
        </table>
        @if(count($measure_total))
            @if($_total_item)
            <table class="main-table">
                <tr class="bg">
                    <td>
                        <div class="center"> @lang('layout.Record') </div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Measure')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Quantity')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Cost')</div>
                    </td>
                </tr>
                @foreach($measure_total AS $k=>$v)
                    <tr>
                        <td>
                            <div class="center"> @lang('layout.Record') </div>
                        </td>
                        <td>
                            <div class="center"> {{$k}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v['qty']}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v['total']}}</div>
                        </td>
                    </tr>
                @endforeach

            </table>
        @endif
        @endif
        <br>

    @endif

    <!-- begin sammary -->
    @if(count($currency_data))
        @if($_report_total)
        <table class="main-table">

            <tr class="bg">
                @if($_receivable_total)
                    <td>
                        <div class="center"> @lang('layout.SReceivableTotal') </div>
                    </td>@endif
                @if($_payable_total)
                    <td>
                        <div class="center"> @lang('layout.SPayableTotal') </div>
                    </td>@endif
                @if($_details)
                    <td>
                        <div class="center"> @lang('layout.Details') </div>
                    </td>@endif
            </tr>

            <tr>

                <?php
                $t_payable = 0;
                $t_receivable = 0;
                $a = SumToNumber($total_payable, $total_receivable);
                $t_payable = $a['a'];
                $t_receivable = $a['b'];
                ?>
                @if($_receivable_total)
                    <td class="center ltr">{{Currency()->format($t_receivable,getHomeCurrency()['code'])}}</td>@endif
                @if($_payable_total)
                    <td class="center ltr">{{Currency()->format($t_payable,getHomeCurrency()['code'])}}</td>@endif

                @if($_details)
                    <td width="60%">

                        <table class="main-table" style="width:100%">
                            <tr class="bg">
                                <td width="25%">
                                    <div class="center"> @lang('layout.Currency') </div>
                                </td>
                                <td width="25%">
                                    <div class="center ltr"> @lang('layout.SReceivable') </div>
                                </td>
                                <td width="25%">
                                    <div class="center ltr"> @lang('layout.SPayable') </div>
                                </td>
                                <td width="25%">
                                    <div class="center ltr"> @lang('layout.Balance') </div>
                                </td>
                            </tr>
                            <?php
                            $count = 0;
                            $tempName = '';
                            ?>
                            @foreach($currency_data AS $k=>$v)

                                <?php
                                $rowSpan = -1;
                                if ($tempName == $k) {
                                    $rowSpan++;
                                }
                                $tempName = $k;
                                ?>

                                <tr>
                                    <td class="center ltr"><BDO DIR="LTR">{{$k}}</BDO></td>
                                    <td class="center ltr"><BDO DIR="LTR">{{$v['r']}}</BDO></td>
                                    <td class="center ltr"><BDO DIR="LTR">{{$v['p']}}</BDO></td>
                                    <td class="center ltr">

                                        <?php
                                        $bt_payable = 0;
                                        $bt_receivable = 0;
                                        $a = SumToNumber($v['p'], $v['r']);
                                        $bt_payable = $a['a'];
                                        $bt_receivable = $a['b'];
                                        ?>

                                        @if($bt_receivable !=0)
                                            <BDO DIR="LTR">
                                                {{Currency()->format($bt_receivable,$k)}}
                                            </BDO>
                                            <span> @lang('layout.Receivable')</span>

                                        @else
                                            <BDO DIR="LTR">
                                                {{Currency()->format($bt_payable,$k)}}

                                            </BDO>
                                            <span>@lang('layout.Payable')</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </table>

                    </td>
                @endif
            </tr>
        </table>
    @endif
    @endif
    <!-- end sammary -->


    <br>
    @if($from_date || $to_date)
    @if($_customer_summary)
        <div class="col-md-6">
            <div class="portlet sale-summary">
                <div class="portlet-title">
                    <div class="caption font-red sbold" style="font-size: 20px"> @lang('layout.CustomerSummary') </div>
                    <div class="tools">
                        <a class="reload" href="javascript:;"> </a>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-scrollable">
                        <table class="main-table border-blue-soft">
                            <thead>
                            <tr style="background-color: #2AB4C0">
                                <th>
                                    <i class="fa fa-briefcase"></i> @lang('layout.Currency')
                                </th>
                                <th class="hidden-xs">
                                    <i class="fa fa-user"></i> @lang('layout.SReceivable')</th>
                                <th>
                                    <i class="fa fa-briefcase"></i> @lang('layout.SPayable') </th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach(getStatement($member[0]->id) AS $rec)
                                <tr>
                                    <td class="highlight">
                                        {{$rec['currency']}}
                                    </td>
                                    <td class=""> {{ $rec['invoice'] }}</td>
                                    <td> {{ $rec['payment'] }}</td>

                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    @endif    
    @endif    




           <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection