@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('
profile/profile-2.min.css')}}">
    <style type="text/css">
        .padding {
            padding: 0px;
        }
    </style>

@stop
@section('content')
    @include('customers.modal')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="''"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="member_id" value="{{$vendor->member_id}}"/>
                <input type="hidden" name="type" :value="type"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <div id="print-modal_statement">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'vendorStatement'"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="type" value="vendorStatement"/>
                <input type="hidden" name="type_name" value="supervisor"/>
                <input type="hidden" name="member_id" value="{{$vendor->member_id}}"/>
                <div class="row">
                    <div class="form-group">

                        <div>
                            <label>@lang('layout.HomeCurency')</label>
                            <input class="mt-checkbox" type="checkbox" name="home_currency" checked="">
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Currency') </label>
                            <select name="currency" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach(currencyList() AS $currency)
                                    <option value="{{$currency->code}}">{{$currency->code}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" class="form-control">
                                <option value="item">@lang('layout.WithItem')</option>
                                <option selected="selected" value="">@lang('layout.WithoutItem')</option>
                                <!-- <option value="afghan">Afghan</option> -->
                            </select>
                        </div>


                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.SupervisorShow')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="tabbable-line tabbable-full-width">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#tab_1_1" data-toggle="tab"> @lang('layout.Overview') </a>
                    </li>
                    <li>
                        <a href="#tab_1_3" data-toggle="tab"> @lang('layout.Info') </a>
                    </li>
                    <div class="btn-group pull-right ">
        <span id="app" v-cloak>
                  
         <button class="btn btn-success" v-if="!checkStatus"
                 onclick="location.href='{{route('memberOpeningBalance.create',$vendor->id)}}'">@lang('layout.OpeningBalance')</button>


    </span>


                    </div>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1_1">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; padding: 0px 0px 0px 0px;">
                                <div style="display: flex;justify-content: space-around;flex-wrap: wrap;">
                                    <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-left: 10px !important; padding: 10px;margin-bottom: 10px;">
                                        <div style="display: flex;align-items: center;">
                                            <div title="{{$vendor->name}}" class="twPc-avatarLink" style="margin-left: 10px;margin-right: 10px;">
                                                @if($vendor->photo ==Null)
                                                    <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                                         style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141) !important;">
                                                @else
                                                    <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$vendor->photo)!!}"
                                                         style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141) !important;">
                                                @endif
                                            </div>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <td colspan="2" class="text-center" style="font-size: 20px;font-weight: bold;">{{$vendor->name}}</td>
                                                </tr>
                                                <tr>
                                                    <th class="text-center"><i class="fa fa-mobile"></i></th>
                                                    <td class="text-center">{{$vendor->phone}}</td>
                                                </tr>
                                                <tr>
                                                    <th class="text-center"><i class="fa fa fa-envelope"></i></th>
                                                    <td class="text-center">{{$vendor->email}}</td>
                                                </tr>
                                                <tr>
                                                    <th class="text-center"><i class="fa fa-home"></i></th>
                                                    <td class="text-center">{{$vendor->city}}</td>
                                                </tr>
                                                <tr>
                                                    <th class="text-center"><i class="fa calendar-plus-o"></i></th>
                                                    <td class="text-center">{{convertDate($vendor->reg_date)}}</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    {{-- <div class="col-lg-1 col-md-12 col-sm-12 col-xs-12"></div> --}}
                                    <div class="col-lg-5 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                        <div class="col-md-12" id="customer-summary" v-cloak>
                                            <div class="row">
                                                {{-- <div class="col-md-6 profile-info">
                                                    <h1 class="font-green sbold uppercase">{{$vendor->name}}</h1>
                                                    <div style="margin-top: 20%;">
                                                        <ul class="list-inline">
                                                            <li>
                                                                <i class="fa fa-user"></i> {{$vendor->name}}
                                                            </li>
                                                            <li>
                                                                <i class="fa fa-mobile"></i> {{$vendor->phone}}
                                                            </li>
                                                            <li>
                                                                <i class="fa fa fa-envelope"></i> {{$vendor->email}}
                                                            </li>
                                                            <li>
                                                                <i class="fa fa-home"></i> {{$vendor->city}}
                                                            </li>
                                                            <li>
                                                                <i class="fa calendar-plus-o"></i> {{convertDate($vendor->reg_date)}}
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div> --}}
                                                <!--end col-md-8-->
            
                                                <div class="col-md-12">
                                                    <div class="portlet sale-summary">
                                                        <div class="portlet-title">
                                                            <div class=" font-black sbold text-center" style="font-size: 20px;margin-top: 5px;color: black !important;"> @lang('layout.SupervisorSummary') </div>
                                                            <div class="tools">
                                                                {{-- <a class="reload" href="javascript:;"> </a> --}}
                                                            </div>
                                                        </div>
                                                        <div class="portlet-body">
                                                            <div class="table-scrollable">
                                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <thead>
                                                                    <tr>
                                                                        <th class="text-center">
                                                                            <i class="fa fa-money"></i> @lang('layout.Currency')
                                                                        </th>
                                                                        <th class="text-center">
                                                                            <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                                        </th>
                                                                        <th class="text-center">
                                                                            <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                                        </th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    @foreach(getStatement($vendor->member_id) AS $rec)
                                                                        <tr>
                                                                            <td class="highlight text-center">
                                                                                {{$rec['currency']}}
                                                                            </td>
                                                                            <td class="text-center"> {{ $rec['invoice'] }}</td>
                                                                            <td class="text-center"> {{ $rec['payment'] }}</td>
            
                                                                        </tr>
                                                                    @endforeach
            
                                                                    </tbody>
                                                                </table>
                                                            </div>
            
                                                        </div>
                                                    </div>
                                                </div>
            
                                                <!--end col-md-4-->
                                            </div>
                                            <!--end row-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="">
                            <div class="col-md-2">
                                <ul class="list-unstyled profile-nav">
                                    <li>
                                        <div title="{{$vendor->name}}" class="twPc-avatarLink">
                                            @if($vendor->photo ==Null)
                                                <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                                     style="width:170px; height:170px;">
                                            @else
                                                <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$vendor->photo)!!}"
                                                     style="width:170px; height:170px;">
                                            @endif
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-10" id="customer-summary" v-cloak>
                                <div class="row">
                                    <div class="col-md-6 profile-info">
                                        <h1 class="font-green sbold uppercase">{{$vendor->name}}</h1>
                                        <div style="margin-top: 20%;">
                                            <ul class="list-inline">
                                                <li>
                                                    <i class="fa fa-user"></i> {{$vendor->name}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-mobile"></i> {{$vendor->phone}}
                                                </li>
                                                <li>
                                                    <i class="fa fa fa-envelope"></i> {{$vendor->email}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-home"></i> {{$vendor->city}}
                                                </li>
                                                <li>
                                                    <i class="fa calendar-plus-o"></i> {{convertDate($vendor->reg_date)}}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!--end col-md-8-->

                                    <div class="col-md-6">
                                        <div class="portlet sale-summary">
                                            <div class="portlet-title">
                                                <div class="caption font-red sbold"> @lang('layout.SupervisorSummary') </div>
                                                <div class="tools">
                                                    <a class="reload" href="javascript:;"> </a>
                                                </div>
                                            </div>
                                            <div class="portlet-body">
                                                <div class="table-scrollable">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <thead>
                                                        <tr>
                                                            <th>
                                                                <i class="fa fa-money"></i> @lang('layout.Currency')
                                                            </th>
                                                            <th class="hidden-xs">
                                                                <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                            </th>
                                                            <th>
                                                                <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                            </th>

                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        @foreach(getStatement($vendor->member_id) AS $rec)
                                                            <tr>
                                                                <td class="highlight">
                                                                    {{$rec['currency']}}
                                                                </td>
                                                                <td class=""> {{ $rec['invoice'] }}</td>
                                                                <td> {{ $rec['payment'] }}</td>

                                                            </tr>
                                                        @endforeach

                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    <!--end col-md-4-->
                                </div>
                                <!--end row-->
                            </div>
                        </div> --}}
                        <div class="">
                            <div class="tabbable-line tabbable-custom-profile">
                                <ul class="nav nav-tabs">
                                    <!-- li class="">
                                        <a href="#Purchases" data-toggle="tab" id="Purch-table">
                                            <i class=" icon-basket-loaded"></i><b> @lang('layout.Purchases') </b></a>
                                    </li>
                                    <li class="">
                                        <a href="#bill" data-toggle="tab" id="ven-bill">
                                            <i class="icon-note"></i><b> @lang('layout.Bills')</b> </a>
                                    </li>
                                    <li class="">
                                        <a href="#payments" data-toggle="tab" id="cus-payments">
                                            <i class="fa  "></i><b> @lang('layout.Pyments') </b></a>
                                    </li -->
                                    <li class="active">
                                        <a href="#statement" data-toggle="tab" id="cus-statement">
                                            <i class="icon-credit-card"></i><b> @lang('layout.Statements') </b></a>
                                    </li>
                                </ul>
                                <div class="tab-content padding" style="padding: 0px;">
                                    <div class="tab-pane" id="Purchases">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.PurchasesDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                         <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal('purchaselist')" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="pur">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.PurchaseNumber')</th>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Type')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <!--tab-pane-->
                                    <div class="tab-pane" id="bill">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.BillDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <button onclick="openModal('builllist')" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="bills">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.BillNumber')</th>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="payments">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.PaymentsDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <button onclick="openModal('all_pay')" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="payment-table">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Rate')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane active" id="statement">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.StatementDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <button onclick="openModal('statement',true)" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>


                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="statement-table">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Description')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Rate')</th>
                                                                <th>@lang('layout.Type')</th>
                                                                <th>@lang('layout.Receivable')</th>
                                                                <th>@lang('layout.Payable')</th>
                                                                <th>@lang('layout.Date')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <!--  -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--tab_1_2-->
                    <div class="tab-pane" id="tab_1_3">
                        <div class=" profile-account">
                            <div class="col-md-3">
                                <ul class="ver-inline-menu tabbable margin-bottom-10">
                                    <li class="active">
                                        <a data-toggle="tab" href="#tab_1-1">
                                            <i class="icon-user"></i> @lang('layout.PersonalInfo') </a>
                                        <span class="after"> </span>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_2-2">
                                            <i class="icon-home"></i> @lang('layout.AddressInfo') </a>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_3-3">
                                            <i class="fa fa-bars"></i> @lang('layout.OtherInformations') </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-9">
                                <div class="tab-content">
                                    <div id="tab_1-1" class="tab-pane active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.Email')</th>
                                                        <th>@lang('layout.Phone')</th>
                                                        <th>@lang('layout.Phone2')</th>
                                                        <th>@lang('layout.Code')</th>
                                                        <th>@lang('layout.Gender')</th>
                                                        <th>@lang('layout.BossName')</th>
                                                        <th>@lang('layout.DateOfBirth')</th>
                                                        <th>@lang('layout.Membership')</th>
                                                        <th>@lang('layout.Date')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class="hidden-xs"> {{ $vendor->email }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->phone }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->phone2 }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->code }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->gender }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->bossName }}  </td>
                                                        <td class="hidden-xs"> {{ convertDate($vendor->date_of_birth) }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->membership }}  </td>
                                                        <td class="hidden-xs"> {{ convertDate($vendor->reg_date) }}  </td>
                                                    </tr>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="tab_2-2" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.Address1')</th>
                                                        <th>@lang('layout.Address2')</th>
                                                        <th>@lang('layout.PostCode')</th>
                                                        <th>@lang('layout.City')</th>
                                                        <th>@lang('layout.Country')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class="hidden-xs"> {{ $vendor->address1 }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->address2 }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->post_code }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->city }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->country }}  </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                                     <div id="tab_3-3" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.LicenseNumber')</th>
                                                        <th>@lang('layout.LicenseIssueDate')</th>
                                                        <th>@lang('layout.LicenseExpireDate')</th>
                                                        <th>@lang('layout.PassportNumber')</th>
                                                        <th>@lang('layout.SSID')</th>
                                                        <th>@lang('layout.BossName')</th>
                                                        <th>@lang('layout.BossSSN')</th>
                                                        <th>@lang('layout.BossPassport')</th>
                                                        <th>@lang('layout.AssistantName')</th>
                                                        <th>@lang('layout.AssistantSSN')</th>
                                                        <th>@lang('layout.AssistantPassport')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class="hidden-xs"> {{ $vendor->company_license_number }}  </td>
                                                        <td class="hidden-xs"> {{ convertDate($vendor->license_issue_date) }}  </td>
                                                        <td class="hidden-xs"> {{ convertDate($vendor->license_expire_date) }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->passport }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->ss_id }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->boss_name }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->boss_ssn }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->boss_passport }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->assistant_name }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->assistant_ssn }}  </td>
                                                        <td class="hidden-xs"> {{ $vendor->assistant_passport }}  </td>
                                                    </tr>


                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <!--end col-md-9-->
                        </div>
                    </div>
                    <!--end tab-pane-->

                    <!--end tab-pane-->
                </div>
            </div>
        </div>
    </div>
    <iframe id="payframe" style="display: none;"></iframe>

@endsection


@include('print.modal')
@push('scripts')

    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        @if (Session('payment_id'))
        printVoucher("{{Session('payment_id')}}")
        @endif

        //   function printVoucher(id){
        //     document.getElementById("payframe").src ="{{url('printPayment')}}/"+id;

        // }
        function printVoucher(id) {
            document.location.href = "{{url('printPayment')}}/" + id;

        }

        Vue.component('modal', {
            template: '#modal-template'
        });

        new Vue({
            el: '#customer-summary',
            data: {

                summary: {!! memberBalance($vendor->id) !!},

            },
            methods: {}

        });
        new Vue({
            el: '#app',
            data: {
                balance: {},

                amount: null,
                selectedCurrency:{!! json_encode(Currency()->getCurrency()) !!},
                currency:{!!  json_encode(getCurrencies()) !!},
                showModal: false,
                prepaidModal: false,
                checkStatus: "{{$vendor->status}}"
            },
            computed: {

                // accountUpdate() {
                //     var b = _.clone(Banks)
                //     return this.accounts = b.filter((account) => {
                //         return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                //     })
                // },
            },
            methods: {

                openingSubmit() {

                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-opening-balance").submit()

                            } else {

                            }
                        });
                },
                prepaidSubmit() {

                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-prepaid-balance").submit()

                            } else {

                            }
                        });
                }
            }

        });

        $('#pur').DataTable({
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            retrieve: true,
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            ajax: {
                url: '{{route("vendor.show",$vendor->id)}}',
                data: {type: 'purchase'}
            },

            columns: [
                {data: 'Number', name: 'purchases.number'},
                {data: 'Account', name: 'accounts.name'},
                {data: 'Date', name: 'Date', orderable: false, searchable: false},
                {data: 'Type', name: 'purchases.type'},
                {data: 'Amount', name: 'Amount', orderable: false, searchable: false},
                {data: 'Currency', name: 'transactions.unit'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });


        // Purchases  scripts end

        // Invoices  scripts starts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#ven-bill').on('shown.bs.tab', function (event) {

                $('#bills').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    paging: true,
                    retrieve: true,
                    ajax: {

                        url: '{{route("vendor.show",$vendor->id)}}',
                        data: {type: 'bill'}
                    },
                    columns: [
                        {data: 'Number', name: 'Number'},
                        {data: 'Account', name: 'accounts.name'},
                        {data: 'Date', name: 'Date', orderable: false, searchable: false},
                        {data: 'Amount', name: 'transactions.amount', orderable: false, searchable: false},
                        {data: 'Currency', name: 'transactions.unit'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });

        // Payments scripts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-payments').on('shown.bs.tab', function (event) {

                $('#payment-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    retrieve: true,

                    ajax: {
                        url: '{{route("vendor.show",$vendor->id)}}',
                        data: {type: 'payment'}
                    },
                    columns: [

                        {data: 'Account', name: 'accounts.name'},
                        {data: 'Date', name: 'Date', orderable: false, searchable: false},
                        {data: 'Amount', name: 'Amount', orderable: false, searchable: false},
                        {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                        {data: 'Currency', name: 'transactions.unit'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });

        // Pyaments  scripts end

        // begin of statement
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            // $('#cus-statement').on('shown.bs.tab', function (event) {
                $('#statement-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    paging: true,
                    retrieve: true,
                    order: [[7, "desc"]],
                    ajax: {
                        url: '{{route("vendor.show",$vendor->member_id)}}',
                        data: {type: 'statements'}
                    },
                    columns: [
                        {data: 'Account', name: 'Account'},
                        {data: 'Description', name: 'Description'},
                        {data: 'Currency', name: 'Currency'},
                        {data: 'Rate', name: 'Rate'},
                        {data: 'Type', name: 'Type'},
                        {data: 'Receiable', name: 'Receiable'},
                        {data: 'Payable', name: 'Payable'},
                        {data: 'Date', name: 'Date'}
                    ]
                });
            // });
        });

        // end of statement


        function openModal(type, is_statment = false) {
            if (is_statment == false) {

                anchorM.showModal(type);
            }
            else {
                vm_statement.$data.is_show = true;
            }
        }


        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchorM = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function (type = null) {
                    vm.$data.type = type;
                    console.log('trr', type)
                    vm.$data.is_show = true;
                }
            }
        });


        var vm_statement = new Vue({

            el: '#print-modal_statement',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

    </script>
@endpush
