@extends('layouts.app')

@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'member_statment'"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="type_name" value="Supervisor"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option value="" selected="selected">@lang('layout.WithStatment')</option>
                                <option value="1">@lang('layout.WithoutStatment')</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2"
                                      v-model="selectedMember"
                                      :multiple="true" label="name"
                                      @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   :value="member_id.length > 0 ? member_id:null">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectClass') </label>
                            <select name="class_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectClass')</option>
                                @foreach($member_class as  $class)
                                    <option value="{{$class->id}}">{{$class->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <label class="control-label ">@lang('layout.ReportType') </label>
                        <select name="report_type" id="" class="form-control">
                            <option value="">@lang('layout.SelectReportType')</option>
                            <option value="Receivable">@lang('layout.Payable')</option>
                            <option value="Payable">@lang('layout.Receivable')</option>
                        </select>
                    </div>
                </div>


                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>
    @include('vendors.modal')
    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SupervisorList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('Supervisor-export')
                    <span id="anchore-modal">
                           <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                              <i class="fa fa-print"></i>
                           </a>
                       </span>
                    @endpermission
                    @permission('Supervisor-create')
                    <a href="{{route('supervisor.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" dt-responsive
                 width="100%" cellspacing="0" width="100%" id="supervisor">
                <thead>
                <tr>
                    <th>@lang('layout.Code') </th>
                    <th>@lang('layout.FullName') </th>
                    @if(getCustomerStatement() =="true")
                        <th>@lang('layout.TotalBalances') {{getHomeCurrency()['code']}} </th>
                     @endif
                    <th>@lang('layout.Email') </th>
                    <th>@lang('layout.Phone') </th>
                    <th>@lang('layout.CreatedAt') </th>
                    <th>@lang('layout.Status')</th>
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Actions') </th>
                </tr>
                </thead>
                <tfoot>

                </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#supervisor').DataTable({
                ajax: '{{route("supervisor.index")}}',
                pageLength:'{{getPageRows()}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'name', name: 'name'},
                     @if(getCustomerStatement() =="true") {
                        data: 'totalBalances',
                        name: 'totalBalances',
                        orderable: false,
                        searchable: false
                    }, @endif
                    {data: 'email', name: 'email'},
                    {data: 'phone', name: 'phone'},
                    {data: 'created_at', name: 'measure', searchable: false},
                    // {data: 'updated_at', name: 'account', orderable: false, searchable: false},
                    {data: 'status', name: 'status'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


                ]


            });


        });
        Vue.component('v-select', VueSelect.VueSelect);


        // for new modal


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: [],
                memberlist: [],
                member_id: []

            },
            watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.member_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Supervisor',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>


@endpush

@section('vselectStyle')
    <style type="text/css">
        .v-select .selected-tag {
            height: auto !important;
        }
    </style>
@endsection