@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 <style>
    .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
</style>
@stop
@section('content')
@include('inventories.cmodal') 
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.SupervisorCreate') </span>
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" id="app"  v-cloak >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'supervisor.store','method'=>'POST','class'=>'form-horizontal','id'=>'member-form','files'=> true)) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <h3 class="form-section">@lang('layout.PersonInfoo')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.FullName')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Code')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code', $code, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                                </div>
                                 
                                
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                <div class="col-md-9">
                                    <input type="text" id="date_of_birth" name="date_of_birth" class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-3">
                            <label class="control-label col-md-6">@lang('layout.Gender')</label>
                                <div class="col-md-6">
                                    <div >
                                        <label class="radio-inline">
                                            <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="gender" value="female" >
                                            @lang('layout.Female') </label>
                                    </div>
                                </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-3" style="padding-right: 0px !important; padding-left: 0px !important;">
                            <div class="form-group">
                                <label class="control-label col-md-4">@lang('layout.Membership')</label>
                                <div class="col-md-8">
                                    <div>
                                        <label class="radio-inline">
                                            <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="membership" value="professiona" >
                                            @lang('layout.Professional') </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.BossName')</label>
                                <div class="col-md-9">
                                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch"  :options="member" :multiple="true" > </v-select>
                                    <input type="hidden" name="parent_id" :value="parent_id.length > 0 ? parent_id:null">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Date')</label>
                                <div class="col-md-9">
                                     <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <div class="col-md-9">
                                    {!! Form::file('photo', null, array('placeholder' => 'mm/dd/yy','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div> 
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Type')</label>
                                <div class="col-md-9">
                                <select name="type[]" multiple="multiple" class="list-style form-control" id="type">
                                    @foreach($type as $key=>$value)
                                        @if($value == __('type.Supervisor'))
                                            <option selected value="{{$key}}">{{$value}}</option>
                                        @else
                                            <option value="{{$key}}">{{$value}}</option>
                                        @endif
                                    @endforeach
                                </select>
                                </div>
                            </div>
                        </div>
                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Class')</label>
                                <div class="col-md-9">
                                     {{Form::select('class',$class,Null,['class' => 'form-control','placeholder' => __('layout.SelectClass')])}}
                                </div>
                                
                            </div>
                        </div>
                    </div> 
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsReceivable')</label>
                                <div class="col-md-9">
                                    <v-select label="name" v-model="selected_receivable" :options="receivable">
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsPayable')</label>
                                <div class="col-md-9">
                                      <v-select label="name" v-model="selected_payable" :options="payable">
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3 class="form-section">@lang('layout.Address')</h3>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address1')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address2')</label>
                                <div class="col-md-9">
                                    {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-7">
                                    {!! Form::text('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                                <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                    @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                </span>
                            </div>
                        </div>
                          <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                <div class="col-md-9">
                                    {!! Form::number('phone2', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                       
                    </div>
                    <!--/row-->
                    <div class="row">
                          <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        
						<div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9">
                                   <v-select label="name" v-model="selectedCountry" :options="countries">
                                    </v-select>
                                    <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                    <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                </div>
                            </div>
                        </div>

                        <h3>@lang('layout.JobTitle')</h3>
                        <div class="col-md-6">
                             <div class="form-group">
                                 <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                 <div class="col-md-9">
                                     <select role="button"    name="job_title_id[]" multiple="multiple"  class="list-style form-control" id="job_title">
                                         @foreach($jobTitle as $key=>$value)
                                          
                                              @if($value == 'Customer')
                                                 <option selected value="{{$key}}">{{$value}}</option>
                                             @else
                                                 <option value="{{$key}}">{{$value}}</option>
                                             @endif
                                            
                                         @endforeach
                                     </select>
                                 </div>
                             </div>
                         </div>
                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.PostCode')</label>
                                <div class="col-md-9">
                                     {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'class' => 'form-control')) !!} 
                                   
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->

                     <!--Begin Panels-->
                    <div class="tab-content">
                        <!-- GENERAL QUESTION TAB -->
                        <div class="tab-pane active" id="tab_1_1">
                            <div id="accordion1" class="panel-group">
                              
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <a class="accordion-toggle accordion-toggle-styled" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3"> @lang('layout.OtherInformations')</a>
                                        </h4>
                                    </div>
                                    <div id="accordion1_3" class="panel-collapse collapse">
                                        <div class="panel-body">

                                       <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseNumber')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('company_license_number', null, array('placeholder' =>__('layout.LicenseNumber'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseIssueDate')</label>
                                                    <div class="col-md-9">
                                                         <input type="text"  name="license_issue_date"  class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                             </div> 
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseExpireDate')</label>
                                                    <div class="col-md-9">
                                                          <input type="text"  name="license_expire_date"  class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                             </div>
                                        </div> 
                                       <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.PassportNumber')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('passport', null, array('placeholder' =>__('layout.PassportNumber'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.SSID')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('ss_id', null, array('placeholder' =>__('layout.SSID'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                         
                                        </div>  

                    
                                    <!--Begin Company Boss And Assistant Informations-->
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossName')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('boss_name', null, array('placeholder' =>__('layout.BossName'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossSSN')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('boss_ssn', null, array('placeholder' =>__('layout.BossSSN'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossPassport')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('boss_passport', null, array('placeholder' =>__('layout.BossPassport'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div>
                                        </div>                    

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantName')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('assistant_name', null, array('placeholder' =>__('layout.AssistantName'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantSSN')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('assistant_ssn', null, array('placeholder' =>__('layout.AssistantSSN'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantPassport')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('assistant_passport', null, array('placeholder' =>__('layout.AssistantPassport'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div>
                                        </div>
                                    <!--End Company Boss And Assistant Informations-->

                                        </div>
                                    </div>
                                </div>
                             
                            </div>
                        </div>
                        <!-- END GENERAL QUESTION TAB -->
                    </div>
            <!--END Panels-->
                </div>
                 
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
									<button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                     
                                    <a href="{{route('supervisor.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->

            </div>

        </div>
    </div>
@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>

    Vue.component('v-select', VueSelect.VueSelect);


    var Modal = Vue.component('cmodal',
    {
        template:'#cmodal-template',
        props: ['show'],
    });
 
  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var countries = {!!$countries!!};

  var vm = new Vue({
    el:'#app',
    data:{
        payable:payable,
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
		countries:countries,
        selectedCountry:{
            id:'Afghanistan',
            name:'Afghanistan',
            dial_code:'0093'
        },
		showcModal: false,
        errorMessage: '',
        fieldErrors: [],
        className: null,
        description: null,
        member:[],
        parent_id:[],
        selectedMember: null,
    },

    watch: {
        selectedMember: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
            x.push(e.id);
            });

            this.parent_id = x;
            // console.log('x value');
            // console.log(x);
        }
    },

    methods:{

        MemberSearch: _.debounce((search, loading) => {
            loading(true);
            var multitype = ['Owner', 'Supervisor'];
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    multitype: multitype
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vm.member = [];
                    vm.member = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

    //Function to add MemberCLass
    addClass(){
        axios.post("{{route('memberClass.store')}}",{
            name:this.className,
            description:this.description
        })
        .then(function(response){
            this.className = null;
            this.description = null;
            location.reload();
        });
        this.showcModal = false;
    },
	saveAndNew() {
		// this.$validator.validate()
		// .then(valid => {
			// if (valid) {

				var url = "{{route('supervisor.store')}}";
				form_id = 'member-form';
				var data = $('#' + form_id).serialize();
				toggleBlock(true);
				axios.post(url, data)
					.then(function (response) {
						toggleBlock(0);
						if (response.data.result == 1) {
							$('#' + form_id).trigger('reset');
							//$('#success-sound')[0].play();
							toastr.success('', response.data.message);
							location.reload();
							
						}
						else {
							var message = "{{__('message.Warning')}}";
							//$('#error-sound')[0].play();
							toastr.warning('', message);
						}
					})
					.catch(function (error) {
					  toggleBlock(0);
						console.log(error);
						var message = "{{__('message.Warning')}}";
						//$('#error-sound')[0].play();
						toastr.warning('', message);
					});

			// }
		// })
	}
        
    },
    mounted:function(){
        if(this.payable)
        {
            this.selected_payable=this.payable[0];

        }
         if(this.receivable)
        {
            this.selected_receivable=this.receivable[0];
        }
    }
  });



    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });

</script>

 
@endpush