@extends('layouts.app')
@section('content')
    @include('invoices.modal')
    @include('sales.modal')
    <!-- END PAGE HEADER-->
    <div id="ww" v-cloak>
        {{Form::open(['route' => 'refund.findRefund','method' => 'POST','class' => 'inline'])}}
        <button id="show-modalww" style="display: none" type="button" @click="editExampleww">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.InvoiceNumber') </label>
                            <input type="number" name="number" class="form-control">
                            <input type="hidden" name="type" value="Invoice">
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="storageRentlist"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.MemberClass') </label>
                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                      :options="classlist">
                            </v-select>
                            <input type="hidden" name="class_id"
                                   v-model.number="(!selectedClass)?null:selectedClass.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SaleArea') </label>
                            <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch"
                                      :options="saleArealist">
                            </v-select>
                            <input type="hidden" name="sale_area_id"
                                   v-model.number="(!selectedArea)?null:selectedArea.id">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="storageRentlist"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.MemberClass') </label>
                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                      :options="classlist">
                            </v-select>
                            <input type="hidden" name="class_id"
                                   v-model.number="(!selectedClass)?null:selectedClass.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SaleArea') </label>
                            <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch"
                                      :options="saleArealist">
                            </v-select>
                            <input type="hidden" name="sale_area_id"
                                   v-model.number="(!selectedArea)?null:selectedArea.id">
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.StoragesRentList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('StoragesRent-export')
                    <button type="submit" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    <button type="button" class="btn btn-success" id="print_pdf_all"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    @endpermission
                    @permission('StoragesRent-create')
                    <a href="{{route('storagesRent.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                <!-- <button class="btn btn-success" id="addNewRefundd">
                            <i class="icon-action-redo"></i> @lang('menu.Refund')
                        </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="invoice">
                    <thead>
                        <tr>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.CustomerName')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Discount')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


    <!-- for factor begin -->

    <div id="factor-obj">

    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>

    <!-- end for factor -->


@stop
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        var settingAll = {!! getUserSetting() !!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}")

        @endif


        function factorPrint(id) {


            var a = document.createElement('a');
            a.href = "{{url('invoiceFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {

            data_table = $('#invoice').DataTable({
                ajax: '{{route("storagesRent.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'ref_no', name: 'sales.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'account_name', name: 'account_name', orderable: false, searchable: false},
                    {data: 'date', name: 'sales.date'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false},
                    {data: 'username', name: 'username', orderable: false, searchable: false},
                    {data: 'description', name: 'sales.description'},
                    {data: 'username', name: 'users.name'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//              { data: 'measure_unit_id', name: 'quantity' },
//              { data: 'measure_unit', name: 'rate' },

                ]
            });
        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

        Vue.component('v-select', VueSelect.VueSelect)

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedArea: null,
            },
            methods: {
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },


                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get sale area
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })


        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedArea: null,
            },
            methods: {
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

        // Refund Modal

        new Vue({
            el: '#ww',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExampleww: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }

            },
        });
        $('#addNewRefundd').on('click', function (e) {
            $('#show-modalww').click();
            e.preventDefault();
        })
    </script>


@endpush
