@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<?php

?>
<div class="row">
  <div class="portlet light bordered ">
    <!-- BEGIN TAB PORTLET-->
    <div class="portlet light bordered sale">
      <div class="portlet-title">
        <div class="caption">
          <i class="icon-anchor font-green-sharp"></i>&nbsp;
          <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.StoragesRentEdit')</span>
        </div>
        <div class="actions">
        </div>
      </div>
      <div id="appInvoice" class="portlet-body">

        <div class="tabbable tabbable-tabdrop">

          <div>
            {{Form::model($invoice,['route' => ['storagesRent.update',$invoice->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
            {{ csrf_field() }}
            <div class="tab-content">

              <div class="tab-pane active" id="tab1">

                <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                  <!-- begin sale order modal -->

                  <!-- end sale order modal -->

                  <!-- BEGIN FORM-->


                  <div class="form-body">
                    <div class="row">
                      <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                        <!-- begin inputs -->
                        <div class="row">

                          <div v-show="showWhat('sale_area')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.SaleArea')</label>

                                <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                              </div>
                            </div>
                          </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-show="showWhat('member_class')=='yes'">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.MemberClass')</label>

                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                              </div>
                            </div>
                          </div>

                        </div>
                        <div class="row">
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Customer')</label>

                                <v-select label="name" @input="memberChange()" :options="customer" v-model="selected_customer"></v-select>
                                <input type="hidden" name="customer" :value="!selected_customer?null:selected_customer.id" required>
                              </div>
                            </div>
                          </div>


                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label col-md-12"><br></label>

                                <button type="button" class="btn blue btn-block" @click="showModal = true">@lang('layout.NewCustomer')</button>
                              </div>
                            </div>
                          </div>


                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                              </div>
                            </div>
                          </div>


                        </div>

                        <div class="row">


                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Currency')</label>


                                <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                <input type="hidden" name="currency" :value="selected_currency.code">

                              </div>
                            </div>
                          </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Rate')</label>

                                <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                              </div>
                            </div>
                          </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Discount')</label>

                                <div class="input-group">

                                  <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                  <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                    <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                  </span>
                                  <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                    <input type="hidden" name="discount_type" value="percent">
                                  </span>
                                  <input type="hidden" name="discountTotal" :value="discount">
                                  <input type="hidden" name="discount" :value="discountFiled">
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="row">

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                <textarea name="description" class="form-control" rows="1">{{$invoice->description}}</textarea>
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">

                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>

                                <input type="text" name="date" class="form-control date" value="{{$invoice->date}}" autocomplete="off">
                              </div>
                            </div>
                          </div>

                        </div>

                        <!-- end inputs -->
                      </div>
                      <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="seePrice==true">

                        <!-- begin total -->
                        <div class="dashboard-stat2 ">
                          <table class="dashboard-tabel" width="100%">
                            <tr>
                              <td>
                                <small>@lang('layout.Total') :</small>
                              </td>
                              <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </td>
                            </tr>

                            <tr>
                              <td>
                                <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
                              </td>
                              <td class="text-right">
                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </td>
                            </tr>

                            <tr>
                              <td>
                                <small>@lang('layout.Payment'):</small>
                              </td>
                              <td class="text-right">
                                <small class="font-green-sharp">
                                  <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                </small>
                              </td>
                            </tr>
 
                            <tr>
                              <td>
                                <small>@lang('layout.Sub-Total'):</small>
                              </td>
                              <td class="text-right">
                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </td>
                            </tr>
 
                          </table>

                        </div>

                        <!-- end total -->
                      </div>

                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">


                      <hr>
                      <!-- begin service -->
                      <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                          <tr>
                            <th class="text-center" style="min-width: 8px;"> # </th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>

                            <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                            <th></th>

                          </tr>
                        </thead>
                        <tbody>
                          <tr v-for="(service,index) in services">
                            <td>@{{index+1}}</td>
                            <td class="highlight">
                              <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">

                              </v-select>
                              <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                            </td>

                            <td>
                              <input class="form-control" type="number" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                            </td>
                            <td class="highlight">
                              <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                <option value="null">@lang('layout.Select')</option>
                                <span v-if="(service.item ==null)?false:true">
                                  <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                    @{{measure.measure_name}}
                                  </option>
                                </span>

                              </select>

                              <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                            </td>
                            <td>
                              <div class="input-group">
                                <input type="number" name="service_price[]" placeholder="@lang('layout.Price')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate,null, selected_currency.static_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                <span class="input-group-addon">
                                  @{{selected_currency.symbol}}
                                </span>
                              </div>

                            </td>
                            <td>
                              <div class="input-group">
                                <input type="number" class="form-control inner_input" :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" disabled>
                                <span class="input-group-addon">
                                  <b>@{{selected_currency.symbol}}</b>
                                </span>
                              </div>


                            </td>
                            <td>
                              <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                      <!-- end service -->
                      <hr>
                      <!-- begin payments -->
                      <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                          <tr>
                            <th class="text-center" style="min-width: 8px;"> # </th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                            <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                            <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                            <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                            <th></th>

                          </tr>
                        </thead>
                        <tbody>
                          <tr v-for="(payment,index) in payments">
                            <td>@{{index+1}}</td>
                            <td class="highlight">
                              <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">

                              </v-select>
                              <input type="hidden" v-if="payment.item !=null" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                            </td>

                            <td>

                              <span v-if="payment.item !=null">
                                @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                              </span>
                            </td>
                            <td>
                              <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                              <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                            </td>
                            <td>
                              <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                              <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                            </td>
                            <td>
                              <div class="input-group">
                                <input type="number" class="form-control" v-model.number="(payment.item==null)?null:payment.item.amount " placeholder="@lang('layout.PayAmount')" />

                                <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">

                                <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                              </div>
                            </td>
                            <td>
                              <div class="input-group">
                                <input type="number" class="form-control" :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" style="min-width: 100px" />
                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                              </div>
                            </td>
                            <td>
                              <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                          </tr>
                        </tbody>

                      </table>
                      <!-- end payments -->
                    </div>

                    <!--Begin Draiver-->

                    @if(getDriverInfo()=="true")
                    <br>
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                      <thead>
                        <tr>
                          <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                        </tr>
                      </thead>
                    </table>

                    <div class="row">
                      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <!-- begin inputs -->
                        <div class="row">
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.TransferCode')</label>
                              {{Form::text('transfer_code',$invoice->transferCode,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                            </div>
                          </div>

                          <div class="col-md-3">

                            <div class="col-md-12">
                              <label class="control-label">@lang('layout.Transporter_name')</label>
                              <input type="test" name="transporter_name" value="{{$invoice->driver}}" class="form-control">

                            </div>
                          </div>
                          <div class="col-md-3">

                            <div class="col-md-12">
                              <label class="control-label">@lang('layout.Transporter_phone')</label>
                              <input type="test" name="transporter_phone" value="{{$invoice->driverPhone}}" class="form-control">

                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                              {{Form::text('palce_of_weight',$invoice->PlaceOfWeight,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                            </div>
                          </div>



                        </div>
                        <div class="row">

                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.SourcePlace')</label>
                              {{Form::text('source_place',$invoice->sourcePlace,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.PlateNumber')</label>
                              <input type="text" name="plate_number" value="{{$invoice->plateNumber}}" placeholder="@lang('layout.PlateNumber')" class="form-control">

                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.WayBillNumber')</label>
                              <input type="text" name="way_bill_number" value="{{$invoice->wayBillNumber}}" placeholder="@lang('layout.WayBillNumber')" class="form-control">

                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.TotalWeight')</label>
                              <input type="text" name="total_weight" value="{{$invoice->totalWeight}}" placeholder="@lang('layout.TotalWeight')" class="form-control">
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                              <input type="text" name="empty_car_weight" value="{{$invoice->emptyCarWeight}}" placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.TotalBori')</label>
                              <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')" value="{{$invoice->bori}}" class="form-control">
                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="col-md-12">
                              <label class="control-label ">@lang('layout.Description')</label>
                              {{Form::textarea('transfer_description',$invoice->trDesription,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                            </div>
                          </div>
                        </div>
                      </div>

                    </div>
                    @endif
                    <!--End Draiver-->

                    @if(getInvoiceTotal() == 'true')
                    <!-- begin total -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                      <div class="dashboard-stat2 " v-show="seePrice== true">
                        <table class="dashboard-tabel" width="100%">
                          <tr>
                            <td>
                              <small>@lang('layout.Sub-Total'):</small>
                            </td>
                            <td class="text-right">
                              <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                            </td>
                            <td>
                              <small>@lang('layout.Payment'):</small>
                            </td>
                            <td class="text-right">
                              <small class="font-green-sharp">
                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </small>
                            </td>
                            <td>
                              <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
                            </td>
                            <td class="text-right">
                              <span class="text-right" data-counter="counterup" data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                            </td>
                            <td>
                              <small>@lang('layout.Total') :</small>
                            </td>
                            <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                            </td>
                          </tr>
                        </table>
                      </div>
                    </div>
                    <!-- end total -->
                    @endif


                  </div>
                  <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="isError1 ==false" v-if="!isError" @click="submitForm" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                  </div>
                  <cmodal :show='showModal' @close="showModal=false">

                  </cmodal>
                </div>


              </div>





              {!! Form::close() !!}

            </div>

          </div>


        </div>
        <p> &nbsp; </p>
        <p> &nbsp; </p>
      </div>
    </div>
    <!-- END TAB PORTLET-->
  </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
  Vue.component('v-select', VueSelect.VueSelect);

  Vue.component("modal", {
    template: "#modal-template",
    props: ['show'],

  });

  //begin new member
  Vue.component("cmodal", {
    template: '#cmodal-template',

    props: ['show'],
    data() {
      return {
        types: [],
        classes: [],
        receivables: [],
        payables: [],
        code: null,
        selectType: null,
        selectPay: null,
        selectedClass: null,
        selectReceive: null,
      }
    },
    created() {

      axios.get('{{route("customer.create")}}').then(
        response => {
          this.types = response.data.types;
          if (this.types) {
            for (var i = 0; i < this.types.length; i++) {
              if (this.types[i].type == "Customer") {
                this.selectType = this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
          this.classes = response.data.member_class;
          if (this.receivables.length > 0) {
            this.selectReceive = this.receivables[0];
          }
          if (this.payables.length > 0) {
            this.selectPay = this.payables[0];
          }


        }).catch(error => console.log(error));
    },
    methods: {
      onSubmit() {

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers: {
            'X-CSRF-TOKEN': "{{csrf_token()}}"
          },
          url: '{{route("customer.store")}}',
          method: 'post',
          data: {
            "name": datas[0]['value'],
            'email': datas[1]['value'],
            'phone': datas[2]['value'],
            'address1': datas[3]['value'],
            'type': this.selectType.id,
            'receivable': this.selectReceive.id,
            'payable': this.selectPay.id,
            'class': (this.selectedClass) ? this.selectedClass.id : null
          },
          dataType: 'json',

        }).done(function(response) {
          axios.get('{{route("invoice.create")}}').then(response => {

            v.customer = response.data.customer;
            document.getElementById("modalForm").reset();

          }).catch(error => console.log(error));

        }).fail(function(error) {
          console.log('error', error);
        });

      }
    }
  });

  // end new member


  var customer={!! $customer !!};
  var seePrice={!! $seePrice !!};
  var seeCost={!! $seeCost !!};
  var currency={!! $currency !!};
  var selectedCurrency = {!! $selectedCurrency !!};
  var banks = {!! $banks !!};
  var selectedBanks = {!! $selectedBanks !!};
  var all_services = {!! $all_services !!};
  var selectedService = {!! $selectedService !!};
  var selectedCustomer= {!! $selectedCustomer !!};
  var selectedItem= {!! $selectedItem !!};
  var invoice = {!! $invoice !!};
  var inventory_category = {!! $inventory_category !!};
  var memberClass = {!! $memberClass !!};
  var saleArea= {!! $saleArea !!};

  var v = new Vue({
    el: '#appInvoice',
    data: {
      showModal: false,
      invoice: invoice,
      customer: customer,
      all_customer: customer,
      seePrice: seePrice,
      seeCost: seeCost,
      selected_customer: selectedCustomer,
      selected_item: selectedItem,
      banks: banks,
      selected_banks: selectedBanks,
      all_services: all_services,
      selected_service: selectedService,
      currency: currency,
      selected_currency: selectedCurrency,
      rate: 0,
      discountFiled: 0,
      discountIsAmount: false,
      inventory_category: inventory_category,
      selected_index: 0,
      temp_items: [],
      totalAmountes: [],



      newCost: [
        null,
        null,
        null,
        null
      ],
      inventories: [

      ],
      services: [

      ],
      payments: [

      ],
      CusTypes: null,
      memberClass: memberClass,
      selected_class: null,
      saleArea: saleArea,
      selected_area: null,
      ref_no: "{{$invoice->ref_Number}}",
      msg: '',
      isError1: false
    },
    computed: {
      selectedRate() {
        this.rate = (this.selected_currency) ? this.selected_currency.rate : 0; 
      },
      discount() {
        if (this.discountIsAmount) {

          if (this.subtotal > 0 && this.discountFiled) {
            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
          } else {
            return 0;
          }
        } else {

          return this.discountFiled
        }

      },

      // calculate subtotal
      subtotal: function() {
        var sum = 0;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item && this.inventories[i].item != null) {

            var quantity = this.inventories[i]['item']['quantity'];
            var rate = this.inventories[i]['item']['rate'];
            var new_rate = this.inventories[i]['item']['new_rate'];
            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
            var measure_unit = this.inventories[i]['item']['measure_unit'];
            if (new_rate != rate && quantity > 0) {
              @if(systemConfig()[30] == 1)
              sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
              @else 
              sum += new_rate * quantity * this.selected_currency.rate;
              @endif

            } else {
              @if(systemConfig()[30] == 1)
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
              @endif
            }

          }

        }
        for (var i = 0; i < this.services.length; i++) {
          if (this.services[i].item && this.services[i].item != null) {

            var rate = this.services[i]['item']['rate'];
            var new_rate = this.services[i]['item']['new_rate'];
            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
            var measure_unit = this.services[i]['item']['measure_unit'];
            var quantity = this.services[i]['item']['quantity'];
            if (new_rate != rate && quantity > 0) {
              @if(systemConfig()[30] == 1)
              sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
              @else 
              sum += new_rate * quantity * this.selected_currency.rate;
              @endif
            } else {
              @if(systemConfig()[30] == 1)
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
              @endif
            }

          }
        }
        return sum;
      },

      // check payed amount
      payeds: function() {
        var sum = 0;
        for (var i = 0; i < this.payments.length; i++) {

          if (this.payments[i].item != null && this.payments[i].item) {
            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
              // 
              @if(systemConfig()[30] == 1)
              sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
              @endif 
            }
          }
        }
        return sum;
      },

      // check data validation
      isError: function() {
        var isError = false;
        //var flag=false;
        // for (var i = 0; i < this.inventories.length; i++)
        // {

        //    if (this.inventories[i].item)
        //    {
        //      flag=true;
        //      if(((this.inventories[i]['item']['rate'] <=0) ))
        //      {
        //        rate=this.inventories[i]['item']['rate'];
        //        new_rate=this.inventories[i]['item']['new_rate'];
        //        if(rate <=0 && new_rate <=0)
        //        {
        //             isError = true;
        //        }

        //      }
        //    } 
        // }
        if (this.selected_customer == undefined || this.selected_customer == null) {
          isError = true;
        }
        return isError;


      },
    },
    mounted: function() {


      // initialize the selected item

      for (var i = 0; i < this.selected_item.length; i++) {
        this.inventories.push({
          inventory: this.selected_item[i],
          item: this.selected_item[i],
          item_category: this.selected_item[i].item_category
        });
      }
      for (var m = 4; m > this.selected_item.length; m--) {
        this.inventories.push({
          inventory: null,
          item: null,
          item_category: null
        });
      }
      // end item

      // begin payment initialization

      for (var t = 0; t < this.selected_banks.length; t++) {
        var foundFlag = false;
        var tempBank = null;
        for (var y = 0; y < this.banks.length; y++) {
          if (this.selected_banks[t].id == this.banks[y].id) {
            foundFlag = true;
            tempBank = this.banks[y];
            tempBank.amount = this.selected_banks[t].balance;
            tempBank.rate = this.selected_banks[t].rate;
          }
        }
        if (foundFlag) {

          this.payments.push({
            item: tempBank,
            items: this.banks
          });
        }
      }
      for (var w = 1; w > this.selected_banks.length; w--) {
        this.payments.push({
          item: null,
          items: banks
        });
      }
      // end payment initialization

      // begin service

      for (var r = 0; r < this.selected_service.length; r++) {
        var flag = false;
        var tempService;
        for (var h = 0; h < this.all_services.length; h++) {
          if (this.all_services[h].id == this.selected_service[r].item_id) {
            flag = true;
            tempService = this.all_services[h];
            tempService.quantity = this.selected_service[r].qty;
            tempService.rate = this.selected_service[r].sales_price;
            tempService.new_rate = this.selected_service[r].sales_price;
          }
        }
        if (flag) {
          this.services.push({
            item: tempService,
            items: this.all_services
          })
        }
      }
      for (var w = 1; w > this.selected_service.length; w--) {
        this.services.push({
          item: null,
          items: all_services
        });
      }
      // end service

      if (this.invoice) {
        this.selected_class = _.find(this.memberClass, (c) => c.id == this.invoice.class_id);
        this.selected_area = _.find(this.saleArea, (s) => s.id == this.invoice.sale_area_id);
        this.discountFiled = this.invoice.discount;
        if (this.invoice.discount_type) {
          if (this.invoice.discount_type == 'percent') {
            this.discountIsAmount = false;
          } else {
            this.discountIsAmount = true;
          }
        }
      }
    },
    methods: {
      checkRefNo() {

        //console.log(vm.ref_no)

        var chack = 'false';
        var ref_no = v.ref_no;
        if (ref_no != null) {



          axios.get("{{route('callMethod.search')}}", {

              params: {
                ref_no: v.ref_no,
                method_name: 'Search_ref_no',
                table_name: 'sales'
              },
            })
            .then(function(response) {
              // console.log(response.data.result);
              if (response.data.result != null) {
                console.log(response.data.result);
                // v.temp_items=response.data;
                v.msg = "@lang('layout.DuplicateData')";
                v.isError1 = true;
              } else {
                v.msg = 'no';
                v.isError1 = false;

              }
            })
            .catch(function(error) {
              console.log(error);
            });

        }
      },

      memberClassChange() {
        this.customer = this.all_customer;
        if (this.selected_class) {
          this.customer = this.all_customer.filter((member) => {
            return this.selected_class.id == member.class_id;
          });

        }
      },

      // calculate item price based on measure change
      measureChange(index) {

        if (this.inventories[index].item != null) {
          var item = this.inventories[index].item;

          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
          result = Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate = result;

          // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

        }
      },

      // calculate item price based on measure change
      measureChangeservice(index) {

        if (this.services[index].item != null) {
          var item = this.services[index].item;
          @if(systemConfig()[30] == 1)
          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
          @else 
          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
          @endif
          result = Number.parseFloat(temp).toFixed(precision());

          this.services[index].item.new_rate = result;

          // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

        }
      },
      // detect member change and searh
      memberChange() {
        if (this.selected_customer) {
          // get member contract
        }
      },
      // end sale order change
      // set new price
      setNewRate(type = null, index = null) {
        if (type == 'inventory') {
          if (this.inventories[index].item) {
            @if(systemConfig()[30] == 1)
            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
            @else 
            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
            @endif
          }
        }
        if (type == 'service') {
          if (this.services[index].item) {
            console.log('service changed');
            @if(systemConfig()[30] == 1)
            this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
            @else 
            this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
            @endif
          }
        }
      },


      //ajax call to get items

      onItemSearch: _.debounce((search, loading) => {

        loading(true);
        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

        axios.get("{{route('callMethod.search')}}", {
            params: {
              member_id: v.member_id,
              method_name: 'itemesSearchSale',
              keyword: search,
              inventory_category_id: inventory_category_id,
            }
          })
          .then(function(response) {
            v.temp_items = [];
            if (response.data.length > 0) {
              v.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      }, getDebounceTime()),

      onItemload(index) {
        v.selected_index = index;
        v.temp_items = [];
        if (v.inventories[index].inventory != null) {
          // console.log('klk',v.inventories[index].inventory,v.inventories);
          var inventory_id = v.inventories[index].inventory.id;
          let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';

          axios.get("{{route('callMethod.search')}}", {
              params: {
                member_id: v.member_id,
                method_name: 'itemSearchSale',
                inventory_id: inventory_id,
                inventory_category_id: inventory_category_id,
              }
            })
            .then(function(response) {
              v.inventories[index].item = null;
              if (response.data.length > 0) {
                v.inventories[index].item = response.data[0];
              }
            })
            .catch(function(error) {
              console.log(error);
            })
        }
      },

      // end item search
      setIndex(e) {
        v.temp_items = [];
        this.selected_index = e;
      },
      itemCategoryChange(index) {
        v.setIndex(index);
        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
        axios.get("{{route('callMethod.search')}}", {
            params: {
              member_id: v.member_id,
              method_name: 'itemesSearchSale',
              inventory_category_id: inventory_category_id
            }
          })
          .then(function(response) {
            v.temp_items = [];
            if (response.data.length > 0) {
              v.temp_items = response.data;
            }
          })
          .catch(function(error) {
            console.log(error);
          });

      },

      // end item search

      // contract search



      // end contract search

      // generic function for adding item to list
      addNew(type = null, index) {
        this.temp_items = [];
        if (type != null) {
          if (type == 'inventory') {
            if (this.inventories[index + 1] == undefined) {
              this.temp_items = [];
              this.inventories.push({
                inventory: null,
                item: null,
                item_category: null
              });
            }
          }
          if (type == 'service') {
            if (this.services[index + 1] == undefined) {
              this.checkExistingService(index, '');
              this.services.push({
                items: this.all_services,
                item: null,
              });
            }
          }
          if (type == 'payment') {
            if (this.payments[index + 1] == undefined) {
              this.checkExistingPayment(index, '');
              this.payments.push({
                items: this.banks,
                item: null,
              });
            }
          }
        }

      },

      // in here you can check and decide to allow duplicate bank for payment or not
      checkExistingPayment(index = null, name = '') {
        var bank_temp = this.banks.slice();
        var bank_temp1 = [];
        for (var i = 0; i < this.payments.length; i++) {
          if (this.payments[i].item != null) {
            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
            if (fined != -1) {
              var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
            }
          }
        }
        this.payments[index].items = bank_temp.filter((item) => {
          return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
        });
        //this.payments[index].items =bank_temp; 


      },

      // in here you can check and decide to allow duplicate service or not
      checkExistingService(index = null, name = '') {
        var service_temp = this.all_services.slice();
        var service_temp1 = [];
        for (var i = 0; i < this.services.length; i++) {
          if (this.services[i].item != null) {
            var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
            if (fined != -1) {
              var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
            }
          }
        }
        this.services[index].items = service_temp.filter((item) => {
          return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
        });
        //this.payments[index].items =bank_temp; 


      },
      // delete item from list
      deleteItem(type = null, index) {
        if (type != null) {
          console.log(type);
          if (type == 'inventory') {
            this.inventories.splice(index, 1);
          }
          if (type == 'service') {
            this.services.splice(index, 1);
          }
          if (type == 'payment') {
            this.payments.splice(index, 1);
          }
        }

      },
      // submit the form
      submitForm() {

        if (this.isError == true) {
          alert('there is no item');
          return false;
        }
        swal({
          title: "@lang('layout.AreYouSure?')",
          buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
          text: "",
          icon: "info",
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete) {
            document.getElementById("sales-form").submit()

          } else {

          }
        });

      },
    },


  });
</script>



@endpush