@extends('layouts.factor-master')


@section('content')
<?php
$report = customeReport('invoice_detail');
$_item_name=in_array('item_name', $report);
$_symbol=in_array('symbol', $report);
$_purchase_date=in_array('purchase_date', $report);
$_sleep_day=in_array('sleep_day', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_purchase_rate=in_array('purchase_rate', $report);
$_income=in_array('income', $report);
$_total=in_array('total', $report);
?>

<table  class="main-table">
 @if($info && $info !=[])

 <tr>

  <td>
    <span>@lang('layout.Customer')</span>:&nbsp;&nbsp;
    <span>{{$info->member_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Account')</span>:&nbsp;&nbsp;
    <span>{{$info->account_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Amount')</span>:&nbsp;&nbsp;
    <span>{{$info->amount}}</span>
  </td>
</tr>
<tr>

 <td>
  <span>@lang('layout.Currency')</span>:&nbsp;&nbsp;
  <span>{{$info->currency}}</span>
</td>
<td>
  <span>@lang('layout.Rate')</span>:&nbsp;&nbsp;
  <span>{{$info->rate}}</span>
</td>
<td>
  <span>@lang('layout.Discount')</span>:&nbsp;&nbsp;
  <span>{{$info->discount}}</span>
</td>
<td>
  <span>@lang('layout.Type')</span>:&nbsp;&nbsp;
  <span>{{$info->type}}</span>
</td>

</tr>
@endif

</table>

 @if(getDriverInfo() == "true")          
           
                <h4>@lang('layout.DriverInfo')</h4>
                <table class="main-table">
                   
                    <tr>
                        <th class="hidden-xs">
                            @lang('layout.TransferCode')
                        </th>
                        <th class="hidden-xs">
                             @lang('layout.Transporter_name')  
                        </th>
                        <th>
                             @lang('layout.Transporter_phone')
                        </th> 
                        <th>
                             @lang('layout.PlaceOfWeight')
                        </th> 
                         <th>
                            @lang('layout.SourcePlace')
                        </th>
                    </tr>
                      <tr>
                        <td> {{$info->transferCode }}  </td>
                        <td> {{$info->driver}}  </td>
                        <td> {{$info->driverPhone}}  </td>
                        <td> {{$info->PlaceOfWeight}}  </td>
                        <td> {{$info->sourcePlace }}  </td>
                    </tr>
                 
                </table>
                <br>
                <table class="main-table">
                  <tr>
                       <th>
                            @lang('layout.PlateNumber') 
                        </th>
                        <th>
                            @lang('layout.WayBillNumber') 
                        </th>
                        <th>
                             @lang('layout.TotalWeight') 
                        </th>  
                        <th>
                             @lang('layout.EmptyCarWeight') 
                        </th>   
                        <th>
                             @lang('layout.TotalBori') 
                        </th>  
                        <th>
                             @lang('layout.Description') 
                        </th> 
                  </tr>
                  <tr>
                    <td> {{$info->plateNumber }}  </td>
                        <td> {{$info->wayBillNumber }}  </td>
                        <td> {{$info->totalWeight }}  </td>
                        <td> {{$info->emptyCarWeight }}  </td>
                        <td> {{$info->bori }}  </td>
                        <td> {{$info->trDesription }}  </td>
                  </tr>
                </table>
           
            @endif



<h3 class="table-caption" style="text-align: center;">@lang('layout.StorageRentsReport')</h3>
<table class="main-table">
<thead>
<tr class="bg">

 <td><div class="center"> @lang('layout.Record') </div></td>
  <th >@lang('layout.ItemName')</th>
 <th>@lang('layout.Unit')</th>
 <th>@lang('layout.Date')</th>
 <th>@lang('layout.Quantity')</th>
 <th>@lang('layout.Price')</th>
 <th>@lang('layout.Total')</th>
</tr>
</thead>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td  class="center">{{$record->name}}</td>
<td  class="center">{{$record->unit_measure}}</td>
<td class="center">{{$record->date}}</td>
<td  class="center">{{$record->qty}}</td>
<td  class="center">{{myRound($record->sales_price)}}</td>
<td  class="center">{{myRound($record->qty*$record->sales_price)}}</td>

</tr>
@endforeach  
</table>

<table>
  <tr>

  </tr>
</table>

         <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection
