@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('invoice');
$_date=in_array('date', $report);
$_invoice_number=in_array('invoice_number', $report);
$_customer=in_array('customer', $report);
$_account_name=in_array('account_name', $report);
$_amount=in_array('amount', $report);
$_unit=in_array('unit', $report);
$_rate=in_array('rate', $report);
$_discount_type=in_array('discount_type', $report);
$_discount=in_array('discount', $report);
$_description=in_array('description', $report);
?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.StorageRentsReport')</h3>
  <table class="main-table" cellpadding="5px">
  <thead>
  <tr class="bg">
   <td  class="center" ><div > @lang('layout.Record') </div></td>
   @if($_date)<td  class="center" ><div > @lang('layout.Date')</div></td>@endif
   @if($_description)<td  class="center"  ><div > @lang('layout.Description') </div></td>@endif
   @if($_customer)<td  class="center" ><div > @lang('layout.Customer')</div></td>@endif
   @if($_account_name)<td  class="center" ><div > @lang('layout.AccountName')</div></td>@endif
   @if($_amount)<td  class="center" ><div > @lang('layout.Amount')</div></td>@endif
   @if($_unit)<td  class="center" ><div > @lang('layout.Unit')</div></td>@endif
   @if($_rate)<td  class="center" ><div > @lang('layout.Rate')</div></td>@endif
   @if($_discount_type)<td  class="center" ><div > @lang('layout.DiscountType')</div></td>@endif
   @if($_discount)<td  class="center" ><div > @lang('layout.Discount')</div></td>@endif
   <td  class="center" ><div > @lang('layout.User')</div></td>

 </tr>
  </thead>
 <?php
 $count = 0;
 $total_home_currency=0;
  $currencies=[];
 ?>
 @foreach($data AS $record)
<tr>


<?php

   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>

 <td class="center">{{++$count}}</td>
  @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
 @if($_description)<td  class="center">{{$record->description}}</td>@endif
 @if($_customer)<td class="center">{{$record->Name}}</td>@endif
 @if($_account_name)<td class="center">{{$record->Account}}</td>@endif
 @if($_amount)<td class="center">{{myRound($record->Amount)}}</td>@endif
 @if($_unit)<td  class="center">{{$record->Unit}}</td>@endif
 @if($_rate)<td class="center">{{$record->rate}}</td>@endif
 @if($_discount_type)<td class="center">{{$record->discount_type}}</td>@endif
 @if($_discount)<td  class="center">{{$record->Discount}}</td>@endif
 <td  class="center">{{$record->user}}</td>
</tr>
  @endforeach  
</table>

<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>

         <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection