@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.StaticItemPriceShow')
            </div>
            <div class="tools">
            </div> 
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th >@lang('layout.Number')</th>
                        <th > @lang('layout.Category')</th>
                        <th>@lang('layout.ItemAmount')</th>
                        <th>@lang('layout.Date')</th>
                        <th >@lang('layout.Description')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>{{$staticItemPrice->id}}</td>
                        <td>{{$staticItemPrice->category}}</td>
                        <td>{{$staticItemPrice->item_amount}}</td>
                        <td>{{convertDate($staticItemPrice->date)}}</td>
                        <td>{{$staticItemPrice->description}}</td>
                    </tr>
                    </tbody>
                </table>
            </div>

          

        </div>
    </div>
    <div class="row">


        <div class="tabbable tabbable-tabdrop">
                    <div class="">

                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>&nbsp;
                                        <span class="caption-subject bold uppercase">@lang('layout.Items') </span>
                                    </div>
                                    <div class="tools"></div>
                                    {{-- <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="advance_pricing_details"/>
                                        <input type="hidden" name="id" value="{{$staticItemPrice->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="advance_pricing_details"/>
                                        <input type="hidden" name="id" value="{{$staticItemPrice->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div> --}}
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="staticItemPriceDetails">
                                        <thead>
                                        <tr>
                                          
                                            <th>@lang('layout.ItemNumber')</th>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Unit/M')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.NewSalePrice')</th>

                                       
    
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
        </div>

    </div>


@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#staticItemPriceDetails').DataTable({
                ajax: {
                    url: '{{route("staticItemPrice.show",$staticItemPrice->id)}}',
                },
                pageLength:'{{getPageRows()}}',

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'number', name: 'items.number'}, 
                    {data: 'name', name: 'items.name'},
                    {data: 'symbol', name: 'measure_units.symbol'},
                    {data: 'rate', name: 'items.rate'},
                    {data: 'currency', name: 'static_item_price_details.currency'},
                    {data: 'amount', name: 'static_item_price_details.amount'}

                ]
            });


        });
    </script>


@endpush
