@extends('layouts.app')
@section('content')
    @include('receives.modal')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'staticItemPrice'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                    </div>
                </div>
                  <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                            <select name="inventory_category_id"  class="form-control">
                                <option value="">@lang('layout.SelectInventoryCategory')</option>
                                @foreach($inventoryCategory as  $cat)
                                    <option value="{{$cat->id}}">{{$cat->name}}</option>
                                @endforeach
                            </select>
                        </div> 
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12" >
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example"  name="from_date" autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.StaticItemPriceList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('StaticItemPrice-export')
                        <span id="anchore-modal">
                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                            </a>
                        </span>
                    @endpermission
                    @permission('StaticItemPrice-delete')
                    <button id="delete-all-button" class="btn btn-danger">@lang('layout.Delete') <i class="fa fa-trash"></i></button>

                        <a href="{{route('staticItemPrice.remove')}}">
                            <button  class="btn btn-danger"  onclick="DeleteAll(this)">
                                <i class="fa fa-times"></i> @lang('layout.DeleteAll')
                            </button>
                        </a>
                    @endpermission
                    @permission('StaticItemPrice-create')
                        <a href="{{route('staticItemPrice.create')}}">
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="staticItemPrice">
                    <thead>
                    <tr>
                        <th><input type="checkbox" id="select_all_rows"></th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.ItemAmount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        @if (Session('receive_id'))
        printVoucher("{{Session('receive_id')}}")

        @endif

           //Delte All Records
            function DeleteAll(element){

                event.preventDefault();
          

                var e = $(element);
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    icon: "warning",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                                swal({
                                    title: "@lang('message.DeleteAllData')",
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    dangerMode: true,
                                }).then((willDelete) => {
                                    if (willDelete) {
                                        
                                        window.location.href = "{{route('staticItemPrice.remove')}}"
                                    } else {
                                        return false
                                    }
                                });
                    } else {
                        return false
                    }
                });


            }     


        function printVoucher(id) {

            var a = document.createElement('a');
            a.href = "{{url('printReceive')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#staticItemPrice').DataTable({
                ajax: '{{route("staticItemPrice.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
                    {data: 'id', name: 'static_item_prices.id'},
                    {data: 'category', name: 'inventory_categories.name'},
                    {data: 'item_amount', name: 'item_amount', orderable: false, searchable: false},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'description', name: 'static_item_prices.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]
            });

            // to check and uncheck
            $('#staticItemPrice #select_all_rows').on('click', function(){
                var isChecked = $('#staticItemPrice #select_all_rows').prop('checked');
                if(isChecked){
                    $('#staticItemPrice input[type="checkbox"]').prop('checked', true);
                }else{
                    $('#staticItemPrice input[type="checkbox"]').prop('checked', false);
                }
            });
             //When click on delete button
            $('#delete-all-button').on('click', function() {
                var checkedValues = [];
                $('#staticItemPrice input[type="checkbox"]:checked').each(function() {
                    checkedValues.push($(this).val());
                });
                if (checkedValues.length > 0) {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: "warning",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            swal({
                                title: "@lang('message.DeleteAllData')",
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                dangerMode: true,
                            }).then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        url: "{{ route('staticItemPrice.removeMultiple') }}",
                                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                                        method: 'POST',
                                        data: {
                                            checked_rows: checkedValues
                                        },
                                        success: function(response) {
                                            toggleBlock(0);
                                            toastr.success('', response.message);
                                            checkedValues = [];
                                            // location.reload();
                                            $('#staticItemPrice').DataTable().ajax.reload();
                                            console.log(response);
                                        },
                                        error: function(error) {
                                            console.error(error);
                                        }
                                    });
                                } else {
                                    return false
                                }
                            });
                        } else {
                            return false
                        }
                    });

                    
                }
                else {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                }
            });

        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });


        //  function printVoucher(id){
        //   document.getElementById("payframe").src ="{{url('printReceive')}}/"+id+"";


        // }


        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

                var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('staticItemPrice.report') !!}',
                excelRoute: '{!! route('staticItemPrice.report') !!}'
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

    </script>
@endpush
