@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('menu.StaticItemPrice')</h4>
  @if($from_date || $to_date || $inventory_category_name)
  <table class="main-table">
      <tr class="bg">
          @if($inventory_category_name)
              <td>
                  <span>@lang('layout.Category')</span>: {{$inventory_category_name}}
              </td>
          @endif 
          @if($from_date)
              <td>
                  <span>@lang('layout.FromDate')</span>:
                  <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
              </td>
          @endif
          @if($to_date)
              <td>
                  <span>@lang('layout.ToDate')</span>:
                  <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
              </td>
          @endif
      </tr>
  </table>
  <br>
  @endif

  

<?php
$count = 0;
?>
<table class="main-table">
  @foreach($data AS $record)
    <tr style="background-color: rgb(200, 205, 201)">
      <th>@lang('layout.Record') : {{++$count}}</th>
      <th>@lang('layout.Category') : {{$record->category}}</th>
      <th>@lang('layout.ItemAmount') : {{$record->item_amount}}</th>
      <th>@lang('layout.Date') : {{convertDate($record->date)}}</th>
      <th colspan="3">@lang('layout.Description') : {{$record->description}}</th>
    </tr>
  
  <?php
    $count2=0;
    $details = $record->details;
  ?>
  <tr style="background-color: rgb(221, 222, 222)">
    <td class="center"></td>
    <td class="center">@lang('layout.ItemNumber')</td>
    <td class="center">@lang('layout.ItemName')</td>
    <td class="center">@lang('layout.Unit/M')</td>
    <td class="center">@lang('layout.Rate')</td>
    <td class="center">@lang('layout.Currency')</td>
    <td class="center">@lang('layout.NewSalePrice')</td>

{{-- 
    "id" => 12
    "amount" => 1.0
    "currency" => "USD"
    "name" => "Mama Hamid Item"
    "rate" => 12.0
    "number" => "45458128"
    "symbol" => "ea" --}}

  </tr>
  @foreach($details AS $row)
  @if($row)
      <tr>
        <td class="center">{{++$count2}}</td>
        <td class="center">{{$row['number']}}</td>
        <td class="center">{{$row['name']}}</td>
        <td class="center">{{$row['symbol']}}</td>
        <td class="center">{{myRound($row['rate'])}}</td>
        <td class="center">{{$row['currency']}}</td>
        <td class="center">{{myRound($row['amount'])}}</td>
      </tr>
    @endif
    @endforeach
@endforeach
</table>


{{-- <table class="main-table">
  <tr style="background-color: rgb(243, 243, 214)">
   <td><div class="center"><b>@lang('layout.Qty1')</b></div></td>
   <td><div class="center">{{count($data)}}</div></td>
 </tr>
 </table>
 
 <table class="main-table">
 <tr style="background-color: rgb(243, 243, 214)">
   <td style="font-weight: bold" class="center"> @lang('layout.Record')</td>
   <td style="font-weight: bold" class="center"> @lang('layout.Item') </td>
   <td style="font-weight: bold" class="center"> @lang('layout.Total') </td>
   <td style="font-weight: bold" class="center"> @lang('layout.Average') </td>
   <td style="font-weight: bold" class="center"> @lang('layout.Currency') </td>
 </tr>
 <?php
 $count=0;
 foreach($total As $t)
 {
   ?>
   <tr style="background-color: rgb(243, 243, 214)">
     <td class="center">{{++$count}}</td>
     <td class="center">{{$t->name}}</td>
     <td class="center">{{myRound($t->amount)}}</td>
     <td class="center">{{myRound($t->amount/count($data))}}</td>
     <td class="center">{{$t->currency}}</td>
 
   </tr>
   <?php
 }
 ?>
 
 </table> --}}


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection