@extends('layouts.app')
@section('style')

<style>

</style>
@stop
@section('content')


<div class="row" id="app" v-cloak>

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.StaticItemPriceEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($staticItemPrice, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['staticItemPrice.update',$staticItemPrice->id]]) !!}
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('menu.InventoryCategory')</label>
                                     {{-- <select class="list-style form-control" @change="changeCategory(this)" name="inventory_category_id">
                                            <option value="">@lang('layout.Select')</option>
                                            <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                                     </select> --}}

                                     <v-select class="vue-select2"
                                              v-model="selected_inventory_category"
                                              label="name"
                                              :options="category"
                                              @input="changeCategory(selected_inventory_category)"
                                              >
                                      </v-select>
                                      <input type="hidden" name="inventory_category_id" :value="(!selected_inventory_category)?null:selected_inventory_category.id">

                                </div>
                            </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" name="date" class="form-control date" autocomplete="off" value="{{$staticItemPrice->date}}">
                              </div>
                          </div> 
                        </div> 
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                              
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', $staticItemPrice->description, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                              </div>
                          </div>
                      </div>    
                      </div>
                     <div class="row" style=" overflow-y: scroll;overflow-x: scroll; height:600px; margin-top:12px;">               
                      <table class="table table-striped table-bordered table-hover">
                          <thead style="position: sticky; top:0">
                              <tr style="background-color: rgb(174, 183, 178);">
                                  <th style="background-color: #6b716b;">@lang('layout.All')<br><input type="checkbox" name="selectedItem" class="icheck" @change="selectAll(this)" v-model="selectedAll"> </th>
                                  <th>@lang('layout.Code') </th>
                                  <th>@lang('layout.ItemName') </th>
                                  <th style="min-width: 120px !important;">@lang('layout.Measure') </th>
                                  <th> @lang('layout.Rate') </th>
                                  {{-- <th> @lang('layout.Currency') </th> --}}
                                  <th v-if="currency_list.length>0" v-for="cu in currency_list">
                                    @{{cu.code}}
                                  </th>
                              </tr>
                          </thead>
                          <tbody >
                              <tr v-for="(item,index) in items">
                                  <input type="hidden" name="item[]" v-model="item.id">
                                  <td class="highlight" style="background-color: rgb(174, 183, 178);">
                                      <input type="checkbox" @click="toggleCheck(index)" :checked="item.selected">
                                      <input type="hidden" name="selected_item[]" :value="item.selected">
                                      <input type="hidden" name="selected_item_rate[]" :value="item.old_item_rate">
                                  </td>
                                  <td class="highlight">@{{item.number}}</td>
                                  <td class="highlight"><a :href="url+'/'+item.id"> @{{item.name}} </a></td>
                                  <td> @{{item.measure}} </td>
                                  <td>@{{item.rate}}</td>
                                  {{-- <td> 
                                    <template v-if="item.currency">
                                      <td v-for="(c , cindex) in item.currency">
                                        <label for="">@{{(!item && !c)?null:c.code}}</label>
                                        <input type="number" class="form-control"  v-model="(!item && !c)?null:c.amount"
                                        :name="'currency_code['+item.id+']['+c.code+']'"> 
                                      </td>
                                  </template>
                                  </td> --}}
                                  <template v-if="item.currency">
                                    <td v-for="(c , cindex) in item.currency">
                                      {{-- <label for="">@{{(!item && !c)?null:c.code}}</label> --}}
                                      <input type="number" class="form-control"  v-model="(!item && !c)?null:c.amount"
                                      :name="'currency_code['+item.id+']['+c.code+']'"> 
                                    </td>
                                </template>
                              </tr>
                          </tbody>
                      </table>
                  </div>
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('staticItemPrice.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">

  var inventory_category = {!! $inventory_category !!}
  var selected_inventory_category = {!!$selected_inventory_category!!}
  var items = {!!$items!!}
  new Vue({
    el: '#app',
    data: {
      category:inventory_category,
      selected_inventory_category:selected_inventory_category,
      items:items,
      currency_list:[],
      selectedAll:false,
      url:"{{url('inventory')}}"

    },
    methods:
    {
      changeCategory(e)
      {
        console.log("AAAA",e)
        // var value=e.event.target.value;
        var value=e.id;
        for(var i=0;i<this.items.length;i++)
        { 
           this.items[i].selected=null;
           if(this.items[i].inventory_category_id==value)
           {
              this.items[i].selected=true;
           }
          //  console.log('kk', this.items[i].old_item_rate);
        }
      },
      toggleCheck(index)
      {
        this.items[index].selected=!this.items[index].selected;
      },
      changeType()
      {
        // console.log('test 22',this.selected_type);
      },
      amountChange()
      {
        console.log('ssss');
      },
      selectAll(e)
      {
        
         for(var i=0;i<this.items.length;i++)
        { 
           if(this.selectedAll==true)
           {
             this.items[i].selected=true;
           }
           else
           {
               this.items[i].selected=false;
           }
         
        }
      }
    },
    created:function()
    {
        console.log('test 22',this.record);
    },
    mounted() {
      for(var i=0;i<this.items.length;i++)
        { 
           this.currency_list = this.items[i].currency;
        }
        console.log('AAAA',this.currency_list)
    },

  });

</script>


@endpush