@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.BuildInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.BuildNumber')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-user"></i> @lang('layout.Employee')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-user"></i> @lang('layout.FatherName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-phone"></i> @lang('layout.Phone')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa"></i> @lang('layout.CarpetContract') @lang('layout.Number')
                        </th>
                        <th>
                            <i class="fa fa-shopping-cart"></i> @lang('layout.Quantity')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Cost')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.TotalExpense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.CostWithExpenses')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-user"></i> @lang('layout.CreatedBy')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class="hidden-xs"> {{ $build['number']}}  </td>
                        <td class="hidden-xs"> {{ $build['employee']}}  </td>
                        <td class="hidden-xs"> {{ $build['father_name'] }}  </td>
                        <td class="hidden-xs"> {{ $build['phone'] }}  </td>
                        <td class="hidden-xs"> {{ $build['contract_number'] }}  </td>
                        <td class="hidden-xs"> {{ $build['qty'] }}  </td>
                        <td class="hidden-xs"> {{ myRound($build['cost'])}}  </td>
                        <td class="hidden-xs"> {{ myRound($build['expense_amount'])}}  </td>
                        <td class="hidden-xs"> {{ myRound(($build['cost'])+$build['expense_amount'])}}  </td>
                        <td class="hidden-xs"> {{ $build['username'] }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.BuildDetails')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Expense')</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <!-- app -->

						<!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bortdered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Carpet')</span>
                                </div>
                                <div class="tools"> </div>
                                <div class="actions">
                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="simple_build_Detail_code"/>
                                    <input type="hidden" name="id" value="{{$build['id']}}"/>
                                    <button type="submit" class="btn btn-success"><i
                                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}

                                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="simple_build_Detail_code"/>
                                    <input type="hidden" name="id" value="{{$build['id']}}"/>
                                    <button type="submit" class="btn btn-success"><i
                                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="bundl">
                                        <thead>
                                        <tr>  
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Code')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.MeasureName')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Length')</th>
                                            @if(getOtherMeasure()=="true")
                                            <th> @lang('layout.Metraz')</th>
                                            @endif
                                            @if(getOtherMeasure2()=="true")
                                            <th> @lang('layout.OMeasureValue2')</th>
                                            @endif
                                            <th>@lang('layout.Wing')</th>
                                        </tr>
                                        </thead>
                                    </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
		
						
						<!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bortdered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.RemainQuantity')</span>
                                </div>
                                <div class="tools"> </div>
                                <!-- <div class="actions">
                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="simple_build_Details"/>
                                    <input type="hidden" name="id" value="{{$build['id']}}"/>
                                    <button type="submit" class="btn btn-success"><i
                                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}

                                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="simple_build_Details"/>
                                    <input type="hidden" name="id" value="{{$build['id']}}"/>
                                    <button type="submit" class="btn btn-success"><i
                                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                </div> -->
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="builds_in">
                                        <thead>
                                        <tr>  
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.BuildNumber')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.MeasureName')</th>
                                            <th>@lang('layout.Cost')</th>
                                            <!-- <th>Action</th> -->
                                        </tr>
                                        </thead>
                                    </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
		
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bortdered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.BuildOutItems')</span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                   
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="builds">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.ItemName')</th>
                                        <th>@lang('layout.BuildNumber')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Quantity')</th>
                                        <th>@lang('layout.MeasureName')</th>
                                        <th>@lang('layout.Total')</th>
                                        <!-- <th>Action</th> -->
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
		
						
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bortdered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
                            </div>
                            <div class="tools"></div>

                        </div>
                        <div class="portlet-body">
                            <table class="table table-striped table-bordered table-hover" id="expens">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Account')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <!-- <th>Action</th> -->
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endsection
        @push('scripts')
            <script>
                $(document).ready(function () {
                    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                    $('#builds').DataTable({
                        ajax: {
                            url: '{{route("simpleBuildCode.show",$build["id"])}}',
                            data: {type: 'buildDetail'}
                        },
                        pageLength: '{{getPageRows()}}',
                        responsive:'{{responsiveDataTable()}}',
                        pagingType:'{{paginationType()}}',
                        serverSide: true,
                        scrollCollapse: true,
                        paging: true,
                        columns: [
                            {data: 'Name', name: 'items.name'},
                            {data: 'Build_Number', name: 'builds.number'},
                            {data: 'Date', name: 'Date', orderable: false, searchable: false},
                            {data: 'Quantity', name: 'Quantity', orderable: false, searchable: false},
                            {data: 'Measure', name: 'Measure', orderable: false, searchable: false},
                            {data: 'TotalCost', name: 'TotalCost', orderable: false, searchable: false},

                        ]

                    });
					$('#builds_in').DataTable({
					   ajax:{
						url:'{{route("simpleBuildCode.show",$build["id"])}}',
							data:{type:'allBuildDetailIn'}
						  },
						serverSide: true,
                        responsive:'{{responsiveDataTable()}}',
                        pagingType:'{{paginationType()}}',
						scrollCollapse: true,
						paging: true,
						
						columns: [    
							{ data: 'name', name: 'name',orderable:false,searchable:false  },
							{ data: 'b_number', name: 'b_number',orderable:false,searchable:false  },
							{ data: 'date', name: 'date',orderable:false,searchable:false },
							{ data: 'qty', name: 'qty',orderable:false,searchable:false },
							{ data: 'Measure', name: 'Measure',orderable:false,searchable:false },
							{ data: 'cost', name: 'cost',orderable:false,searchable:false },
					
					]

					});

                    $('#bundl').DataTable({
                        ajax:{
                                url:'{{route("simpleBuildCode.show",$build["id"])}}',
                                data:{type:'bundl'}
                            },
                        serverSide: true,
                        scrollCollapse: true,
                        paging: true,
                        columns: [    
                            { data: 'Name', name: 'Name' ,orderable:false,searchable:false},
                            { data: 'code', name: 'builds.code' ,orderable:false,searchable:false},
                            { data: 'Date', name: 'Date',orderable:false,searchable:false },
                            { data: 'Quantity', name: 'Quantity',orderable:false,searchable:false },
                            { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                            { data: 'Cost', name: 'Cost',orderable:false,searchable:false },
                            { data: 'widths', name: 'widths',orderable:false,searchable:false },
                            { data: 'lengths', name: 'lengths',orderable:false,searchable:false },
                            @if(getOtherMeasure()=="true")
                            { data: 'other_measure', name: 'other_measure',orderable:false,searchable:false },
                            @endif
                            @if(getOtherMeasure2()=="true")
                            { data: 'other_measure2', name: 'other_measure2',orderable:false,searchable:false },
                            @endif
                            { data: 'khada', name: 'khada',orderable:false,searchable:false },
                        ]

                    });

                });

                $(document).ready(function () {
                    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                    $('#expens').DataTable({
                        ajax: {
                            url: '{{route("simpleBuildCode.show",$build["id"])}}',
                            data: {type: 'expenseDetail'}
                        },
                        pageLength: '{{getPageRows()}}',
                        responsive:'{{responsiveDataTable()}}',
                        pagingType:'{{paginationType()}}',
                        serverSide: true,
                        scrollCollapse: true,
                        paging: true,
                        columns: [
                            {data: 'account', name: 'account'},
                            {data: 'description', name: 'description'},
                            {data: 'amount', name: 'amount', orderable: true, searchable: false},

                        ]

                    });
                });


            </script>

    @endpush