@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
            @if($item_name)
                <td>
                    <span>@lang('layout.ItemName')</span>:
                    <BDO>{{$item_name}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.BuildNumber')</th>
            <th>@lang('layout.Quality')</th>
            <th>@lang('layout.Employee')</th>
            <th>@lang('layout.FatherName')</th>
            <th>@lang('layout.Phone')</th>
            <th>@lang('layout.Date')</th>
            @if(!$item_name)
            <th>@lang('layout.ItemName')</th>
            @endif
            <th>@lang('layout.Code')</th>
            <th>@lang('layout.GraphNumber')</th>
            <th>@lang('layout.TextMap')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Unit')</th>
            <th>@lang('layout.Rate') {{getHomeCurrency()[getCurrencyType()]}} </th>
            <th>@lang('layout.Expense')</th>
            <th>@lang('layout.UnitCost')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Metraz')</th>
            <th>@lang('layout.Width') 2</th>
            <th>@lang('layout.Length') 2</th>
            <th>@lang('layout.Metraz') 2</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $count = 0;
        $total_quantity = 0;
        $total_metraz = 0;
        $total_confirm_metraz = 0;
        $temp_arr = [];
        ?>
        @foreach($data AS $record)
        <?php
            $total_quantity += $record->Quantity;
            $total_metraz += (double)$record->other_measure;

            if (array_key_exists($record['carpet_contract_id'], $temp_arr)) {
                $temp_arr[$record['carpet_contract_id']] = $temp_arr[$record['carpet_contract_id']] + $record['metraz'];
            } else {
                $temp_arr[$record['carpet_contract_id']] = $record['metraz'];
                $total_confirm_metraz += (double)$record->metraz;
            }
        ?>
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->Build_Number}}</td>
            <td class="center">{{$record->quality}}</td>
            <td class="center">{{$record->employee}}</td>
            <td class="center">{{$record->father_name}}</td>
            <td class="center">{{$record->phone}}</td>
            <td class="center">{{convertDate($record->Date)}}</td>
            @if(!$item_name)
            <td class="center">{{$record->Name}}</td>
            @endif
            <td class="center">{{$record->code}}</td>
            <td class="center">{{$record->graph_number}}</td>
            <td class="center">{{$record->text_map}}</td>
            <td class="center">{{simpleRound($record->Quantity)}}</td>
            <td class="center">{{$record->Measure}}</td>
            <td class="center">{{myRound($record->Cost)}}
            <td class="center">{{myRound($record->expense_cost)}}</td>
            <td class="center">{{myRound($record->Cost + $record->expense_cost)}}</td>
            <td class="center">{{$record->widths}}</td>
            <td class="center">{{$record->lengths}}</td>
            <td class="center">{{simpleRound($record->other_measure)}} {{$record->other_measure_name}}</td>
            <td class="center">{{$record->width}}</td>
            <td class="center">{{$record->length}}</td>
            <td class="center">{{simpleRound($record->metraz)}}</td>
            <td class="center">{{$record->description}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
<table class="main-table">
        <tr class="bg">
            <th colspan="4">@lang('layout.Total')</th>
        </tr>
        <tr class="bg">
            <th>@lang('layout.TotalQuantity')</th>
            <th>@lang('layout.Metraz')</th>
            <th>@lang('layout.ConfirmMetraz')</th>
            <th>@lang('layout.ChangeMetraz')</th>
        </tr>
        <tr>
            <td class="center">{{$total_quantity}}</td>
            <td class="center">{{simpleRound($total_metraz)}}</td>
            <td class="center">{{simpleRound($total_confirm_metraz)}}</td>
            <td class="center">{{simpleRound(ABS($total_metraz - $total_confirm_metraz))}} @if(($total_metraz - $total_confirm_metraz) > 0) @lang('layout.Increase') @else @lang('layout.Decrease') @endif</td>
        </tr>
</table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection