@extends('layouts.app')


@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop

@section('content')
<!-- BEGIN CONTENT BODY -->

<!-- END PAGE BAR -->
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditBuild')</span>
                {{--<span class="caption-helper"></span>--}}
            </div>
            <div class="tools">
                <a href="" class="collapse"> </a>
                <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                <a href="" class="reload"> </a>
                <a href="" class="remove"> </a>
            </div>
        </div>
        <div class="portlet-body form" id="assembaly" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::model($build,['method' => 'PATCH','route' => ['simpleBuildCode.update',$build->id],'files'=> true, 'id'=>'build-form'])!!}
            <div class="form-body">
                <div class="row">
                    <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                    <div class="col-lg-10 col-md-10">
                        <!-- <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.ItemName')</label>
                                <v-select label="name" v-model="selected_assembly_item" :options="formula_items" @search="onItemSearch"></v-select>

                                <input type="hidden" name="item" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                                <span class="required">@{{ errors.first('item') }}</span>

                            </div>
                        </div> -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label ">@lang('layout.SiteName')</label>

                                <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site">

                                </v-select>
                                <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null" v-validate="'required'" data-vv-as="@lang('layout.SiteName')">
                                <span class="required">@{{ errors.first('site') }}</span>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.AssemblyCode') </label>
                                <input type="number" name="number" value="{{$build->number}}" class="form-control">
                                <span class="required">@{{ errors.first('number') }}</span>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label ">@lang('layout.Date')</label>
                                <date_picker name="date" value="{{$build->date}}" placeholder="@lang('layout.Date')"></date_picker>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-2">
                        <div class="dashboard-stat2">

                            <table class="dashboard-tabel table-bordered" width="100%">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.Total')</th>
                                        <th>@{{ format_number(Number.parseFloat(subtotal))}}</th>
                                    </tr>
                                    @if(getBuildExpense() == "true")
                                    <tr>
                                        <td>
                                        <small>@lang('layout.TotalExpense') :</small>
                                        </td>
                                        <td class="text-right">
                                        <span class="text-right" data-counter="counterup" data-value="7800"> @{{ expenseAmount }} {{getHomeCurrency()["code"]}}</span>
                                        <small class="font-green-sharp"></small>
                                        </td>
                                    </tr>
                                    @endif
                                </thead>
                                <!-- <tbody>
                                        <span>
                                            <tr>
                                                <td>1</td>
                                                <td>2</td>
                                                <td>2</td>
                                                
                                            </tr>
                                        </span>
                                    </tbody> -->
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">

                        <!-- <div class="col-md-4">

                            <div class="form-group">
                                <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="buildQty" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.QuantityToBuild')">

                                <span class="required">@{{ errors.first('build_qty') }}</span>

                            </div>
                        </div> -->

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Employee')</label>
                                <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedEmployee" label="name"
                                @keyup.native="changeEmployee()" @Click.native="changeEmployee()" :options="{{$employee}}">
                                </v-select>
                                <input type="hidden" name="employee_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id" />
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.CarpetContract')</label>
                                <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedCarpetContract"
                                @keyup.native="changeContract()" @Click.native="changeContract()" label="name" :options="carpetContract">
                                </v-select>
                                <input type="hidden" name="carpet_contract_id" v-model.number="(!selectedCarpetContract)?null:selectedCarpetContract.id" />
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Quality') </label>
                                <select class="form-control" name="quality" v-model="quality">
                                    <option :value="(!selectedCarpetContract)?null:selectedCarpetContract.price_level1" :selected="(!selectedCarpetContract)?null:selectedCarpetContract.price_level1 == quality" > @lang('layout.Quality') 1 (@{{ (!selectedCarpetContract)?null:selectedCarpetContract.price_level1 }})</option>
                                    <option :value="(!selectedCarpetContract)?null:selectedCarpetContract.price_level2" :selected="(!selectedCarpetContract)?null:selectedCarpetContract.price_level2 == quality" > @lang('layout.Quality') 2 (@{{ (!selectedCarpetContract)?null:selectedCarpetContract.price_level2 }})</option>
                                    <option :value="(!selectedCarpetContract)?null:selectedCarpetContract.price_level3" :selected="(!selectedCarpetContract)?null:selectedCarpetContract.price_level3 == quality" > @lang('layout.Quality') 3 (@{{ (!selectedCarpetContract)?null:selectedCarpetContract.price_level3 }})</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Price') </label>
                                <div class="input-group">
                                    <input readonly class="form-control" :value="(((!quality)?0:quality) * ((!selectedCarpetContract)?0:selectedCarpetContract.metraz))">
                                    <span class="input-group-addon">@{{(!selectedCarpetContract)?null:selectedCarpetContract.currency}}</span>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Description') </label>
                                <textarea name="description" class="form-control" rows="1">{{$build->description}}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class=" col-md-10">
                        <div class="col-md-4" v-show="showWhat('expire_date')=='yes'">
                            <div class="form-group">
                                <label class="control-label ">@lang('layout.ExpireDate')</label>
                                <input class="form-control date" name="expireDate" readonly="readonly" value="{{$build->expireDate}}" autocomplete="off" placeholder="@lang('layout.ExpireDate')">
                            </div>
                        </div>
                    </div>

                </div>

            </div>

            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;"> @lang('layout.Carpet') </li>
            <div v-if="selectedCarpetContract" class="" id="printarea" >
                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> # </th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.ItemName')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                            <th class="text-center" style="min-width: 80px;">@lang('layout.Width')</th>
                            <th class="text-center" style="min-width: 80px;">@lang('layout.Length')</th>
                            @if(getOtherMeasure()=="true")
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Metraz')</th>
                            @endif
                            @if(getOtherMeasure2()=="true")
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue2')</th>
                            @endif
                            @if(getShowWing()!="false")
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Wing')</th>
                            @endif
                            <th> </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(item,index) in formulaDataIn">
                            <td class="td_one"> <span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important; color: black;"> @{{index+1}} </span>
                            </td>

                            <td>
                                <v-select label="name" v-model="item.item" :options="newItems" @search="onItemSearch" @click.native="addBundl(index)" placeholder="@lang('layout.ItemName')"></v-select>
                                <input type="hidden" :name="'item_id['+index+']'" :value="(!item.item)?null:item.item.item_id">
                            </td>
                            <td>
                                <input :name="'code_in['+index+']'" type="text" @input="checkCode(index)" v-model="item.maxCode" v-on:click="addBundl(index)" class="form-control" placeholder="@lang('layout.Code')">
                                <span v-if="codeError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                            </td>
                            <td>
                                <input :name="'quty_in['+index+']'" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="item.qty" v-on:click="addBundl(index)">
                            </td>
                            <td>
                                <input :name="'widths['+index+']'" @input="changeMetraz(index)" v-model.number="item.widths" type="number" class="form-control" placeholder="@lang('layout.Width')">
                            </td>
                            <td>
                                <input :name="'lengths['+index+']'" @input="changeMetraz(index)" v-model.number="item.lengths" type="number" class="form-control" placeholder="@lang('layout.Length')">
                            </td>
                            @if(getOtherMeasure()=="true")
                            <td>
                                <input :name="'o_measure_value1['+index+']'" v-model.number="item.o_measure_value1" type="number" class="form-control" placeholder="@lang('layout.Metraz')">
                            </td>
                            @endif
                            @if(getOtherMeasure2()=="true")
                            <td>
                                <input :name="'o_measure_value2['+index+']'" v-model.number="item.o_measure_value2" type="number" class="form-control" placeholder="@lang('layout.OMeasureValue2')">
                            </td>
                            @endif
                            @if(getShowWing()!="false")
                            <td>
                                <input :name="'khada['+index+']'" v-model.number="item.khada" type="number" class="form-control" placeholder="@lang('layout.Wing')">
                            </td>
                            @endif
                            <td>
                                <span v-if="formulaDataIn.length != 1" v-on:click="deleteBundl(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>

                        </tr>
                    </tbody>
                </table>

            </div>

            <br />

            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;"> @lang('layout.FormulaItems') </li>
            <div v-if="assemlby_items.length >0 " class="">
                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> #</th>
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.Site')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                            <th style="width: 20px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(inventory,InventoryIndex) in assemlby_items" class="even">
                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important;color: black;"> @{{InventoryIndex+1}} </span>
                            </td>
                            <td class="td_one">
                                <v-select label="name" @keyup.native="onItemload(InventoryIndex)" @Click.native="onItemload(InventoryIndex)" v-model="inventory.inventory" :options="temp_items_out" ></v-select>
                                <input type="hidden" :name="'inventory_id['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(inventory.item==null)?null:inventory.item.id">
                                <span class="required">@{{ errors.first('inventory_id['+InventoryIndex+']') }}</span>

                            </td>
                            <td class="highlight">
                                <select v-model="(inventory.item==null)?null:inventory.item.site"
                                        class="form-control">
                                    <option value="null">@lang('layout.Select')</option>
                                    <span v-if="(inventory.item != null)">
                                    <option v-for="site in (inventory.item==null)?null:inventory.item.site_list"
                                            :value="site">
                                        @{{site.site_name}}
                                    </option> 
                                    </span>
                                </select>

                                <input type="hidden" :name="'inventory_site['+InventoryIndex+']'" :value="(inventory.item==null)?null:((inventory.item.site==null)?null:inventory.item.site.site_id)">
                            </td>
                            <td>
                                <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" class="form-control input_style" placeholder="Measure" required="required">

                                    <span v-if="inventory.item.measure_list !=null">
                                        <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                    </span>
                                </select>

                                <input type="hidden" :name="'inventory_measure['+InventoryIndex+']'" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                            </td>

                            <td>
                                <input readonly type="number" :value="(!inventory.item)?null:((inventory.item.site==null)?((inventory.item.on_hand * inventory.item.measure_unit / inventory.item.measure.measure_unit) + inventory.item.new_qty - inventory.item.qty):((inventory.item.site.OnHand * inventory.item.measure_unit / inventory.item.measure.measure_unit) + inventory.item.new_qty - inventory.item.qty))"> 
                            </td>
                            <td>
                                <input type="number" :name="'inventory_qty['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(inventory.item==null)?null:inventory.item.qty" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                <span class="required">@{{ errors.first('inventory_qty['+InventoryIndex+']') }}</span>
                            </td>

                            <td>
                                <span v-if="InventoryIndex > 0" v-on:click="deleteItem('inventory',InventoryIndex)">
                                    <i class="paddint-both glyphicon glyphicon-trash"></i>
                                </span>

                            </td>
                        </tr>
                        <tr style="background-color: #ffffff;">
                            <td></td>
                            <td>
                                <center>
                                    <span @click="addNew('inventory',100)" class="btn btn-success"><i class="fa fa-plus"></i></span>
                                </center>
                            </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>

                    </tbody>
                </table>

            </div>
            <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
            </button>

            <div class="form-section"></div>
            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;"> @lang('layout.RemainQuantity') </li>

            <div v-if="otherBuild.length >0 " class="">

                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> #</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                            <!-- <th class="text-center" style="min-width: 120px;"> @lang('layout.OnHand')</th> -->
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>

                            <!-- <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th> -->

                            <th style="width: 20px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(inventory,InventoryIndex) in otherBuild" class="even">
                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important;color: black;"> @{{InventoryIndex+1}} </span>
                            </td>
                            <td class="td_one">

                                <v-select label="name" @keyup.native="onOtherItemload(InventoryIndex), addNew('otherBuilds',InventoryIndex)" @Click.native="onOtherItemload(InventoryIndex), addNew('otherBuilds',InventoryIndex)" v-model="inventory.inventory" :options="temp_items_out" ></v-select>
                                <input type="hidden" name="other_build_id[]" :value="(inventory.item==null)?null:inventory.item.id">

                            </td>
                            <td>
                                <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" disabled class="form-control input_style" placeholder="Measure" required="required">

                                    <span v-if="inventory.item.measure_list !=null">
                                        <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                    </span>
                                </select>

                                <input type="hidden" name="other_build_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                            </td>
                            <!-- <td>
                                <input readonly type="number" :value="(!inventory.item)?null:getBuildOnHandWestage(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty_in,inventory.item.on_hand)">
                            </td> -->
                            <td>
                                <input name="other_build_qty[]" class="form-control inpu-number-fild" @input="changQuanty(InventoryIndex)" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty_in" placeholder="@lang('layout.Quantity')" />
                            </td>
                            <!-- <td>
                                <div class="input-group">
                                    <input type="number" class="form-control" placeholder="%" v-model.number="(!inventory.item)?null:inventory.item.cost" style="min-width: 100px" required name="other_build_cost[]" />
                                    <span class="input-group-addon">%</span>
                                </div>
                            </td> -->
                            <td>
                                <span v-on:click="deleteItem('otherBuild',InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                            </td>
                        </tr>

                    </tbody>
                </table>

            </div>

            <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
            </button>
            @if(getBuildExpense() == "true")
            <!-- build expense -->

            <div class="form-section"></div>
            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;"> @lang('layout.Expense') </li>

            <div v-if="expenses.length >0 " class="">

                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> #</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.ExpenseAccount')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                            <th style="width: 20px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(expense,index) in expenses" class="even">
                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important;color: black;"> @{{index+1}} </span>
                            </td>
                            <td class="td_one">

                                <v-select label="name" v-model="expense.expense_account" :options="expense_account" @click.native="addNew('expense',index)"></v-select>
                                <input type="hidden" name="expense_id[]" :value="(expense.expense_account==null)?null:expense.expense_account.id">

                            </td>
                            <td>
                                <input type="text" name="expense_description[]" v-model="expense.description" class="form-control" placeholder="@lang('layout.Description')">
                            </td>
                            <td>
                                <input type="number" name="expense_amount[]" v-model="expense.amount" class="form-control" placeholder="@lang('layout.Amount')">
                            </td>
                            <td>
                                <span v-on:click="deleteItem('expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                            </td>
                        </tr>

                    </tbody>
                </table>

            </div>
            @endif

            <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
            </button>

            <!-- end build expense -->

            <div class="row">
                <div class="col-md-offset-3 col-md-9">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                    <a href="{{route('simpleBuildCode.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                </div>
            </div>

        </div>
        {{Form::close()}}
    </div>

    <!-- END FORM-->
</div>
</div>

@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>



<script>
    Vue.component('v-select', VueSelect.VueSelect);

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    var site ={!! $site !!};
    var expense_account = {!! $expense_account !!};
    var maxCode = 0;

    var selectedSite = {!! $selectedSite !!};
    var build = {!! $build !!};
    var buildSelectedFormula = {!! $buildSelectedFormula !!};
    var buildSelectedItem = {!! $buildSelectedItem !!};
    var buildDetail = {!! $buildDetail !!};
    var otherBuildDetail = {!! $otherBuildDetail !!};
    var m_stocks_ins = {!! $m_stocks_ins !!};
    var carpetContract = {!! $carpetContract !!};
    var employee = {!! $employee !!};

    var sales = new Vue({
        el: '#assembaly',
        data: {
            site: site,
            selected_site: selectedSite,
            buildQty: null,
            selected_assembly_item: buildSelectedItem,
            disabled: false,
            number: 0,
            date: null,
            description: null,
            quality: null,
            carpetContract: [],
            wagonAll: [],
            employee: employee,
            selectedEmployee: null,
            carpetContract: carpetContract,
            selectedCarpetContract: null,
            assembly_item: [],
            temp_items: [],
            temp_items_out: [],
            formula_items: [],
            assemlby_items: [],
            otherBuild: [],
            otherBuildIndex: 0,
            inventoryIndex: 0,
            inventoryItem: null,
            expense_account: expense_account,
            expenses: [],
            codeError: false,
            newItems: [],
            formulaDataIn: [],
            maxCode: maxCode,
            m_stocks_ins: m_stocks_ins,
            buildSelectedFormula: buildSelectedFormula,
            build: build,
            buildDetail: buildDetail,
            otherBuildDetail: otherBuildDetail,
                
        },

        computed: {
            buildQ: function() {
                var min = null;
                if (this.formulaDataIn) {
                    var rows = this.formulaDataIn;

                    if (rows.length > 0) {
                        for (var i = 1; i < rows.length; i++) {
                            min += rows[i].qty;
                        }
                        min = min.toFixed(precision());
                    }

                }
                return min;
            },
            isError: function() {
                var isError = false;
                if ((this.selected_item == null && !this.selected_item) || this.selected_formula == null || this.selected_site == null || this.buildQty < 0) {
                    isError = true;
                }
                return isError;
            },
            subtotal: function() {
                var sum = 0;
                for (var i = 0; i < this.formulaDataIn.length; i++) {
                    if (this.formulaDataIn[i].qty && this.formulaDataIn[i].qty != null) {
                        var qty = this.formulaDataIn[i]['qty'];
                        sum += Number.parseFloat(qty);
                    }
                }
                this.buildQty = sum;
                return sum;
            },
            expenseAmount: function() {
                var temp = 0;
                if (this.expenses) {
                var rows = this.expenses;
                    var buildQty = this.buildQty;
                    var count = 1000;
                    for (var i = 0; i < count; i++) {
                    if (rows[i] && buildQty) {
                        if (rows[i] && rows[i].amount != null) {
                        var temp = (temp + (Number.parseFloat(rows[i].amount) * Number.parseFloat(buildQty)));
                        }
                    }else{
                        count = 0;
                    }
                    }
                }
                return temp.toFixed(precision());
            },
        },
        mounted: function() {
            if (this.build) {

                if (this.buildSelectedFormula) {
                    var rows = this.buildSelectedFormula[0];

                    this.temp_items_out = rows.formula;
                    for (var x = 0; x < rows.formula.length; x++) {
                        // rows.formula[x].new_quantity = buildDetail[x].quantity;
                        this.assemlby_items.push({
                            inventory: rows.formula[x], item: rows.formula[x]
                        });

                    }
                    // console.log('asss',this.assemlby_items)

                    for (var x = 0; x < rows.other_build.length; x++) {
                        // rows.other_build[x].new_quantity = buildDetail[x].quantity;
                        this.otherBuild.push({
                            inventory: rows.other_build[x], item: rows.other_build[x]
                        });
                    }

                    for (var m = 4; m > rows.other_build.length; m--) {
                        this.otherBuild.push({inventory: null, item: null});
                    }


                    for (var x = 0; x < rows.expense.length; x++) {
                        this.expenses.push({
                            expense_account: rows.expense[x].expense_account, info: rows.expense[x], description: rows.expense[x].description, amount: rows.expense[x].amount
                        });
                    }

                    for (var m = 4; m > rows.expense.length; m--) {

                        this.expenses.push({expense_account: null, info: null, description: null, amount: null});
                    }

                }

                this.selectedEmployee = _.find(this.employee, (k) => k.id == this.build.employee_id);
                this.selectedCarpetContract = _.find(this.carpetContract, (k) => k.id == this.build.carpet_contract_id);
                if (this.selectedCarpetContract) {
                    this.quality = this.selectedCarpetContract.per_price;
                    // console.log(111,this.quality);
                }

                if(this.m_stocks_ins)
                {
                    for(var i=0;i<this.m_stocks_ins.length;i++)
                    {
                        this.maxCode = this.m_stocks_ins[i].code;

                        this.formulaDataIn.push({item:this.m_stocks_ins[i], qty:this.m_stocks_ins[i].qut_in, 
                        maxCode:this.m_stocks_ins[i].code, 
                        m_stocks_in_id:this.m_stocks_ins[i].m_stocks_in_id, 
                        main_stock_id:this.m_stocks_ins[i].main_stock_id,
                        o_measure_value1:this.m_stocks_ins[i].other_measure, 
                        o_measure_value2:this.m_stocks_ins[i].other_measure2, 
                        lengths:this.m_stocks_ins[i].lengths, 
                        widths:this.m_stocks_ins[i].widths, 
                        khada:this.m_stocks_ins[i].khada});
                    }
                    // console.log('code',this.formulaDataIn);
                }
                
            }
        },
        methods: {

            getBuildOnHand(item_measure_unit = null, selected_measure_unit = null, qty = null, on_hand = null) {
                var result = 0;
                if (on_hand != null) {
                    if (qty) {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit) - (qty);
                    } else {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit);
                    }
                }
                return result.toFixed(precision());
            },
            getBuildOnHandWestage(item_measure_unit = null, selected_measure_unit = null, qty = null, on_hand = null) {
                var result = 0;
                if (on_hand != null) {
                    if (qty) {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit) + (qty);
                    } else {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit);
                    }
                }
                return result.toFixed(precision());
            },

            getItemCost(item_measure_unit = null, selected_measure_unit = null, cost = null) {
                var result = 0;
                if (cost != null) {
                    result = (cost * selected_measure_unit) / (item_measure_unit);

                }
                return result.toFixed(precision());
            },

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        regForm(e.target);
                    }
                });
            },

            // begin item search


            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemSearchNameRoll',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        sales.newItems = [];
                        if (response.data.length > 0) {
                            sales.newItems = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            // end item search
            // items serarch method

            onItemsSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'AssemblyItemsSearch',
                            'type': 'assembaly',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        sales.temp_items = [];
                        if (response.data.length > 0) {
                            sales.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            onItemload(index) {
                if (sales.assemlby_items[index].inventory != null) {
                    sales.assemlby_items[index].item = sales.assemlby_items[index].inventory;
                    // let contract_id = (sales.selectedEmployee != undefined) ? sales.selectedEmployee.id : '';
                    // let wagon_number = (sales.selectedCarpetContract != undefined) ? sales.selectedCarpetContract.name : '';

                    // axios.get("{{route('callMethod.search')}}", {
                    //     params: {
                    //         method_name: 'items_search_assebley',
                    //         inventory_id: inventory_id,
                    //         contract_id: contract_id,
                    //         wagon_number: wagon_number
                    //     }
                    // })
                    // .then(function(response) {
                    //     sales.assemlby_items[index].item = null;
                    //     if (response.data.length > 0) {
                    //         sales.assemlby_items[index].item = response.data[0];
                    //     }
                    // })
                    // .catch(function(error) {
                    //     console.log(error);
                    // })
                }
            },

            onItemloadContract() {
                if (sales.selectedCarpetContract != null && sales.selectedEmployee != null) {
                    let employee_id = sales.selectedEmployee.id;
                    let contract_id = sales.selectedCarpetContract.id;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'loadItemEmployeeContract',
                                employee_id: employee_id,
                                contract_id: contract_id
                            }
                        })
                        .then(function(response) {
                            
                            if (response.data.length > 0) {
                                sales.assemlby_items = [];
                                sales.temp_items_out = [];
                                sales.temp_items_out = response.data;
                                for (var r = 0; r < response.data.length; r++) {
                                    sales.assemlby_items.push({
                                        item: response.data[r], inventory: response.data[r]
                                    });
                                }
                                // for (var m = 1; m > response.data.length; m--) {
                                //     sales.assemlby_items.push({
                                //         item: null, inventory: null
                                //     });
                                // }
                                console.log(123,response.data,sales.assemlby_items);
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            onOtherItemload(index) {
                // v.selected_index=index;
                if (sales.otherBuild[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    sales.otherBuild[index].item = sales.otherBuild[index].inventory;
                    // var inventory_id = sales.otherBuild[index].inventory.id;

                    // axios.get("{{route('callMethod.search')}}", {
                    //         params: {
                    //             method_name: 'items_search_assebley',
                    //             inventory_id: inventory_id
                    //         }
                    //     })
                    //     .then(function(response) {
                    //         sales.otherBuild[index].item = null;

                    //         if (response.data.length > 0) {
                    //             sales.otherBuild[index].item = response.data[0];
                    //         }
                    //     })
                    //     .catch(function(error) {
                    //         console.log(error);
                    //     })
                }
            },
            changQuanty(index) {
                if (sales.otherBuild[index].item != null &&  sales.assemlby_items) {
                    // sales.otherBuild[index].item.qty = sales.otherBuild[index].item.on_hand - sales.otherBuild[index].item.new_qty
                    
                    var qty = 0;
                    if (sales.otherBuild[index].item.qty_in) {
                        qty = Number.parseFloat(sales.otherBuild[index].item.qty_in);
                    }
                    
                    for (var i = 0; i < sales.assemlby_items.length; i++) {
                        if (sales.otherBuild[index].item.id == sales.assemlby_items[i].item.id) {
                            var on_hand = 0;
                            if (sales.assemlby_items[i].item.new_qty) {
                                on_hand = Number.parseFloat(sales.assemlby_items[i].item.new_qty) + Number.parseFloat(sales.otherBuild[index].item.qty);
                            }
                            sales.assemlby_items[i].item.qty = Number.parseFloat(sales.assemlby_items[i].item.on_hand) + on_hand - qty;
                        }
                    }
                }
            }, 
            changeEmployee() {
                sales.selectedCarpetContract = null;
                sales.carpetContract = [];
                if (sales.selectedEmployee != null) {
                    // console.log('klk', sales.selectedEmployee.id);
                    var employee_id = sales.selectedEmployee.id;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'search_carpet_contract',
                                employee_id: employee_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                sales.carpetContract = response.data;
                                // console.log(32, sales.carpetContract);
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },


            setIndex() {
                this.temp_items = [];
            },

            changeContract() {
                sales.assemlby_items = [];
                sales.temp_items_out = [];
                sales.otherBuild = [];
                sales.assemlby_items.push({
                    item: null,
                    inventory: null
                });
                sales.otherBuild.push({
                    inventory: null,
                    item: null
                });
                sales.onItemloadContract();
            },

            changeMetraz(index) {
                if (this.formulaDataIn[index]) {
                    if (this.formulaDataIn[index].lengths != null && this.formulaDataIn[index].widths != null) {

                        var lengths = this.formulaDataIn[index].lengths;
                        var widths = this.formulaDataIn[index].widths;

                        this.formulaDataIn[index].o_measure_value1 = myRound(lengths * widths);
                        
                    }
                }
            },

            checkCode(index) {
                sales.codeError = false;
                if (this.formulaDataIn[index]) {
                    if (this.formulaDataIn[index].maxCode != null) {

                        var maxCode = this.formulaDataIn[index].maxCode;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    maxCode: maxCode,
                                    method_name: 'CheckCode'
                                },
                            })
                            .then(function(response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    // console.log('rewr',response.data.result);
                                    // sales.temp_items=response.data;
                                    sales.msg = "@lang('layout.DuplicateData')";
                                    sales.codeError = true;
                                } else {
                                    sales.msg = 'no';
                                    sales.codeError = false;

                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });

                    }
                }
            },

            addBundl(index) {
                if (this.formulaDataIn[index + 1] == undefined) {
                    this.formulaDataIn.push({
                        item: this.selected_item,
                        lengths: null,
                        widths: null,
                        o_measure_value1: null,
                        codeList: null,
                        maxCode: (Number.parseFloat(this.maxCode) + index),
                        qty: null
                    });
                }


            },
            // delete item from list
            deleteBundl(index) {
                this.formulaDataIn.splice(index, 1);

            },

            addNew(type = null, index) {

                if (type != null) {
                    if (type == 'inventory') {
                        this.temp_items = [];
                        if (this.assemlby_items[index + 1] == undefined) {
                            this.assemlby_items.push({
                                inventory: null,
                                item: null
                            });
                        }
                    }
                    if (type == 'otherBuilds') {
                        this.temp_items = [];
                        if (this.otherBuild[index + 1] == undefined) {
                            this.otherBuild.push({
                                inventory: null,
                                item: null
                            });
                        }
                    }
                    if (type == 'expense') {
                        if (this.expenses[index + 1] == undefined) {
                            this.expenses.push({
                                expense_account: null
                            });
                        }
                    }


                }

            },
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        this.assemlby_items.splice(index, 1);
                    }
                    if (type == 'otherBuild') {
                        this.otherBuild.splice(index, 1);
                    }
                    if (type == 'expense') {
                        this.expenses.splice(index, 1);
                    }

                }

            },

            addItems(type) {
                if (type != null) {
                    if (type == "otherBuilds") {
                        this.temp_items = [];
                        this.otherBuild.push({
                            inventory: null,
                            item: null
                        });
                    }
                    if (type == "inventory") {
                        this.temp_items = [];
                        this.assemlby_items.push({
                            inventory: null,
                            item: null
                        });
                    }
                    if (type == "expense") {
                        this.expenses.push({
                            expense_account: null
                        });
                    }
                }

            },
        }
    });
</script>


@endpush