@extends('layouts.factor-master')

@section('content')


<h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>

<table class="main-table">
    <thead>
        <tr>
            <th>
                <i class="fa  fa-bars"></i> @lang('layout.BuildNumber')
            </th>
            <th class="hidden-xs">
                <i class="fa fa-user"></i> @lang('layout.Employee')
            </th>
            <th class="hidden-xs">
                <i class="fa  fa-user"></i> @lang('layout.FatherName')
            </th>
            <th class="hidden-xs">
                <i class="fa  fa-phone"></i> @lang('layout.Phone')
            </th>
            <th class="hidden-xs">
                <i class="fa  fa"></i> @lang('layout.CarpetContract') @lang('layout.Number')
            </th>
            <th>
                <i class="fa fa-shopping-cart"></i> @lang('layout.Quantity')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.Cost')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.TotalExpense')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.CostWithExpenses')
            </th>
            <th class="hidden-xs">
                <i class="fa  fa-user"></i> @lang('layout.CreatedBy')
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="hidden-xs"> {{ $info['number']}} </td>
            <td class="hidden-xs"> {{ $info['employee']}} </td>
            <td class="hidden-xs"> {{ $info['father_name'] }} </td>
            <td class="hidden-xs"> {{ $info['phone'] }} </td>
            <td class="hidden-xs"> {{ $info['contract_number'] }} </td>
            <td class="hidden-xs"> {{ $info['qty'] }} </td>
            <td class="hidden-xs"> {{ myRound($info['cost'])}} </td>
            <td class="hidden-xs"> {{ myRound($info['expense_amount'])}} </td>
            <td class="hidden-xs"> {{ myRound(($info['cost'])+$info['expense_amount'])}} </td>
            <td class="hidden-xs"> {{ $info['username'] }} </td>
        </tr>
    </tbody>
</table>

<h3 class="table-caption" style="text-align: center;">@lang('layout.Carpet')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Code')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.MeasureName')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            @if(getOtherMeasure()=="true")
            <th> @lang('layout.Metraz')</th>
            @endif
            @if(getOtherMeasure2()=="true")
            <th> @lang('layout.OMeasureValue2')</th>
            @endif
            <th>@lang('layout.Wing')</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($buildIn AS $record)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->Name}}</td>
            <td class="center">{{$record->code}}</td>
            <td class="center">{{convertDate($record->Date)}}</td>
            <td class="center">{{myRound($record->Quantity)}}</td>
            <td class="center">{{$record->Measure}}</td>
            <td class="center">{{myRound($record->Cost)}}</td>
            <td class="center">{{$record->widths}}</td>
            <td class="center">{{$record->lengths}}</td>
            @if(getOtherMeasure()=="true")
            <td class="center">{{$record->other_measure}}</td>
            @endif
            @if(getOtherMeasure2()=="true")
            <td class="center">{{$record->other_measure2}}</td>
            @endif
            <td class="center">{{$record->khada}}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<h3 class="table-caption" style="text-align: center;">@lang('layout.RemainQuantity')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.BuildNumber')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.MeasureName')</th>
            <th>@lang('layout.Cost')</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($buildOtherBuil AS $record)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->name}}</td>
            <td class="center">{{$record->b_number}}</td>
            <td class="center">{{convertDate($record->date)}}</td>
            <td class="center">{{myRound($record->qty)}}</td>
            <td class="center">{{$record->Measure}}</td>
            <td class="center">{{myRound($record->cost)}}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<h3 class="table-caption" style="text-align: center;">@lang('layout.BuildOutItems')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.BuildNumber')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Cost')</th>
            <th>@lang('layout.MeasureName')</th>
            <th>@lang('layout.Total')</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($buildStockOut AS $record)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->Name}}</td>
            <td class="center">{{$record->Build_Number}}</td>
            <td class="center">{{convertDate($record->Date)}}</td>
            <td class="center">{{myRound($record->Quantity)}}</td>
            <td class="center">{{myRound($record->Cost)}}</td>
            <td class="center">{{$record->Measure}}</td>
            <td class="center">{{myRound($record->TotalCost)}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
<h4 class="center">@lang('layout.Expense')</h4>
<table class="main-table">
    <thead>

        <tr class="bg">
            <th class="center">@lang('layout.No')</th>
            <th class="center">@lang('layout.Account')</th>
            <th class="center">@lang('layout.Description')</th>
            <th class="center">@lang('layout.Amount')</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($expenseDetails as $ex)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$ex->account}}</td>
            <td class="center">{{$ex->description}}</td>
            <td class="center">{{$ex->amount}}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection