@extends('layouts.app')

@section('content')
@include('bills.modal')
@include('returns.modal')


<!-- END PAGE HEADER-->

<div id="ww" v-cloak>
    {{Form::open(['route' => 'return.findReturn','method' => 'POST','class' => 'inline'])}}
    <button id="show-modalww" style="display: none" type="button" @click="editExampleww">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div  class="col-md-12">
                        <label class="control-label ">@lang('layout.PurchaseNumber') </label>
                        <input type="number" name="number" class="form-control" >
                        <input type="hidden" name="type" value="Bill">
                    </div>
                </div>
            </div>
            
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="builllist"/>
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group"> 
                    <div  class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                        :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.member_id">
                </div> 
            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                            
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" name="to_date">
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>
    </div>
</modal>
{{Form::close()}}
</div>
<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="builllist"/>
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group">

                    <div  class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                        :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.member_id">
                </div>

            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example2" name="from_date">
                            
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example2" name="to_date">
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>
    </div>
</modal>
{{Form::close()}}
</div> 
<!-- BEGIN TAB PORTLET-->
<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.Enterbill') </span>
            </div>
            <div class="tools"></div>
            <div class=" pull-right">
                @permission('bill-export')

                <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>

                <button type="submit" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                @endpermission
                @permission('bill-export')
                <a href="{{route('bill.create')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>
                           <!--  <button class="btn btn-success" id="addNewReturnww">
                                <i class="fa fa-mail-reply"></i> @lang('menu.Return')
                            </button> -->
                            @endpermission    
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="bill_table">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.Vendor')</th>
                                    <th>@lang('layout.Account') </th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Actions') </th>
                                </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>


            <!-- END TAB PORTLET-->

            <!-- END CONTENT BODY -->


            @stop

            @push('scripts')

            <script>

  

    function factorPrint(id) {
    
  
    var a=document.createElement('a');
    a.href="{{url('billFactorPrint')}}/"+id;
    a.target="_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
        
        // $.ajax({
        //     // This PHP file will generate the PDF and save it to your server
        //     // $pdf->Output('path/to/pdf/file.pdf', 'F');
        //     url: "{{url('/')}}/invoiceFactorPrint/"+id,
        //     type: 'get',
        //     cache: false,

        // }).done(function () {

        //     var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

        //     $('#factor-obj').html(s);
       

        //     // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
        // })
        //     .fail(function () {
        //         console.log("error");
        //     });


    }



                $(document).ready(function () {


                    $('#bill_table').DataTable({
                        ajax: '{{route("bill.index")}}',
                        order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                        serverSide: true,
                        paging: true,
                        buttons: [{
                            extend: 'excel',
                            text: '',
                            key: {
                                key: 'x',
                                altkey: true
                            }
                        }],
                        columns: [

                        {data: 'number',     name: 'purchases.number'},
                        {data: 'vendor',     name: 'members.name'},
                        {data: 'account',    name: 'accoutn',orderable:false,searchable:false},
                        {data: 'date',       name: 'date'},
                        {data: 'amount',     name: 'amount',orderable:false,searchable:false}, 
                        {data: 'currency',   name: 'currency', orderable:false,searchable:false},
                        {data: 'rate',       name: 'rate', orderable:false,searchable:false},
                        {data: 'username',   name: 'username', orderable:false,searchable:false},
                        {data: 'description',name: 'purchases.description'},
                        {data: 'actions',    name: 'actions', orderable:false, searchable:false},

                        ]

                    });
                });
                Vue.component('v-select', VueSelect.VueSelect)

                var Modal=Vue.component('modal', {
                    template: '#modal-template',
                    methods: {
                        ok: function() {
                            this.$emit('ok')
                        }
                    }
                });
    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
            selectedMember:null,
            member:null,
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){

                this.member={!!$member!!}
                    //Your other code that launches the modal
                    this.showModal= true;
                    this.$nextTick(function(){
                        $(document).ready(function(){
                           $(".date").persianDatepicker(modelDate());
                       });
                    })
                }
            },
        });
    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    })


    new Vue({
        el: '#app2',
        data: {
            showModal: false,
            selectedMember:null,
            member:null,
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample2 : function(){
                this.member={!!$member!!}

                    //Your other code that launches the modal
                    this.showModal= true;
                    this.$nextTick(function(){
                        $(document).ready(function(){
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
    $('#excell_all').on('click',function(e){
        $('#show-modal2').click();
        e.preventDefault();
    })

// Return Modal Vue 
new Vue({
    el: '#ww',
    data: {
        showModal: false
    },
    methods:{
        ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExampleww : function(){

                    //Your other code that launches the modal
                    this.showModal= true;
                    this.$nextTick(function(){
                        $(document).ready(function(){
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
$('#addNewReturnww').on('click',function(e){
    $('#show-modalww').click();
    e.preventDefault();
})
</script>


@endpush






