@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
    @include("layouts.Cmodal")
    @include("bills.modal") 
    <div class="row"> 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ReturnBill') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'simpleReturnBill.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form'])}}
                {{ csrf_field() }}


                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>

                                            <div class="input-group">
                                                <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                                <input type="hidden" name="vendor" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_vendor?null:selected_vendor.id" required>
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                            <span class="required">@{{ errors.first('vendor') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.RefundNo')</label>

                                            <input type="number" name="number" v-validate="'required|numeric'"
                                                   data-vv-as="@lang('layout.RefundNo')" v-model="number"
                                                   class="form-control">
                                            <span class="required">@{{ errors.first('number') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                            <input type="text" name="ref_no" v-model="ref_no"
                                                   class="form-control" @input="checkRefNo()">
                                            <span v-if="isError1 ==true" class="input-has-error"
                                                  style="color: red">@{{msg}}</span>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' :  'col-lg-4 col-md-4'}} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>


                                            <v-select label="code" @input="selectedRate" :options="setRates"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Currency')"
                                                   :value="selected_currency.code">
                                            <span class="required">@{{ errors.first('currency') }}</span>

                                        </div>
                                    </div>
                                </div>

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' :  'col-lg-4 col-md-4'}} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Rate')"
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                            <span class="required">@{{ errors.first('currency_rate') }}</span>


                                        </div>
                                    </div>
                                </div>

                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ')</label>

                                                <input type="number" name="currency_rate_hq"
                                                       v-validate="'required'"
                                                       data-vv-as="@lang('layout.ExchangeRateHQ')"
                                                       v-model="!selected_currency?0:selected_currency.hq_rate"
                                                       class="form-control" :class="{'has-error':rate<=0}">
                                                <span class="required">@{{ errors.first('currency_rate') }}</span>


                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' :  'col-lg-4 col-md-4'}} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>

                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>

                                            <div class="input-group">

                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" readonly>
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                        <input type="hidden" class="input-group-addon"
                                                               name="discount_type" value="currency">
                                                    </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">%
                                                        <input type="hidden" name="discount_type" value="percent">
                                                    </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>

                                        </div>
                                    </div>
                                </div>


                                <!-- <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select class="form-control" name="category">
                                                <option value="refund">@lang('layout.Refund')</option>
                                                <option value="repair">@lang('layout.Repair')</option>
                                                <option value="minorUse">@lang('layout.MinorUse')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div> -->


                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">


                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal )-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                            <span class="text-right" data-counter="counterup"
                                                  data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                          <span class="text-right" data-counter="counterup"
                                                data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>

                            </div>

                            <!-- end total -->
                        </div>

                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 100px">@lang('layout.Category') </th>
                                @if(getSerailNumber() =="true")
                                    <th style="min-width: 80px">@lang('layout.SerialNum') </th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th v-show="showWhat('expire_date')=='yes'"
                                    style="min-width: 50px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1') </th>
                                <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2') </th>

                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 50px">@lang('layout.NewCost') </th>
                                <!-- <th v-show="showWhat('sale_discount')=='yes'"  style="min-width: 50px">@lang('layout.Discount') </th> -->
                                <th style="min-width: 50px">@lang('layout.Total') </th>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <th style="min-width: 100px">@lang('layout.TotalHQ') </th>
                                @endif
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                @if(getSerailNumber() =="true")
                                    <td>
                                        <input :value="(!item.item)?null:item.item.number"
                                               class="form-control input-style input-number"
                                               placeholder="@lang('layout.SerialNum')" disabled>
                                    </td>
                                @endif
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item"
                                              :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!item.item)?null:item.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>

                                    <input type="hidden" name="purchase_order_detail_id[]"
                                           :value="(!item.item)?null:item.item.purchase_order_detail_id">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                            <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                    :value="site">
                                              @{{site.site_name}}
                                            </option>
                                      </span>
                                    </select>
                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                    oninput = "autowidths(event)"
                                           name="inventory_description[]" class="form-control chan_length">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                    oninput = "autowidths(event)"
                                           class="form-control date chan_length">
                                </td>
                                <td>
                                    <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.Quantity')"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>

                                </td>

                                <td>
                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                          <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                  :value="measure">
                                            @{{measure.measure_name}}
                                          </option>
                                        </span>
                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               oninput = "autowidths(event)"
                                               ref="in" @input="setNewRate(index)" class="form-control chan_length">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}  
                                        </span>
                                    </div>

                                </td>
                                <!-- <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               oninput = "autowidths(event)"
                                               class="form-control chan_length">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                          @{{selected_currency.symbol}}
                                        </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                             %
                                            </span>
                                    </div>

                                </td> -->
                                <td>
                                    @{{
                                    (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, null, selected_currency.static_rate).result
                                    }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>

                                @if(auth()->user()->company()->first()->tag != 1)
                                    <td>
                                        @{{
                                        (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, null, selected_currency.static_rate).resultHQ
                                        }}
                                        <b>@{{selected_currency.symbol}}</b>
                                    </td>
                                @endif

                                <td>
                                    <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                @endif

                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
       
                                   <span v-if="payment.item !=null">
                                     @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                   </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">

                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate_hq[]"
                                           v-bind:value="payment.item.hq_rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate,selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control"
                                                   :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate,selected_currency.static_rate).resultHQ"
                                                   placeholder="@lang('layout.TotalHQ')" style="min-width: 100px"
                                                   required/>
                                            <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                        </div>
                                    </td>
                                @endif
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->
                    </div>
                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="isError1 ==false" v-if="!isError" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>

                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.use(VueInputAutowidth);

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    classes: [],
                    selectedClass: null,
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if (this.receivables.length > 0) {
                            this.selectReceive = this.receivables[0];
                        }
                        if (this.payables.length > 0) {
                            this.selectPay = this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var inventory_category = {!! $inventory_category !!};
        // group of company
        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        let mainHomeCurrency = {!! $mainHomeCurrency !!};
        var v = new Vue({
            el: '#app',
            data: {
                number: "{{$number}}",
                showModal: false,
                vendor: [],
                selected_vendor: null,  
                contract: [],
                banks: banks,
                selected_banks: null,
                currency: currency,
                selected_currency: {!! json_encode(getHomeCurrency()) !!},

                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,
                rate: 0,
                temp_items: [],
                totalAmountes: [],

                inventories: [
                    {item: null, item_category: null},
                ],
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],
                discountFiled: 0,
                discountIsAmount: false,
                ref_no: '',
                msg: '',
                isError1: false,
            },
            created: {
                // alert('ii',inventories);
            },
            computed: {
                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    static_rate: a.static_rate,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                static_rate: a.static_rate,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    static_rate: a.static_rate,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });

                    return rates;
                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal 
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif 
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate /  this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif 
                            } 
                        }

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                // 
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
            },
            methods:
                {

                    checkRefNo() {

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'return_backs'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.vendor = [];
                                v.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),
 
                    measureChange(index) { 
                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item; 
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision()); 
                            this.inventories[index].item.new_rate = result; 
                        }
                    }, 
                    // set new price
                    setNewRate(index) {
                        if (this.inventories[index].item) { 
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif 
                        } 
                    }, 
                    // begin item search
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchPurchase',
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = []; 
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }, getDebounceTime()),

                    //ajax call to get items
                    setIndex(e) {
                        // v.temp_items=[];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchPurchase',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }

                    },

                    // end item search

                    // contract search


                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: this.selected_iventory_category});
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("purchase-form").submit()

                            }
                            else {

                            }
                        });

                    },


                },
            created: function () {

            }

        });

    </script>


@endpush