@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('enter_bills');
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_bill_number=in_array('bill_number', $report);
$_vendor=in_array('vendor', $report);
$_account=in_array('account', $report);
$_amount=in_array('amount', $report);
$_rate=in_array('rate', $report);
$_currency=in_array('currency', $report);
$_discount_type=in_array('discount_type', $report);
$_discount=in_array('discount', $report);
?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.BillsReport')</h3>
  <table class="main-table">
  
 <thead>
     <tr class="bg">

   <td   class="center"  ><div > @lang('layout.Record') </div></td>
   @if($_bill_number)<td class="center"><div > @lang('layout.BillNumber') </div></td>@endif

   @if($_date)<td   class="center"  ><div > @lang('layout.Date')</div></td>@endif
  @if($_description)<td   class="center"  ><div > @lang('layout.Description')</div></td>@endif
   @if($_vendor)<td   class="center"  ><div > @lang('layout.Vendor')</div></td>@endif
   @if($_account)<td   class="center"  ><div > @lang('layout.Account')</div></td>@endif
   @if($_amount)<td   class="center"  ><div > @lang('layout.Amount')</div></td>@endif
   @if($_rate)<td   class="center"  ><div > @lang('layout.Rate')</div></td>@endif
   @if($_currency)<td   class="center"  ><div > @lang('layout.Currency')</div></td>@endif
   @if($_discount_type)<td   class="center"  ><div > @lang('layout.DiscountType')</div></td>@endif
   @if($_discount)<td   class="center"  ><div > @lang('layout.Discount')</div></td>@endif

 </tr>
 </thead>
 <?php
 $count = 0;
  $total_home_currency=0;
  $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>

  <?php

   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->amount;
  }
  ?>
  

 <td class="center">{{++$count}}</td>
 @if($_bill_number)<td class="center">{{$record->number}}</td>@endif

  @if($_date)<td  class="center">{{convertDate($record->date)}}</td>@endif
   @if($_description)<td  class="center">{{$record->description}}</td>@endif
 @if($_vendor)<td class="center">{{$record->vendor}}</td>@endif
 @if($_account)<td  class="center">{{$record->account}}</td>@endif
 @if($_amount)<td  class="center">{{round($record->amount,2)}}</td>@endif
 @if($_rate)<td  class="center">{{$record->rate}}</td>@endif
 @if($_currency)<td  class="center">{{$record->Currency}}</td>@endif
 @if($_discount_type)<td class="center">{{$record->discount_type}}</td>@endif

 @if($_discount)<td class="center">{{$record->discount}}</td>@endif
</tr>
  @endforeach   
</table>

<table>
  <tr>

  </tr>
</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection