@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
 
    </style>
@stop
@section('content')
    @include("layouts.Cmodal") 
    <div class="row"> 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ReturnSales') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'simpleRefundSale.store','method' => 'POST','class' => 'form-horizontal','id'=>'refund-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>

                                            <div class="input-group">
                                                <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_customer"></v-select>
                                                <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                            <span class="required">@{{ errors.first('customer') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.RefundNo')</label>

                                            <input type="number" name="number" v-validate="'required|numeric'"
                                                   data-vv-as="@lang('layout.RefundNo')" v-model="number"
                                                   class="form-control">
                                            <span class="required">@{{ errors.first('RefundNo') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                            <input type="text" name="ref_no" v-model="ref_no"
                                                   class="form-control" @input="checkRefNo()">
                                            <span v-if="isError1 ==true" class="input-has-error"
                                                  style="color: red">@{{msg}}</span>
                                        </div>
                                    </div>
                                </div>


                            </div>

                            <div class="row">

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>


                                            <v-select label="code" @input="selectedRate" :options="currency"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Currency')"
                                                   :value="selected_currency.code">
                                            <span class="required">@{{ errors.first('currency') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Rate')" name="rate" :readonly="averageRate"
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                            <span class="required">@{{ errors.first('currency_rate') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>

                                            <v-select label="name" :options="approperiateBank" v-model="selected_banks" @input="set_avg_rate_bank(selected_banks)" ></v-select>
                                            <input type="hidden" name="bank_account"
                                                   :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>

                                            <div class="input-group">

                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" readonly>
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                    <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                    </span>
                                                                    <span v-else @click="discountIsAmount = !discountIsAmount"
                                                                        class="input-group-addon">%
                                                    <input type="hidden" name="discount_type" value="percent">
                                                    </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select class="form-control" name="category">
                                                <option value="refund">@lang('layout.Refund')</option>
                                                <option value="repair">@lang('layout.Repair')</option>
                                                <option value="minorUse">@lang('layout.MinorUse')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>

                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end inputs -->

                            @if(TabIndexInItemName() =="true")
                            <!--Begin search Item-->
                            <div class="row col-lg-12 col-md-12 col-sm-12 col-xs-12" style="background-color: #eceef1">
                                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    {{-- <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.SerialNum')</label>
                                                <input type="text" v-model="selected_inventory1" ref="barcode_search1" class="form-control" @input="callOnItemloadGeneral(), editKey = false" >
                                                <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span>
                                        </div>
                                    </div> --}}
                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12"> 
                                        <label class="control-label">@lang('layout.SerialNum')</label>
                                        <div class="input-group">
                                            <input type="text" v-model="selected_inventory1"  ref="barcode_search1" class="form-control" @input="(!check_with_key)?callOnItemloadGeneral():''" >
                                            {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="check_with_key" title="{{ __('layout.SearchItemsWithSpecificKey') }}">
                                                <span></span>
                                            </span>
                                        </div>
                                        <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span>
                                    </div> 
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="showWhat('sale_category')=='yes'">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.Category')</label>
                                                <v-select label="name" v-model="selected_iventory_category" :options="inventory_category"></v-select>
                                        </div>
                                    </div>
                                
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" >
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.Site')</label>
                                                <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites"></v-select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                    <div class="form-group">
                                            <label class="control-label">@lang('layout.Quantity')</label>
                                            <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                    <div class="form-group">
                                        <label class="control-label col-md-12" style="color: white;">.</label>
                                        <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                    </div>
                                </div>
                            </div>
                            <!--END search Item-->
                            @endif
                            <!-------------------------------------------------------
                                    -----------------------------------------------------
                                    ----------------------------------------------------->

                            <!-- end inputs -->

                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">

                                <table class="dashboard-tabel" width="100%">

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal)-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                                    data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>

                            </div>

                            <!-- end total -->
                        </div>

                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                @if(getSerailNumber() =="true")
                                    <th style="min-width: 80px">@lang('layout.SerialNum') </th>
                                @endif
                                <th style="min-width: 130px">@lang('layout.ItemName')</th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                @if(searchByCodeLocation()=="true")
                                <th style="min-width: 100px;">@lang('layout.Location')</th>
                                @endif
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th v-show="showWhat('expire_date')=='yes'"
                                    style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1') </th>
                                <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2') </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                <!-- <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th> -->
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                @if(getSerailNumber() =="true")
                                    <td>
                                        <input :value="(!item.item)?null:item.item.number"
                                               class="form-control input-style input-number"
                                               placeholder="@lang('layout.SerialNum')" disabled>
                                    </td>
                                @endif
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item"
                                              :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!item.item)?null:item.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>
                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                @if(searchByCodeLocation()=="true")
                                <td>
                                    <input type="text" name="inventory_location[]" class="form-control" placeholder="@lang('layout.Location')">
                                </td>
                                @endif
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input class="purchase_description" type="text"
                                           placeholder="@lang('layout.Description')" name="inventory_description[]"
                                           class="form-control">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                           class="date form-control">
                                </td>
                                <td>


                                    <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.Quantity')"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                                </td>

                                <td>
                                <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="in" @input="setNewRate(index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <!-- <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               class="form-control">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                      </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                      </span>
                                    </div>

                                </td> -->

                                <td>
                                    <div>
                                        <div class="input-group">
                                            <input type="number" class="form-control inner_input"
                                                   :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, null, selected_currency.static_rate).result"
                                                   placeholder="@lang('layout.Total')" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>

                    </div>


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="isError1 ==false" v-if="!isError" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>

                    <a href="{{route('refund.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        document.onkeydown = function (e) {   
        // save invoice by shif && enter
         if (e.ctrlKey && e.which == 13) {
         v.callOnItemloadGeneral();
        }
        
    }


        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,

                }
            },
            created() { 
                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: { 
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var inventory_category = {!! $inventory_category !!};
        var inventory_sites = {!!$inventory_sites!!};
        var v = new Vue({
            el: '#app',
            data: {
                number: "{{$number}}",
                showModal: false,
                averageRate: false,
                customer: [],
                selected_customer: null,
                contract: [],
                selected_contract: null,
                banks: banks,
                selected_banks: null,
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                rate: 0,
                temp_items: [],
                totalAmountes: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,

                inventories: [
                    {item: null, item_category: null}
                ],
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],

                discountFiled: 0,
                discountIsAmount: false,
                ref_no: '',
                msg: '',
                isError1: false,
                check_with_key: false,
                selected_inventory1: null,
                selected_inventory: null,
                item_not_found: false,
                inventory_sites: inventory_sites,
                selected_iventory_site: null,
                selected_quantity: null,
                counter_check: 0,
                counter_check1: 1,
                counter_check2: -1,
                number_Error: false,
                disabled: false,
            },

            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },


                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity *  this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }


                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_customer == undefined || this.selected_customer == null || !this.selected_banks || this.selected_banks == null || flag == false) {
                        isError = true;
                    }

                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            methods:
                {

                    checkNo() {
                var chack = 'false';
                var number = v.number;
                if (number != null && !v.selectedOilPart) {
                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                number: v.number,
                                method_name: 'Search_number',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                // console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.number_msg = "@lang('layout.DuplicateData')";
                                v.number_Error = true;
                            } else {
                                v.number_msg = 'no';
                                v.number_Error = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                } else {
                    v.number_msg = 'no';
                    v.number_Error = false;
                }
            },



                    showInfo(index) {
                    if (v.inventories[index].item != null) {
                        v.showInfoModal = true;
                        v.brand = v.inventories[index]['item']['brand'];
                        v.location = v.inventories[index]['item']['location'];
                        v.SNumber = v.inventories[index]['item']['number'];
                        v.AdvancePrice = v.inventories[index]['item']['advance_price'];
                        v.on_hand = v.inventories[index]['item']['on_hand'];
                        v.measure_name = v.inventories[index]['item']['measure']['measure_name'];
                        v.last_item_sale = v.inventories[index]['item']['last_item_sale'];
                        v.width = v.inventories[index]['item']['width'];
                        v.length = v.inventories[index]['item']['length'];
                        v.height = v.inventories[index]['item']['height'];
                        // console.log('ffff',v.inventories[index]);
                        // if(v.seeCost==true){
                        @if(systemConfig()[30] == 1)
                        v.cost = (v.inventories[index]['item']['LasCost'] * v.selected_currency.static_rate / v.selected_currency.rate);
                        @else 
                        v.cost = (v.inventories[index]['item']['LasCost'] * v.selected_currency.rate);
                        @endif
                        // }
                    }
                },
                    callOnItemloadGeneral() {
                    v.editKey = false;
                    if (v.counter_check == 0) {
                        v.counter_check = 1;
                        @if(getBarcodeType()=="true")
                        setTimeout((function () {
                            v.counter_check1 = v.selected_inventory1;
                            v.call2();
                            // console.log(12);
                        }), 1e1)
                        @else
                        setTimeout((function () {
                            v.counter_check1 = v.selected_inventory1;
                            v.call2();
                            // console.log(12);
                        }), 2e2)
                        @endif
                        }
                    },

                        call2() {
                        @if(getBarcodeType()=="true")
                        setTimeout((function () {
                            v.counter_check2 = v.selected_inventory1;
                            v.onItemloadGeneral();
                            // console.log(13);
                        }), 1e1)
                        @else
                        setTimeout((function () {
                            v.counter_check2 = v.selected_inventory1;
                            v.onItemloadGeneral();
                            // console.log(13);
                        }), 2e2)
                        @endif
                    },


                    onItemloadGeneral(id = null) {
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.selected_inventory1;
                    v.call2();
                }else{
                    if (v.selected_inventory != undefined || id || v.selected_inventory1) {
                        // console.log(123, v.selected_inventory1);
                        var inventory_id = id;
                        if (v.selected_inventory != undefined) {
                            inventory_id = v.selected_inventory.id;
                        }

                        let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                        let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                        let number = v.selected_inventory1;

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    // inventory_id: inventory_id,
                                    // inventory_category_id: inventory_category_id,
                                    // inventory_brand_id: inventory_brand_id,
                                    // inventory_site_id: inventory_site_id,
                                    // price_level_id: price_level_id,
                                    number: number,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    var che = null;
                                    var checkD = true;

                                    @if(NotDuplicateItem() =="true")
                                    if (v.inventories != null && response.data[0].id) {
                                        for (var i = 0; i < v.inventories.length; i++) {
                                            if (v.inventories[i].item && v.inventories[i].item != null) {
                                                if (v.inventories[i].item.id == response.data[0].id) {
                                                    v.inventories[i].item.quantity = ( Number.parseFloat(v.inventories[i].item.quantity) + 1);
                                                    checkD = false;
                                                }
                                            }
                                        }
                                    }
                                    @endif

                                    if (checkD) {
                                        for (var i = 0; i < v.inventories.length; i++) {
                                            if (v.inventories[i].item && v.inventories[i].item != null) {
                                                che = 'ok';
                                            } else {
                                                v.inventories.splice(i, 1);
                                            }
                                        }
                                        if(!che){
                                            v.inventories = [];
                                        }
                                        console.log(123, response.data[0]);
                                        if (inventory_site_id) {
                                            for (var i = 0; i < response.data[0].site_list.length; i++) {
                                                if (response.data[0].site_list[i].site_id == inventory_site_id) {
                                                    response.data[0].site = response.data[0].site_list[i];
                                                }
                                            }
                                        }
                                        response.data[0].quantity = (v.selected_quantity > 0)?v.selected_quantity:1;

                                        v.inventories.unshift({
                                            inventory: response.data[0],
                                            item: response.data[0],
                                            location: null,
                                            selected_taxation: null,
                                            tax: response.data[0].row_tax_stat,
                                            sub_total: response.data[0].sub_total_stat,
                                            item_category: response.data[0].item_category,
                                            item_brand: response.data[0].inventory_brand,
                                            price_level:null
                                        });

                                        v.temp_items = [];
                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;

                                        @if(getShwoPriceLevel()=="general_percent")
                                        setTimeout((function () {
                                            v.change_sale_rate_by_price_level_general();
                                        }), 400);
                                        @endif

                                        // const inp = v.$refs.barcode_search.$refs.search;
                                        // console.log(v.$refs.barcode_search.$refs.search.value);
                                        // v.$refs.barcode_search.$refs.search.focus();
                                        // v.$refs.barcode_search.$refs.search = null;
                                        v.$refs.barcode_search1.focus();
                                        
                                    }else{
                                        setTimeout((function () {
                                            v.selected_inventory = null;
                                            v.selected_inventory1 = null;
                                            v.counter_check = 0;
                                            v.$refs.barcode_search1.focus();
                                        }), 2e2)
                                    }
                                }else{
                                    v.item_not_found = true;
                                    setTimeout((function () {
                                        v.item_not_found = false;
                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;
                                        v.$refs.barcode_search1.focus();
                                        // console.log(12);
                                    }), 2e3)
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })

                    }
                }
            },


            change_sale_rate_by_price_level_general() {
                
                if (this.inventories != null && this.selected_priceLevelGeneral) {
                    var price_type = this.selected_priceLevelGeneral.price_type;
                    var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                                var rate = this.inventories[i]['item']['rate'];
                                var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[i]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);

                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                }  
                        }
                    }
                }
            },



                    set_avg_rate_bank(defaultAccount) {
                        let vv = this;
                        this.averageRate = false;
                        @if(getAverageRate() =="true")
                        if (defaultAccount) {
                            if (defaultAccount.avg_rate) {
                                setTimeout(() => {
                                    vv.averageRate = true;
                                    vv.selected_currency.rate = defaultAccount.avg_rate;
                                }, 300);
                            }
                        }
                        @endif
                    },

                    checkRefNo() {
                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'refunds'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif
                        }
                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {

                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {

                            let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchPurchase',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }

                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: this.selected_iventory_category});
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("refund-form").submit()

                            }
                            else {

                            }
                        });

                    },


                },
            created: function () {

            }

        });

    </script>


@endpush