@extends('layouts.factor-master')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;

        }
    </style>
@stop
@section('content')

    <!--Table 2 For Customer Information-->
    <table style="width: 100%;">
        <tr>
            <td style="text-align: left; width:100%">
                <table class="main-table">
                    <tr>
                        <td align="center" colspan="2">
                            <b style="font-size: 20px;">@lang('layout.BillFactor')</b>
                        </td>

                    </tr>

                    <tr>
                        <td align="right"><b>@lang('layout.InvoiceNumber')</b></td>
                        <td align="right"><b>@lang('layout.Date')</b></td>
                        <td align="right"><b>@lang('layout.Vendor')</b></td>
                    </tr>
                    <?php
                    $str_date = convertdate($info->date);

                    $date_string = substr($str_date, 0, 10);
                    ?>
                    <tr>
                        <td align="right"><b>{{$info->number}}</b></td>
                        <td align="right"><b>
                                @if(getInvoiceDateFormat() == "shamsi")
                                    <?php
                                    $str_date = convertdate($info->date, 0, 'jalali');

                                    $date_string = substr($str_date, 0, 10)
                                    ?>
                                    {{$date_string}}

                                @elseif(getInvoiceDateFormat() =='both')

                                    <?php
                                    $str_date = convertdate($info->date, 0, 'jalali');

                                    $date_string = substr($str_date, 0, 10);
                                    echo $date_string;
                                    ?>
                                    &nbsp;/&nbsp;
                                    {{substr($info->date,0,10)}}

                                @elseif(getInvoiceDateFormat() =="meladi")
                                    {{substr($info->date,0,10)}}

                                @else

                                    {{$str_date}}

                                @endif
                            </b></td>
                        <td align="right"><b>{{$info->vendor}}</b></td>
                    </tr>
                </table>
            </td>

        </tr>
    </table>
    <!--End Table 2 For Invoice Information-->





    <!--Table 3 For Data  Information-->
    <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
        <tr style="font-weight: bold; font-size: 17px">
            <td class="mt">
                <div class="center">@lang('layout.Number')</div>
            </td>
            <td class="mt">
                <div class="center">@lang('layout.Item')</div>
            </td>
            <td class="mt">
                <div class="center">@lang('layout.Quantity')</div>
            </td>
            <td class="mt">
                <div class="center">@lang('layout.Unit/M')</div>
            </td>


        </tr>
        <?php

        $count = 0;
        $empty = 0;
        $fullCount = count($data);

        if ($fullCount < 15) {
            $empty = 15 - $fullCount;
        }
        ?>

        @foreach($data AS $key1=>$record)

            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record['items']}}</td>
                <td class="center">{{$record['qty']}}</td>
                <td class="center">{{$record['measure']}}</td>
            </tr>
        @endforeach
    </table>

    @if(getDriverInfo()=="true")
        <!--Driver Info-->

        <table style="width: 100%; margin-top: 10px;">
            <tr>
                <td style="text-align: left; width:40%">
                    <table class="main-table">

                        <tr style="font-weight: bold; font-size: 17px">
                            <td align="right"><b>@lang('layout.TransferCode')</b></td>
                            <td align="right"><b>{{$info->transferCode}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.Transporter_name')</b></td>
                            <td align="right"><b>{{$info->driver}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.Transporter_phone')</b></td>
                            <td align="right"><b>{{$info->driverPhone}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.PlaceOfWeight')</b></td>
                            <td align="right"><b>{{$info->PlaceOfWeight}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.SourcePlace')</b></td>
                            <td align="right"><b>{{$info->sourcePlace}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.PlateNumber')</b></td>
                            <td align="right"><b>{{$info->plateNumber}}</b></td>

                        </tr>


                    </table>
                </td>

                <td style="text-align: right; width:40%">
                    <table class="main-table">

                        <tr style="font-weight: bold; font-size: 17px">
                            <td align="right"><b>@lang('layout.WayBillNumber')</b></td>
                            <td align="right"><b>{{$info->wayBillNumber}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.TotalWeight')</b></td>
                            <td align="right"><b>{{$info->totalWeight}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.EmptyCarWeight')</b></td>
                            <td align="right"><b>{{$info->emptyCarWeight}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.TotalBori')</b></td>
                            <td align="right"><b>{{$info->bori}}</b></td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.Description')</b></td>
                            <td align="right"><b>{{$info->trDesription}}</b></td>
                        </tr>

                    </table>
                </td>
            </tr>
        </table>



        <!--End Driver Info-->
    @endif


         <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','invoice') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


    <script type="text/javascript">
        window.print();
    </script>
@endsection






