@extends('layouts.app')

@section('style')


@section('content')
    @include('payrolls.modal')
    <!-- END PAGE HEADER-->


    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="all_payrolls"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option value="" selected="selected">@lang('layout.WithDetail')</option>
                                <option value="1">@lang('layout.WithoutDetail')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name"
                                      :options="member">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="all_payrolls"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option value="" selected="selected">@lang('layout.WithDetail')</option>
                                <option value="1">@lang('layout.WithoutDetail')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                                  :options="member">
                        </v-select>
                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->

        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.PayrollList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                    @permission('payroll-export')
                    <button type="submit" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>

                    <button type="button" class="btn btn-success" id="print_pdf_all"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>
                    @endpermission
                    @permission('payroll-create')
                    <a href="{{route('payroll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
                @endpermission
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered " cellspacing="0" id="payroll">
                    <thead>
                    <tr>
                        {{--<th>@lang('layout.Number')</th>--}}
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.BasicSalary')</th>
                        <th>@lang('layout.WorkedDay')</th>
                        <th>@lang('layout.NetPayable')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.FromDate')</th>
                        <th>@lang('layout.ToDate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <iframe id="payframe" style="display: none;"></iframe>
@stop
@push('scripts')


    <script>

        @if (Session('payroll_id'))
        printVoucher("{{Session('payroll_id')}}")

        @endif
        function printVoucher(id) {

            var a = document.createElement('a');
            a.href = "{{url('printPayroll')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        $(document).ready(function () {
            $('#payroll').DataTable({
                // 'order': [[ 8, 'desc' ]],
                ajax: '{{route("payroll.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollY: 450,
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    // {data: 'id', name: 'payrolls.id'},
                    {data: 'Employee', name: 'members.name'},
                    {data: 'BasicSalary', name: 'BasicSalary', orderabel: false, searchable: false},
                    {data: 'Worked_Days', name: 'Worked_Days', orderabel: false, searchable: false},
                    {data: 'Net_Payable', name: 'Net_Payable', orderabel: false, searchable: false},
                    {data: 'Curreny', name: 'Curreny', orderabel: false, searchable: false},
                    {data: 'From_Date', name: 'From_Date', orderabel: false, searchable: false},
                    {data: 'To_Date', name: 'To_Date', orderabel: false, searchable: false},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderabel: false, searchable: false},
                ]
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        })
        // start app


        // start app
        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
            },
            methods: {
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
                    this.member ={!!$member!!}
                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
            },
            methods: {
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
                    this.member ={!!$member!!}
                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

    </script>
@endpush