@extends('layouts.app')
@section('content')
@section('style')
    <style type="text/css">
        .pay {
            margin-top: 12%;
        }
    </style>
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditPayroll') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" id="item-service" style="margin-bottom: 30%;">
            {!! Form::model($payroll,['method' => 'PATCH','route' => ['payroll.update',$payroll->id]]) !!}
            <div class="form-body">
                <div id="app" v-cloak>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.EmployeeName')</label>
                                <v-select @input="getSalary" placeholder="@lang('layout.SelectEmployee')" label="name"
                                          v-model="selectedEmployee"
                                          :options="{{json_encode($employee)}}">
                                </v-select>
                                <input type="hidden" name="sal_id"
                                       v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">
                                <input type="hidden" name="member_id"
                                       v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <!-- <input type="hidden" id="from_date" name="from_date"> -->
                                    {{Form::text('From_Date',null,['class' => 'form-control date','id'=>'range-from-example'])}}
                                    <span class="input-group-addon">@lang('layout.To') </span>
                                {{Form::text('To_Date',null,['class' => 'form-control date','id'=>'range-to-example'])}}
                                <!-- <input type="hidden" id="to_date" name="to_date"> -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.BasicSalary')</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="basicSalary"
                                                   :value="(!selectedEmployee)?null:selectedEmployee.amount">
                                            <input type="hidden" name="sal_id"
                                                   v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">

                                            <input type="hidden" name="sal_currency"
                                                   v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.currency">
                                            <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SalaryRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                        <input v-model="selectedEmployee.rate" class="form-control"
                                                               name="salaryRate"
                                                               type="number" min="0" step="any">
                                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </span>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select label="code" :options="currency"
                                                  v-model="selectedCurrency"></v-select>
                                    </div>
                                </div>
                                <input type="hidden" name="payroll_currency" v-bind:value="selectedCurrency.code"/>
                                <div class="col-md-6" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.PaymentRate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selectedCurrency.exchange_rate" class="form-control"
                                                       type="number" min="0" step="any">
                                                <span class="input-group-addon">@{{selectedCurrency.exchange_rate}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.PaidLeave')</label>
                                        {{Form::number('paidLeave',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'paidLeave'])}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.WorkedDay')</label>
                                        {{Form::number('workedDay',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'workdays'])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.OverTimeAdditionType')</label>
                                        <select class="form-control" name="type" v-model="type">
                                            <option value="daily">@lang('layout.Daily')</option>
                                            <option value="hourly">@lang('layout.Hourly')</option>
                                            <option value="montly">@lang('layout.Montly')</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Amount')</label>
                                        {{Form::number('overtimeAmount',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'amount'])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Fee')</label>
                                        {{Form::number('fee',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'fee'])}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.TotalOverTime')</label>
                                        <input type="number" class="form-control" value="0" name="overtime"
                                               :value="amount*fee" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.NetPayable')</label>
                                        {{Form::number('Net_Payable',null,['class' => 'form-control','step' => 'any','min' =>'0',':value'=>'netPayable','readonly'])}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                        {{Form::select('expense_id',$expense,null,['class' => 'form-control'])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Description')</label>
                                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-12 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                    <label class="control-label">@lang('layout.BuildExpense')</label>
                                    <input type="checkbox" name="build_expense_confirm" @checked($payroll->build_expense_confirm) id="" value="On">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/row-->
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                <a href="{{route('payroll.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {{Form::close()}}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection
@push('scripts')

    <script>


        ////
        Vue.component("v-select", VueSelect.VueSelect);
        var Currency =
                {!! $currency!!}
        var selectedCurrency =
                {!! $selectedCurrency!!}
        var app = new Vue({
                el: '#app',
                data: {
                    selectedCurrency: selectedCurrency,
                    currency: Currency,
                    currencyList: Currency,
                    workdays:{!!$payroll->Worked_Days!!},
                    selectedBank: null,
                    salary: null,
                    employee:{!! $payroll->member_id !!},
                    payroll:{!! $payroll !!},
                    selectedEmployee: null,
                    paidLeave:{!!$payroll->Paid_Leave!!},
                    type: '{!!$payroll->type!!}',
                    amount:{!!$payroll->overtimeAmount!!},
                    fee:{!!$payroll->fee!!},
                    advancePaid: 0,
                    employees: {!! $employee !!},
                },
                watch: {},
                computed: {

                    netPayable() {
                        if (this.salary != undefined && this.salary != null) {
                            this.salaryAmount = this.salary.amount;
                            this.selectedEmployee['currency'] = this.salary.currency;
                            //this.selectedEmployee['rate']=
                            this.selectedEmployee['sal_id'] = this.salary.id;
                            this.selectedEmployee['rate'] = this.salary.rate;
                        }
                        var total = 0;
                        var workdays = parseFloat((this.workdays) ? this.workdays : 0)
                        var paidLeave = parseFloat((this.paidLeave) ? this.paidLeave : 0)
                        var amount = parseFloat((this.amount) ? this.amount : 0);
                        var fee = parseFloat((this.fee) ? this.fee : 0);
                        let temp_s_e = this.selectedEmployee;

                        if (this.selectedEmployee) {
                            if (paidLeave && workdays) {
                                var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 30);
                                var ff = fee * this.selectedCurrency.exchange_rate;
                                total = (day * (workdays + paidLeave)) + (amount * fee);
                            }
                            else {
                                var ff = fee * this.selectedCurrency.exchange_rate;
                                total = (this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) + (fee * amount);
                            }
                        }
                        return total;
                    },
                },
                created: function () {
                    // this.selectedEmployee=this.employee;
                    for (var a = 0; a < this.employees.length; a++) {
                        if (this.employees[a].id == this.employee) {
                            this.getSalaryRecord(this.employees[a].id);
                            this.selectedEmployee = this.employees[a];
                            this.salaryAmount = this.payroll.amount;
                            this.selectedEmployee['amount'] = this.payroll.amount;
                            this.selectedEmployee['currency'] = this.payroll.currency;
                            //this.selectedEmployee['rate']=
                            this.selectedEmployee['sal_id'] = this.payroll.sal_id;
                            this.selectedEmployee['rate'] = 75;
                            break;
                        }
                    }
                },
                methods: {
                    getSalary() {
                        if (this.selectedEmployee) {
                            console.log('se', this.selectedEmployee);
                            if (this.selectedEmployee.id != this.employee) {
                                this.getSalaryRecord(this.selectedEmployee.member_id);
                            }
                        }
                    },
                    getSalaryRecord(id) {
                        console.log('idd', id);
                        axios.get("{{route('callMethod.search')}}",
                            {
                                params: {
                                    method_name: 'memberSalary',
                                    employee_id: id,
                                },
                            })
                            .then(function (response) {
                                console.log('ssssssssss', response.data)
                                if (response.data) {
                                    app.salary = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });


                    },

                }
            });
    </script>


@endpush