@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">
    @if (count($errors) > 0)
        <div class="m-heading-1 border-red m-bordered errors-action">
            <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
            <ul class="error-body">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPayroll') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
            </div>
        </div>
        <div class="portlet-body form" id="app" style="margin-bottom: 30%;">
            {{Form::open(['route' => 'simplePayroll.store','method' => 'POST','id' => 'payroll-form'])}}
            <div class="form-body">
                <div id="app" v-cloak>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                <v-select placeholder="@lang('layout.Select')" label="name"
                                          v-model="selected_expense"
                                          :options="expense">
                                </v-select>
                                <input type="hidden" name="expense_id"
                                       v-model.number="(!selected_expense)?null:selected_expense.id"
                                       v-validate="'required'" data-vv-as="@lang('layout.ExpenseAccount')">
                                <span class="required">@{{ errors.first('expense_id') }}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')">
                                    <span class="required">@{{ errors.first('from_date') }}</span>
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')">
                                    <span class="required">@{{ errors.first('to_date') }}</span>
                                </div>
                            </div>
                        </div>
						<div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
							<div class="form-group">
                                <label class="control-label">@lang('layout.Date')</label>
                                {{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
							</div>
						</div>
                    </div>
                    <div class="row">
                        <p style="color: red">@lang('layout.Note'): @lang('layout.PayrollNote')</p>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.WorkedDay')</label>

                                <input type="number" name="generalWorkedDay" v-model.number="generalWorkedDay"
                                       v-validate="'required'" data-vv-as="@lang('layout.WorkedDay')"
                                       class="form-control" @input="generalChange">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.PaidLeave')</label> 
                                <input type="number" name="generalPaidLeave" v-model.number="generalPaidLeave"
                                       v-validate="'required'" data-vv-as="@lang('layout.PaidLeave')"
                                       @input="generalChange" class="form-control">
                            </div>
                        </div>
                        @if(systemConfig()[5] != 0 )
                            <div class="col-md-3"> 
                                <label class="control-label">@lang('layout.Project')</label>
                                <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                        :options="project_list" v-model="selectedProject">
                                </v-select>
                                <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                            </div>
                        @endif
                        @if(systemConfig()[19] == 1)
                            <div class="col-md-3"> 
                                <label class="control-label">@lang('layout.NGOProject')</label>
                                <v-select class="vue-select2" label="name" @search="searchNgoProjects" :options="NgoProject_list" v-model="selectedNgoProject">
                                </v-select>
                                <input type="hidden" name="ngo_project_id" v-model.number="(!selectedNgoProject)?null:selectedNgoProject.id">
                            </div>
                        @endif
                    </div>
                    <div class="row">
                        @if(systemConfig()[20] == 1)
                        <div v-if="!contract_percentage" class="col-md-3"> 
                            <label class="control-label">@lang('menu.Contract')</label>
                            <v-select class="vue-select2" 
                                    @search="searchContracts"
                                    v-model="selectedContract" label="company_name"
                                    :options="contract_list">
                            </v-select>
                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                        </div>
                        @endif

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Description')</label>
                                <textarea name="description" class="form-control" rows="2"></textarea>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.BuildExpense')</label>
                                            <input type="checkbox" name="build_expense_confirm" id="" value="On">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if(systemConfig()[20] == 1)
                        <div class="col-md-2">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.MultiContract')</label>
                                            <input type="checkbox" name="contract_percentage" v-model="contract_percentage" value="on">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                     <!-- begin tax ............................................................................................... -->

                     <div class="row">
                        <input type="checkbox" name="tax" v-model="tax">
                        @lang('layout.Tax')
                       <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-if="tax">
                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label">@lang('layout.TaxCurrency')</label>
                                   <v-select  label="code" :options="taxCurrency" v-model="selectedTaxCurrency"></v-select> 
                                   <input type="hidden" name="tax_currency" class="form-control" v-validate="'required'"
                                     data-vv-as="@lang('layout.TaxCurrency')" :value=(!selectedTaxCurrency)?null:selectedTaxCurrency.code>
                                   <span class="required">@{{ errors.first('tax_currency') }}</span> 
                                 <span class="required">@{{ errors.first('tax_currency') }}</span>
                               </div>
                           </div> 
                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label ">@lang('layout.Rate')</label>
                                   <input type="number" name="tax_rate" class="form-control" v-validate="'required'"
                                                  data-vv-as="@lang('layout.Rate')" v-model=(!selectedTaxCurrency)?null:selectedTaxCurrency.rate>
                                   <span class="required">@{{ errors.first('tax_currency') }}</span>
                               </div>
                           </div> 
                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label ">@lang('layout.PaymentType')</label>
                                   <br>
                                   <input type="checkbox" readonly name="by_employee" v-model="paymentType">
                                   @lang('layout.ByEmployee')
                                   
                               </div>
                           </div>

                             <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                               <div class="form-group">
                                   <label class="control-label"> @lang('layout.AgencyTax')</label>
                                  <v-select   
                                  placeholder="@lang('layout.SelectEmployee')" 
                                  label="name"
                                   v-model="selectedMember"
                                   :options="members"
                                   @search="onAgencySearch"
                                       >       
                                   </v-select>
                                   <input type="hidden" name="tax_member" v-model.number="(!selectedMember)?null:selectedMember.id" >
                               </div>
                           </div>

                           <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                       <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                           v-model="selected_tax_expense"
                                        :options="{{$expense_tax}}">       
                                       </v-select>
                                       <input type="hidden" name="selected_tax_expense" v-model="(!selected_tax_expense)?null:selected_tax_expense.id" >
                                   </div>
                           </div>
                       </div>
                   </div>
                   <br>

                   <!-- end tax .................................................................................................... -->

                   <br/>
                   @if(systemConfig()[20] == 1)
                   <!-- begin multiContract -->
                   <table v-if="contract_percentage" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                       <thead>
                           <tr>
                               <th class="text-center" style="min-width: 8px;"> #</th>
                               <th class="text-center" style="min-width: 160px;">@lang('layout.ContractName')</th>
                               <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                               <th></th>
                           </tr>
                       </thead>
                       <tbody>
                           <tr v-for="(record,index) in multiContractData">
                               <td class="text-center">@{{index+1}}</td>
                               <td class="highlight">
                                   <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                           v-model="record.selected" 
                                           label="company_name"
                                           @search="searchContracts"
                                           :options="contract_list" @click.native="addNew('multiContract',index)" >
                                   </v-select>
                                   <input type="hidden" name="multiContract_id[]" :value="(record.selected==null)?null:record.selected.id">
                               </td>

                               <td>
                                   <input class="form-control" type="number" name="percentage[]"
                                       v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                               </td>

                               <td class="text-center" style="vertical-align: middle;">
                                   <span v-on:click="deleteItem('multiContract',index)"><i class="paddint-both glyphicon glyphicon-trash text-danger" style="cursor: pointer;"></i></span>
                               </td>
                           </tr>
                       </tbody>
                   </table>
                   <!-- end multiContract -->
                   @endif

                    <div class="row" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th style="min-width: 100px">@lang('layout.SelectMember') </th>
                                <th style="min-width: 100px">@lang('layout.Number') </th>
                                <th style="min-width: 100px">@lang('layout.Name') </th>
                                <th style="min-width: 100px">@lang('layout.ExpenseAccount') </th>
								@if(systemConfig()[7] != 0 )
                                <th style="min-width: 100px">@lang('layout.PlateNumber') </th>
								@endif
                                <th style="min-width: 150px">@lang('layout.BasicSalary') </th>
                                <th style="min-width: 150px">@lang('layout.SalaryRate') </th>
                                <th style="min-width: 100px">@lang('layout.PaidLeave') </th>
                                <th style="min-width: 100px">@lang('layout.WorkedDay') </th>
                                <th style="min-width: 100px">@lang('layout.AbsentDays') </th>
                                <th style="min-width: 100px">@lang('layout.Currency') </th>
                                <th style="min-width: 150px">@lang('layout.PaymentRate') </th>
                                <th style="min-width: 150px">@lang('layout.TotalOverTime') </th>
                                <th style="min-width: 150px">@lang('layout.NetPayable') </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in employees">
                                <td>
                                    <input type="checkbox" @click="toggleCheck(index)" :checked="item.selected">
                                    <input type="hidden" name="selected[]" :value="item.selected">
                                    <input type="hidden" name="member_id[]" :value="(!item.member)?null:item.member.id">
                                    <input type="hidden" name="salary_id[]"
                                           :value="(!item.member)?null:item.member.salary_id">
                                </td>
                                <td>@{{index+1}}</td>
                                <td>@{{(!item.member)?null:item.member.name}}</td>
                                <td>
									@{{(!item.member)?null:item.member.account_name}}
                                    <input type="hidden" name="expense_account_id[]" :value="(!item.member)?null:item.member.account_id">
                                </td>
								@if(systemConfig()[7] != 0 )
								<td>
                                    <input type="text" class="form-control" name="plate_number[]"
									v-model="(!item.member)?null:item.member.plate_number">
                                </td>
								@endif
								<td>

                                    <div class="input-group">
                                        <input type="number" class="form-control" name="basicSalary[]"
                                               :value="(!item.member)?null:item.member.amount">
                                        <span class="input-group-addon">@{{(item.member)?item.member.currency:null}}</span>
                                    </div>
                                </td>
                                <td>

                                    <div class="input-group">
                                        <input type="number" class="form-control" name="salaryRate[]"
                                               v-model="(!item.member)?null:item.member.rate">
                                        <span class="input-group-addon">@{{(item.member)?item.member.currency:null}}</span>
                                    </div>
                                </td>
                                <td>
                                    <input type="number" class="form-control" name="paidLeave[]" @keyUp="changeWorkdays(index)" @Click="changeWorkdays(index)"
                                           v-model="(!item.member)?null:item.member.paidLeave" v-validate="'required'"
                                           data-vv-as="@lang('layout.PaidLeave')">
                                    <span class="required">@{{ errors.first('paidLeave') }}</span>
                                </td>
                                <td>
                                    <input type="number" class="form-control" name="workedDay[]"
                                           v-model="(!item.member)?null:item.member.workdays" v-validate="'required'"
                                           data-vv-as="@lang('layout.WorkedDay')">
                                    <span class="required">@{{ errors.first('WorkedDay') }}</span>
                                </td>
                                <td>
                                    <input type="number" class="form-control" name="absent_day[]" v-model="(!item.member)?null:item.member.absent_days" @keyUp="changeWorkdays(index)" @Click="changeWorkdays(index)" >
                                </td>
                                <td>

                                    <v-select label="code" :options="currency"
                                              v-model="(!item.payment_currency)?[]:item.payment_currency"></v-select>

                                    <input type="hidden" name="payroll_currency[]"
                                           v-model="(!item.payment_currency)?null:item.payment_currency.code">

                                </td>
                                <td>

                                    <div class="input-group">
                                        <input type="number" name="payroll_rate[]"
                                               v-model="(!item.payment_currency)?null:item.payment_currency.rate"
                                               class="form-control"
                                               min="0" step="any">
                                        <span class="input-group-addon">@{{(!item.payment_currency)?null:item.payment_currency.code}}</span>
                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="totalOverTime[]"
                                               v-model="(!item.member)?null:item.member.totalOverTime">
                                        <span class="input-group-addon">@{{(!item.payment_currency)?null:item.payment_currency.code}}</span>
                                    </div>


                                </td>
                               
                                <td>

                                    <input type="number" class="form-control" name="netPayable[]"
                                           v-model="(!item.member)?null:item.member.netPayable" v-validate="'required'"
                                           data-vv-as="@lang('layout.PaidLeave')">

                                    <span class="required">@{{ errors.first('NetPayable') }}</span>

                                </td>
                            </tr>

                            </tbody>
                        </table>
                        @{{netPayable}}
                    </div>


                </div>
                <!--/row-->
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                <a href="{{route('payroll.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {{Form::close()}}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component("v-select", VueSelect.VueSelect);
        var Currency = {!! $currency !!};
        var expense = {!! $expense !!};
        var TaxCurrency ={!! $taxCurrency !!}


        var vm = new Vue({
            el: '#app',
            data: {
                selectedCurrency: defaultCurrency(),
                currency: Currency,
                members:[],
                selectedMember:null,
                employees: [],
                selected_tax_expense:null,
                expense: expense,
                selected_expense: null,
                selectedProject: null,
                project_list: [],
                selectedNgoProject: null,
                NgoProject_list: [],
                generalPaidLeave: 4,
                generalWorkedDay: 26,
                selectedContract:null,
                contract_list: [],
                taxCurrency:TaxCurrency,
                selectedTaxCurrency:null,
                contract_percentage:null,
                multiContractData: [
                    {percentage: 0, selected: null},
                    {percentage: 0, selected: null},
                ],
                paymentType:1,
                tax:0,
            },
            watch: {},
            computed: {
                netPayable() {
                    if (this.employees.length) {
                        for (var i = 0; i < this.employees.length; i++) {
                            if (this.employees[i]['member']['paidLeave'] &&
                                this.employees[i]['member']['workdays']) {
                                var amount = Number(this.employees[i]['member']['amount']);
                                var sal_rate = Number(this.employees[i]['member']['rate']);
                                var workdays = Number(this.employees[i]['member']['workdays']);
                                var paidLeave = Number(this.employees[i]['member']['paidLeave']);
                                var absent_days = Number((this.employees[i]['member']['absent_days'])?this.employees[i]['member']['absent_days']:0);
                                var totalOverTime = Number(this.employees[i]['member']['totalOverTime']);
                                var payment_rate = Number(this.employees[i]['payment_currency']['rate']);
                                var static_rate = Number(this.employees[i]['member']['static_rate']);
                                var payment_static_rate = Number(this.employees[i]['payment_currency']['static_rate']);

                                var general_total_day = (Number(this.generalWorkedDay) + Number(this.generalPaidLeave));
                                var num_month = 1;
                                if (Math.round((general_total_day) / 27)) {
                                    num_month = Math.round((general_total_day) / 27);
                                }
  
                                @if(systemConfig()[30] == 1)
                                var day = (((amount / static_rate * sal_rate) * payment_static_rate) /payment_rate);
                                @else 
                                var day = ((amount * payment_rate / sal_rate));
                                @endif


                                var per_day = (day * num_month) / general_total_day;

                                if(this.employees[i]['member']['salaryType'] =="TwiceAMonth"){

                                    var per_day = day / 15;

                                }else if(this.employees[i]['member']['salaryType'] =="TwoWeek"){

                                    var per_day = day / 14;

                                }else if(this.employees[i]['member']['salaryType'] =="Weekly"){

                                    var per_day = day / 7;

                                }else if(this.employees[i]['member']['salaryType'] =="Daily"){

                                    var per_day = day / 1;

                                }else if(this.employees[i]['member']['salaryType'] =="Montly"){ 
                                    var per_day = day / 30; 
                                }
                                else{
                                    // var day = day / 30;
                                    var per_day = (day * num_month) / general_total_day;
                                }



                                // var per_day = (day * num_month) / general_total_day;

                                var fee = totalOverTime;

                                
                                var total = ((workdays + paidLeave) * per_day) + Number(fee);

                                this.employees[i]['member']['netPayable'] = (total).toFixed(precision());

                            }

                        }
                    }

                    return;
                },
            },
            mounted: function () {
                //this.getEmployee();
                this.getMembers();
            },
            methods: { 
                generalChange() {
                    if (this.employees.length) {
                        for (var i = 0; i < this.employees.length; i++) {
                            this.employees[i]['member']['paidLeave'] = this.generalPaidLeave;
                            this.employees[i]['member']['workdays'] = this.generalWorkedDay;
                            this.employees[i]['member']['absent_days'] = 0;
                        }
                    }
                },
                onAgencySearch(search, loading) {
                    loading(true);
                    this.searchAgencyMember(search, loading, this);
                },
                searchAgencyMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: '',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.members = [];
                        if (response.data.length > 0) {
                            vm.members = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                toggleCheck(index) {
                    this.employees[index].selected = !this.employees[index].selected;
                },

                getMembers(id = null) {
                    $.ajax({
                        url: "{{route('simplePayroll.create')}}",
                        async: false,
                        data: {
                            method_name: 'memberSalary',
                            employee_id: id,
                        },
                        success: function (data) {
                            if (data.length > 0) {
                                // console.log('kkkkk',data)
                                for (var i = 0; i < data.length; i++) {
                                    var s_currency=this.selectedCurrency
                                    if (data[i].currency) {
                                        s_currency=_.find(this.currency,(c)=>c.code==data[i].currency);
                                    }
                                    var paidLeave = data[i].paidLeave;
                                    var workdays = data[i].workdays;
                                    if(data[i].salaryType == "TwiceAMonth"){
                                        workdays = 13;
                                        paidLeave = 2;
                                    }else if(data[i].salaryType == "TwoWeek"){
                                        workdays = 12;
                                        paidLeave = 2;
                                    }else if(data[i].salaryType == "Weekly"){
                                        workdays = 6;
                                        paidLeave = 1;
                                    }else if(data[i].salaryType == "Daily"){
                                        workdays = 1;
                                        paidLeave = 0;
                                    }else{
                                        workdays = 26;
                                        paidLeave = 4;
                                    } 
                                    this.employees.push({
                                        selected: true,
                                        member: data[i],
                                        payment: null,
                                        payment_currency: s_currency,
                                        workdays:workdays,
                                        paidLeave:paidLeave
                                    });
                                }
                                this.generalChange();
                            } 
                        }.bind(this),

                        error: function (error) {
                            console.log(error)
                        }
                    });

                },
                // Search Project

				ProjectSearch:_.debounce((search,loading)=>{
                    vm.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						vm.project_list=response.data;
						console.log('test 22',vm.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                // Search Ngo Project

                searchNgoProjects(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'ngo_projects',
                        }
                    })
                    .then(function (response) {
                        vm.NgoProject_list = [];
                        if (response.data.length > 0) {
                            vm.NgoProject_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

                // Search Contract
                searchContracts(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'contracts',
                            search_column:'company_name'
                        }
                    })
                    .then(function (response) {
                        vm.contract_list = [];
                        if (response.data.length > 0) {
                            vm.contract_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

                // generic function for adding item to list
                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            if (this.multiContractData[index + 1] == undefined) {
                                this.multiContractData.push({
                                    percentage: 0,
                                    selected: null
                                });
                            }
                        }
                    }

                },


                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            this.multiContractData.splice(index, 1);
                        }
                    }

                },
                
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                changeWorkdays(i) {
                    if (this.employees[i]['member']) {
                        var general_total_day = (Number(this.generalWorkedDay) + Number(this.generalPaidLeave));
                        if(this.employees[i]['member']['paidLeave'] > 0 || this.employees[i]['member']['absent_days'] > 0){
                            this.employees[i]['member']['workdays'] = (general_total_day - (parseFloat((this.employees[i]['member']['paidLeave'])?this.employees[i]['member']['paidLeave']:0) + parseFloat((this.employees[i]['member']['absent_days'])?this.employees[i]['member']['absent_days']:0)));
                            // console.log(this.employees[i]['member']['workdays']);
                            // console.log('Neww', this.employees[i]['member']['workdays']);
                        }
                    }
                },
                saveAndNew()
                {
                    this.$validator.validate()
                    .then(valid =>{
                        if(valid)
                        { 
                            var url="{{route('simplePayroll.store')}}";
                            form_id='payroll-form';
                            var data= $('#'+form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url,data)
                            .then(function(response){
                                    toggleBlock(0);
                                    if(response.data.result==1)
                                    {
                                        $('#'+form_id).trigger('reset');
                                        
                                        toastr.success('',response.data.message); 
                                        location.reload();
                                    
                                    }
                                    else
                                    {
                                        var message="{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('',message);
                                    }
                            })
                            .catch(function(error){
                            toggleBlock(0);
                                console.log(error);
                                var message="{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('',message);
                            });
                        
                        }
                    })
                },
            },

        });
    </script>
@endpush