@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('payroll', 'index');
    ?>


    <table class="main-table">
        <tr class="bg">
            <td colspan="5">
                <div class="">
                    <span>@lang('layout.FromDate')</span>
                    <span>{{$from_date}}</span>
                </div>
            </td>
            <td colspan="6">
                <div class="">
                    <span>@lang('layout.ToDate')</span>
                    <span>{{$to_date}}</span>
                </div>
            </td>
        </tr>
    </table>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.PayrollReport')</h3>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Name') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.WorkedDay')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.PaidLeave')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.OverTimeAddition')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.NetPayable')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.BasicSalary')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Description')</div>
            </td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>
            <?php
            $total_home_currency += $record->exchanged_amount;
            if (array_key_exists($record->currency, $currencies)) {
                $currencies[$record->Curreny] = $currencies[$record->Curreny] + $record->Amount;
            } else {

                $currencies[$record->Curreny] = $record->Amount;
            }
            ?>

            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->Employee}}</td>
                <td class="center">{{$record->Worked_Days}}</td>
                <td class="center">{{$record->Paid_Leave}}</td>
                <td class="center">{{$record->Overtime_addition}}</td>
                <td class="center">{{$record->Net_Payable}}</td>
                <td class="center">{{$record->BasicSalary}}</td>
                <td class="center">{{$record->Curreny}}</td>
                <td class="center">{{$record->Amount}}</td>
                <td class="center">{{$record->description}}</td>

            </tr>
        @endforeach
    </table>

    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency)
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()["code"]}}</div>
            </td>

        </tr>
    </table>
     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection
