@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('payroll');
    $_from_date = in_array('from_date', $report);
    $_to_date = in_array('to_date', $report);
    $_name = in_array('name', $report);
    $_worked_day = in_array('worked_day', $report);
    $_paid_leave = in_array('paid_leave', $report);
    $_over_time_addition = in_array('over_time_addition', $report);
    $_net_payable = in_array('net_payable', $report);
    $_basic_salary = in_array('basic_salary', $report);
    $_currency = in_array('currency', $report);
    $_amount = in_array('amount', $report);
    $_description = in_array('description', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.PayrollReport')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            @if($_from_date)
                <td>
                    <div class="center"> @lang('layout.FromDate')</div>
                </td>@endif
            @if($_to_date)
                <td>
                    <div class="center"> @lang('layout.ToDate')</div>
                </td>@endif
            @if($_name)
                <td>
                    <div class="center"> @lang('layout.Name') </div>
                </td>@endif
            @if($_worked_day)
                <td>
                    <div class="center"> @lang('layout.WorkedDay')</div>
                </td>@endif
            @if($_paid_leave)
                <td>
                    <div class="center"> @lang('layout.PaidLeave')</div>
                </td>@endif
            @if($_over_time_addition)
                <td>
                    <div class="center"> @lang('layout.OverTimeAddition')</div>
                </td>@endif
            @if($_net_payable)
                <td>
                    <div class="center"> @lang('layout.NetPayable')</div>
                </td>@endif
            @if($_basic_salary)
                <td>
                    <div class="center"> @lang('layout.BasicSalary')</div>
                </td>@endif
            @if($_currency)
                <td>
                    <div class="center"> @lang('layout.Currency')</div>
                </td>@endif
            @if($_amount)
                <td>
                    <div class="center"> @lang('layout.Amount')</div>
                </td>@endif
            @if($_description)
                <td>
                    <div class="center"> @lang('layout.Description')</div>
                </td>@endif
        </tr>
        </thead>
        <?php

        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>
            <?php
            $total_home_currency += $record->exchanged_amount;

            if (array_key_exists($record->Currency, $currencies)) {

                $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
            } else {

                $currencies[$record->Currency] = $record->Amount;

            }
            ?>

            <tr>
                <td class="center">{{++$count}}</td>
                @if($_from_date)
                    <td class="center">{{convertDate($record->From_Date)}}</td>@endif
                @if($_to_date)
                    <td class="center">{{convertDate($record->To_Date)}}</td>@endif
                @if($_name)
                    <td class="center">{{$record->Employee}}</td>@endif
                @if($_worked_day)
                    <td class="center">{{$record->Worked_Days}}</td>@endif
                @if($_paid_leave)
                    <td class="center">{{$record->Paid_Leave}}</td>@endif
                @if($_over_time_addition)
                    <td class="center">{{$record->Overtime_addition}}</td>@endif
                @if($_net_payable)
                    <td class="center">{{$record->Net_Payable}}</td>@endif
                @if($_basic_salary)
                    <td class="center">{{$record->BasicSalary}} <span>{{$record->SalaryCurrency}}</span></td>@endif
                @if($_currency)
                    <td class="center">{{$record->Currency}}</td>@endif
                @if($_amount)
                    <td class="center">{{$record->Amount}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
            </tr>
        @endforeach
    </table>

    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency)
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>

        </tr>
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection
