@extends('layouts.factor-master')
@section('content')
    <?php
    $report = customeReport('build');
    $_date = in_array('date', $report);
    $_build_number = in_array('build_number=', $report);
    $_item_name = in_array('item_name', $report);
    $_measure = in_array('measure', $report);
    $_quantity = in_array('quantity', $report);
    $_purchase_rate = in_array('purchase_rate', $report);
    $_TotalExpense = in_array('_TotalExpense', $report);
    $_possibleBuildQuentity = in_array('possibleBuildQuentity', $report);
    
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
                </td>
            @endif
            @if($item_name)
                <td>
                    <span>@lang('layout.ItemName')</span>:
                    <BDO>{{$item_name}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td class="center" >
                <div> @lang('layout.Record') </div>
            </td>
            @if($_date)
                <td class="center" >
                    <div> @lang('layout.Date')</div>
                </td>@endif
            @if($_build_number)
                <td class="center" >
                    <div> @lang('layout.BuildNumber') </div>
                </td>@endif
            @if(!$item_name)
            @if($_item_name)
                <td class="center" >
                    <div> @lang('layout.ItemName')</div>
                </td>@endif
            @endif
            @if($_measure)
                <td class="center" >
                    <div> @lang('layout.Measure')</div>
                </td>@endif
            @if($_quantity)
                <td class="center" >
                    <div> @lang('layout.Quantity')</div>
                </td>@endif
            {{-- @if($_possibleBuildQuentity)
                <td class="center">
                    <div>
                        @lang('layout.PossibleBuildQuentity')
                    </div>
                </td>
            @endif --}}
            <td class="center">
                <div>
                    @lang('layout.PossibleBuildQuentity')
                </div>
            </td>
            @if($_purchase_rate)
                <td class="center" >
                    <div> @lang('layout.Cost')</div>
                </td>@endif
            @if($_TotalExpense)
                <td class="center" >
                    <div> @lang('layout.TotalExpense')</div>
                </td>@endif
            <td class="center" >
                <div> @lang('layout.CostWithExpenses')</div>
            </td>
            <td class="center" >
                <div> @lang('layout.User')</div>
            </td>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->Date)}}</td>@endif
                @if($_build_number)
                    <td class="center">{{$record->build_number}}</td>@endif
                @if(!$item_name)
                @if($_item_name)
                    <td class="center">{{$record->Name}}</td>@endif
                @endif
                @if($_measure)
                    <td class="center">{{$record->measure_name}}</td>@endif
                @if($_quantity)
                    <td class="center">{{$record->Quantity}}</td>
                @endif
                {{-- @if($_possibleBuildQuentity)
                    <td class="center">
                        {{$record->PossibleBuildQuentity}}
                    </td>
                @endif --}}
                <td class="center">
                    {{$record->possibleBuildQuentity}}
                </td>
                @if($_purchase_rate)
                    <td class="center">{{round($record->Cost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</td>@endif
                @if($_TotalExpense)
                    <td class="center">{{$record->expense_amount}}</td>@endif
                <td class="center">{{$record->Cost+$record->expense_amount}}</td>
                <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach
    </table>

    <br>
    <table class="main-table">
        <tr class="bg">
            <td colspan="8" class="center">
                <div class="center">@lang('layout.BuildReport')</div>
            </td>
        </tr>
        <tr>
            <td class="center">
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <td style="display: <?=(!show('date', $report)) ? 'none' : '';?>" class="center">
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td style="display: <?=(!show('build_number', $report)) ? 'none' : '';?>" class="center">
                <div class="center"> @lang('layout.BuildNumber') </div>
            </td>
            <td style="display: <?=(!show('item_name', $report)) ? 'none' : '';?>" class="center">
                <div class="center"> @lang('layout.ItemName')</div>
            </td>
            <td style="display: <?=(!show('measure', $report)) ? 'none' : '';?>" class="center">
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td style="display: <?=(!show('quantity', $report)) ? 'none' : '';?>" class="center">
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td class="center">
                <div class="center"> @lang('layout.TotalExpense')</div>
            </td>
            <td style="display: <?=(!show('purchase_rate', $report)) ? 'none' : '';?>" class="center">
                <div class="center"> @lang('layout.Cost')</div>
            </td>
        </tr>
        <?php
        $count = 0;
        $totalCost = 0;
        ?>
        @foreach($dataByTotal AS $record)
            <?php
            $totalCost += $record->Cost
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td style="display: <?=(!show('date', $report)) ? 'none' : '';?>" class="center">
                    {{convertDate($record->Date)}}
                </td>
                <td style="display: <?=(!show('build_number', $report)) ? 'none' : '';?>"
                    class="center">{{$record->build_number}}</td>
                <td style="display: <?=(!show('item_name', $report)) ? 'none' : '';?>"
                    class="center">{{$record->Name}}</td>
                <td style="display: <?=(!show('measure', $report)) ? 'none' : '';?>"
                    class="center">{{$record->measure_name}}</td>
                <td style="display: <?=(!show('quantity', $report)) ? 'none' : '';?>"
                    class="center">{{$record->Quantity}}</td>
                <td class="center">{{round($record->expense_amount,2)}}</td>
                <td style="display: <?=(!show('purchase_rate', $report)) ? 'none' : '';?>"
                    class="center">{{round($record->Cost+$record->expense_amount,2)}}</td>
            </tr>
        @endforeach
        <tr class="bg">
            <td colspan="4" class="center">
                <div class="center">@lang('layout.Total')</div>
            </td>
            <td colspan="4" class="center">
                <div class="center">{{round($totalCost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>
        </tr>
    </table>
     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >    
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
        @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection