@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@stop
@section('content')
<!-- BEGIN CONTENT BODY -->
<!-- END PAGE BAR -->
<div class="row">
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BuildAssembly')</span>
                {{--<span class="caption-helper"></span>--}}
            </div>
            <div class="tools">
                <a href="" class="collapse"> </a>
                <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                <a href="" class="reload"> </a>
                <a href="" class="remove"> </a>
            </div>
        </div>
        <div class="portlet-body form" id="assembaly" v-cloak>
            <div class="form-body">
                <div class="row">
                    <div v-if="import_build_item" class="col-md-10">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <a href="{{url('/')}}/import_file/simple_import_build_item_excel_file.xlsx">
                            <span class="btn btn-success">
                            <i class="fa fa-download"></i>
                            @lang('layout.SampleExcelFile')
                            </span>
                            </a>
                        </div>
                        <!-- BEGIN FORM-->
                        {{Form::open(['route'=>'simpleBuildImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                            {{ csrf_field() }}
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.SelectFile') @lang('layout.Excel') : </label>
                                    {{Form::file('inventory_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                </div>
                                <input type="hidden" name="number" v-model="number" class="form-control">
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <button type="button" OnClick="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                                <button type="reset" @click="import_build_item = false" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                                </button>
                            </div>
                        {{Form::close()}}
                        <!-- end form -->
                    </div>
                </div>
            </div>
            <!-- BEGIN FORM-->
            {{Form::open(['route' => 'simpleBuild.store','method' => 'POST','class' => 'form-','id'=>'assembly-form'])}}
            <div class="form-body">
                <div class="row">
                    <div class="col-lg-9 col-md-9">
                        <input type="hidden" name="temp_type" value="simpleBuild">
                        <div class="col-lg-12 col-md-12">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.ItemName')</label>
                                    <v-select label="name" v-model="selected_assembly_item" :options="formula_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" name="item" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                                    <span class="required">@{{ errors.first('item') }}</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.SiteName')</label>
                                    <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site">
                                    </v-select>
                                    <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null" v-validate="'required'" data-vv-as="@lang('layout.SiteName')">
                                    <span class="required">@{{ errors.first('site') }}</span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.AssemblyCode') </label>
                                    <input type="number" name="number" v-model="number" class="form-control">
                                    <span class="required">@{{ errors.first('number') }}</span>
                                </div>
                            </div>
                            <div class="col-md-2 col-xs-12">
                                <div class="col-md-12 form-group">
                                    <label class=" control-label">@lang('layout.InventoryImport')</label>
                                    <div>
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="import_build_item" v-model="import_build_item">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                    <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="buildQty" @input="select_percentage()" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.QuantityToBuild')">
                                    <span class="required">@{{ errors.first('build_qty') }}</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    <date_picker name="date" v-model="date" placeholder="@lang('layout.Date')" ></date_picker>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label col-md-4">@lang('layout.Description') </label>
                                    <textarea name="description" class="form-control" rows="1" v-text="description" ></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            @if(getOtherMeasure() == "true")
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.OMeasureValue1')</label>
                                    <input type="number" placeholder="@lang('layout.OMeasureValue1')" name="other_measure_amount" class="form-control" >
                                </div>
                            </div>
                            @endif
                            @if(getOtherMeasure2() == "true")
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.OMeasureValue2')</label>
                                    <input type="number" placeholder="@lang('layout.OMeasureValue2')" name="other_measure_amount2" class="form-control" >
                                </div>
                            </div>
                            @endif
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.PossibleBuildQuentity')</label>
                                    <input type="number" step="any" placeholder="@lang('layout.PossibleBuildQuentity')" name="possibleBuildQuentity" class="form-control" >
                                </div>
                            </div>
                        </div>
                        <div class=" col-md-12">
                            @if(getExpireDate() == 'true')
                            <div class="col-md-4" v-show="showWhat('expire_date')=='yes'">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.ExpireDate')</label>
                                    <input class="form-control date" name="expireDate" readonly="readonly" autocomplete="off" placeholder="@lang('layout.ExpireDate')">
                                </div>
                            </div>
                            @endif

                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ContractName')</label>
                                    <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                            v-model="selectedContract" label="company_name"
                                            @input="changeContract()" :options="{{$contract}}">
                                    </v-select>
                                    <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.WagonNumber')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                        @input="contractWagon()" v-model="selectedWagon" label="name" :options="wagon">
                                        </v-select>
                                        <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class=" col-md-12">
                            @if(showLocation()=="true")
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Location')</label>
                                    <input type="text" name="location"  class="form-control" >
                                </div>
                            </div>
                            @endif
                            @if(getFlour()=="true")
                            <div class="col-md-2">
                                <label class=" control-label">@lang('layout.Percentage')</label>
                                <div>
                                    <label class="mt-checkbox mt-checkbox-outline">
                                        <input type="checkbox" name="percentage" @click="select_percentage()" value="on" v-model="percentage">
                                        <span></span>
                                    </label>
                                </div>
                            </div>
                            @endif
                            <div class="col-md-3">
                                <label class=" control-label">@lang('layout.ExpenseWithTotalQuantity')</label>
                                <div>
                                    <label class="mt-checkbox mt-checkbox-outline">
                                        <input type="checkbox" name="total_expense" value="on" v-model="total_expense">
                                        <span></span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class=" control-label">@lang('layout.CalculatePercentageByRateOfUsedItem')</label>
                                <div>
                                    <label class="mt-checkbox mt-checkbox-outline">
                                        <input type="checkbox" name="cal_per_by_used_item" value="on">
                                        <span></span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.SiteOut')</label>
                                    <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_out_site" :options="site" @input="setSite()">
                                    </v-select>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!--  calculation part -->
                    <div class="col-lg-3 col-md-3">
                        <div class="row" >
                            <label class="control-label"> @lang('layout.Formula')</label>
                            <div class="dashboard-stat2 ">

                                <table class="dashboard-tabel" width="100%">
                                    
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{Number.parseFloat(subtotal).toFixed(2)}} {{getHomeCurrency()["code"]}}</span>   
                                            <small class="font-green-sharp"></small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.QuantityUsedToBuild'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{Number.parseFloat(buildQtyB).toFixed(1)}}</span>
                                            <small class="font-green-sharp"></small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.QuantityToBuild'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{Number.parseFloat(totalBuildQty).toFixed(1)}}</span>
                                            <small class="font-green-sharp"></small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.AfterBuild'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{Number.parseFloat(buildQtyB - totalBuildQty).toFixed(1)}}</span>
                                            <small class="font-green-sharp"></small>
                                        </td>
                                    </tr>
                                    @if(getBuildExpense() == "true")
                                    <tr>
                                        <td>
                                        <small>@lang('layout.TotalExpense'):</small>
                                        </td>
                                        <td class="text-right">
                                        <span class="text-right" data-counter="counterup" data-value="7800"> @{{ expenseAmount }} {{getHomeCurrency()["code"]}}</span>
                                        <small class="font-green-sharp"></small>
                                        </td>
                                    </tr>
                                    @endif


                                </table>

                            </div>
                        </div>

                    </div>
                   <!-- end of calculation -->

                </div>
            </div>

            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;color: white;"> @lang('layout.FormulaItems') </li>
            <div v-if="assemlby_items.length >0 " class="">
                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> #</th>
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                            @if(searchByCodeLocation()=="true")
                            <th style="min-width: 110px;">@lang('layout.Location')</th>
                            @endif
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.Site')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.AverageCost')</th>
                            <th v-if="percentage" class="text-center" style="min-width: 80px;"> @lang('layout.Percentage')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                            @if(getM2()!="")
                            @if(getFactorMeasure2()=="true")
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure2')</th>
                            @endif
                            @endif
                            @if(getM3()!="")
                            @if(getFactorMeasure3()=="true")
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure3')</th>
                            @endif
                            @endif
                            <th style="width: 20px;"></th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr v-for="(inventory,InventoryIndex) in assemlby_items" class="even">
                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important; color: black;"> @{{InventoryIndex+1}} </span>
                            </td>
                            <td class="td_one">
                                <v-select label="name" @input="(editKey)?onItemload(InventoryIndex):''" @keyup.native="editKey = true" @Click.native="editKey = true"
                                    v-model="inventory.inventory" :options="temp_items" @search="onItemsSearch"></v-select>
                                <input type="hidden" :name="'inventory_id['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(inventory.item==null)?null:inventory.item.id">
                                <span class="required">@{{ errors.first('inventory_id['+InventoryIndex+']') }}</span>
                            </td>
                            @if(searchByCodeLocation()=="true")
                            <td class="highlight">
                                <v-select label="name" @Click.native="setIndex(InventoryIndex)" v-model="inventory.location" :options="(inventory.item==null)?[]:inventory.item.locationList" @search="locationSearch" ></v-select>
                                <input type="hidden" :name="'item_location['+InventoryIndex+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!inventory.location)?null:inventory.location.name">
                            </td>
                            @endif
                            <td class="highlight">
                                <select v-model="(inventory.item==null)?null:inventory.item.item.site" class="form-control">
                                    <option value="null">@lang('layout.Select')</option>
                                    <span v-if="(inventory.item != null)">
                                        <option v-for="site in (inventory.item==null)?null:inventory.item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                        </option>
                                    </span>
                                </select>
                                <input type="hidden" :name="'inventory_site['+InventoryIndex+']'" :value="(inventory.item==null)?null:((inventory.item.item.site==null)?null:inventory.item.item.site.site_id)">
                            </td>
                            <td>
                                <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" class="form-control input_style" placeholder="Measure" required="required">

                                    <span v-if="inventory.item.measure_list !=null">
                                        <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                    </span>
                                </select>

                                <input type="hidden" name="inventory_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                            </td>
                            <td>
                                <input readonly type="number" :value="(!inventory.item)?null:(inventory.item.item ==null)?getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty,inventory.item.on_hand,inventory.location):((inventory.item.item.site==null)?getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty,inventory.item.on_hand,inventory.location):getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty,inventory.item.item.site.OnHand,inventory.location))">
                            </td>
                            <td>
                                <input readonly type="number" :value="(inventory.item == null)?null:getItemCost(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.unitcost)">
                            </td>
                            <td v-if="percentage" >
                                <input type="number" :name="'item_percentage['+InventoryIndex+']'" v-model.number="(inventory.item==null)?null:inventory.item.percentage" @input="select_percentage()" class="form-control input-style input-number" placeholder="@lang('layout.Percentage')">
                            </td>
                            <td>
                                <input type="number" :name="'inventory_qty['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(inventory.item==null)?null:inventory.item.qty" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                <span class="required">@{{ errors.first('inventory_qty['+InventoryIndex+']') }}</span>
                            </td>
                            @if(getM2()!="")
                            @if(getFactorMeasure2()=="true")
                            <td>
                                @{{(!inventory.item)?null:((!inventory.item.measure1)?null:((inventory.item.qty * inventory.item.measure.measure_unit) / inventory.item.measure1.measure_unit))}} @{{(!inventory.item)?null:((!inventory.item.measure1)?null:(inventory.item.measure1.measure_name))}}
                            </td>
                            @endif
                            @endif
                            @if(getM3()!="")
                            @if(getFactorMeasure3()=="true")
                            <td>
                                @{{(!inventory.item)?null:((!inventory.item.measure2)?null:((inventory.item.qty * inventory.item.measure.measure_unit) / inventory.item.measure2.measure_unit))}} @{{(!inventory.item)?null:((!inventory.item.measure2)?null:(inventory.item.measure2.measure_name))}}
                            </td>
                            @endif
                            @endif
                            <td>
                                <span v-if="InventoryIndex > 0" v-on:click="deleteItem('inventory',InventoryIndex)">
                                    <i class="paddint-both glyphicon glyphicon-trash"></i>
                                </span>

                            </td>
                        </tr>
                        <tr style="background-color: #ffffff;">
                            <td></td>
                            <td>
                                <center>
                                    <span @click="addNew('inventory',100)" class="btn btn-success" style="background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141)"><i class="fa fa-plus"></i></span>
                                </center>
                            </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>

                    </tbody>
                </table>

            </div>
            <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
            </button>

            <div class="form-section"></div>
            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;color: white;"> @lang('layout.AdjastmentItems') </li>

            <div v-if="otherBuild.length >0 " class="">
                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> #</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.Site')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.OnHand')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                            <th style="width: 20px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(inventory,InventoryIndex) in otherBuild" class="even">
                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important;color: black;"> @{{InventoryIndex+1}} </span>
                            </td>
                            <td class="td_one">
                                <v-select label="name" @input="(editKey)?onOtherItemload(InventoryIndex):''" @keyup.native="editKey = true" @Click.native="addNew('otherBuilds',InventoryIndex), editKey = true"
                                    v-model="inventory.inventory" :options="temp_items" @search="onItemsSearch"></v-select>
                                <input type="hidden" name="other_build_id[]" :value="(inventory.item==null)?null:inventory.item.id">
                            </td>
                            <td>
                                <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" class="form-control input_style" placeholder="Measure" required="required">
                                    <span v-if="inventory.item.measure_list !=null">
                                        <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                    </span>
                                </select>
                                <input type="hidden" name="other_build_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                            </td>
                            <td class="highlight">
                                <select v-model="(inventory.item==null)?null:inventory.item.item.site" class="form-control">
                                    <option value="null">@lang('layout.Select')</option>
                                    <span v-if="(inventory.item != null)">
                                        <option v-for="site in (inventory.item==null)?null:inventory.item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                        </option>
                                    </span>
                                </select>
                                <input type="hidden" :name="'other_build_site['+InventoryIndex+']'" :value="(inventory.item==null)?null:((inventory.item.item.site==null)?null:inventory.item.item.site.site_id)">
                            </td>
                            <td>
                                <input readonly type="number" :value="(!inventory.item)?null:getBuildOnHandWestage(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty,inventory.item.on_hand)">
                            </td>
                            <td>
                                <input name="other_build_qty[]" class="form-control inpu-number-fild" :class="" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" @input="select_percentage()" placeholder="@lang('layout.Quantity')" />
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="number" class="form-control" placeholder="%" v-model.number="(!inventory.item)?null:inventory.item.cost" style="min-width: 100px" required name="other_build_cost[]" />
                                    <span class="input-group-addon">%</span>
                                </div>
                            </td>
                            <td>
                                <span v-on:click="deleteItem('otherBuild',InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                            </td>
                        </tr>

                    </tbody>
                </table>

            </div>

            <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
            </button>
            @if(getBuildExpense() == "true")
            <!-- build expense -->

            <div class="form-section"></div>
            <li class="list-group-item bg-green bg-font-green" style="background-color: rgb(80, 129, 141) !important;color: white;"> @lang('layout.Expense') </li>

            <div v-if="expenses.length >0 " class="">

                <table id="table_content" class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> #</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.ExpenseAccount')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                            <th style="width: 20px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(expense,index) in expenses" class="even">
                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important;color: black;"> @{{index+1}} </span>
                            </td>
                            <td class="td_one">

                                <v-select label="name" v-model="expense.expense_account" :options="expense_account" @click.native="addNew('expense',index)"></v-select>
                                <input type="hidden" name="expense_id[]" :value="(expense.expense_account==null)?null:expense.expense_account.id">

                            </td>
                            <td>
                                <input type="text" name="expense_description[]" v-model="expense.description" class="form-control" placeholder="@lang('layout.Description')">
                            </td>
                            <td>
                                <input type="number" name="expense_amount[]" v-model="expense.amount" class="form-control" placeholder="@lang('layout.Amount')">
                            </td>
                            <td>
                                <span v-on:click="deleteItem('expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                            </td>
                        </tr>

                    </tbody>
                </table>

            </div>
            @endif

            <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
            </button>

            <!-- end build expense -->

            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                    <button type="button" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('simpleBuild.index')}}" @click="clearTemp" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                </div>
            </div>
            {{Form::close()}}

        </div>
    </div>

    <!-- END FORM-->
</div>
</div>

@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>



<script>
    Vue.component('v-select', VueSelect.VueSelect);

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    function callSaveTemp() {
        @if(saveTempData() == 'true')
        setTimeout((function() {
            sales.saveTemp();
            // console.log(12);
        }), 4e4)
        @endif
    }

    var site ={!! $site !!};
    var expense_account = {!! $expense_account !!};
    var wagon= {!! $wagon !!};

    var sales = new Vue({
        el: '#assembaly',
        data: {
            site: site,
            selected_site: null,
            selected_out_site: null,
            editKey: false,
            buildQty: null,
            totalBuildQty: 0,
            otherQuantity: 0,
            buildQtyB:0,
            percentage:null,
            total_expense:null,
            selected_index:0,
            selected_assembly_item: null,
            disabled: false,
            import_build_item: false,
            number: "{{$number}}",
            date: null,
            description: null,
            wagon: wagon,
            wagonAll: wagon,
            selectedContract: null,
            selectedWagon: null,
            assembly_item: [],
            temp_items: [],
            formula_items: [],
            assemlby_items: [{
                inventory: null,
                item: null,
                location: null
            }, ],
            otherBuild: [{
                    inventory: null,
                    item: null
                },
                {
                    inventory: null,
                    item: null
                },
                {
                    inventory: null,
                    item: null
                },
                {
                    inventory: null,
                    item: null
                },
            ],
            otherBuildIndex: 0,
            inventoryIndex: 0,
            inventoryItem: null,
            expense_account: expense_account,
            expenses: [{
                    expense_account: null
                },
                {
                    expense_account: null
                },
                {
                    expense_account: null
                },
            ],
        },

        computed: {
            buildQ: function() {
                var min = null;
                if (this.selected_formula) {
                    var rows = this.selected_formula.formula;

                    if (rows.length > 0) {
                        var temp = ((rows[0].new_quantity * rows[0].measure.measure_unit / rows[0].measure_unit));

                        //var temp_other_build=this.selected_formula.other_build;
                        min = rows[0].on_hand / temp;
                        for (var i = 1; i < rows.length; i++) {

                            var temp = ((rows[i].new_quantity * rows[i].measure.measure_unit / rows[i].measure_unit));
                            var result = (rows[i].on_hand * rows[i].item_item_measure.measure_unit) / (rows[i].measure.measure_unit);

                            if (result / temp < min) {
                                min = result / temp;
                            }

                        }
                        min = min.toFixed(precision());

                    }

                }
                return min;
            },
            isError: function() {
                var isError = false;
                if ((this.selected_item == null && !this.selected_item) || this.selected_formula == null || this.selected_site == null || this.buildQty <= 0 || (this.buildQ - this.buildQty) < 0) {
                    isError = true;
                }
                return isError;
            },
            subtotal: function() {
                var sum = 0;
                var quantity = 0;
                var otherQuantity = 0;

                if (this.otherBuild) {
                    for (var i = 0; i < this.otherBuild.length; i++) {
                        if (this.otherBuild[i].item){
                            if (this.otherBuild[i].item.qty && this.otherBuild[i].item.qty !=null){  
                                var OnHand1=this.otherBuild[i].item.qty;
                                otherQuantity += parseFloat(OnHand1);
                            }
                        }
                    }
                }

                if(this.buildQty || otherQuantity){
                    this.totalBuildQty = ((this.buildQty)?Number.parseFloat(this.buildQty):0) + ((otherQuantity)?Number.parseFloat(otherQuantity):0);
                }

                for (var i = 0; i < this.assemlby_items.length; i++) {
                    if (this.assemlby_items[i].item && this.assemlby_items[i].item != null) {


                        var qty = Number.parseFloat(this.assemlby_items[i]['item']['qty']);
                        var cost = this.assemlby_items[i]['item']['unitcost'];

                        var item_measure = this.assemlby_items[i]['item']['measure_unit'];
                        var s_item_measure = this.assemlby_items[i]['item']['measure']['measure_unit'];

                        quantity += qty;
                        sum += qty * ((cost * item_measure) / (s_item_measure));

                    }
                }
                this.buildQtyB = quantity;

                return sum;
            },

            expenseAmount: function() {
                var temp = 0;
                if (this.expenses) {
                var rows = this.expenses;
                    var buildQty = this.buildQty;
                    if (this.total_expense) {
                        buildQty = this.totalBuildQty;
                    }
                    var count = 1000;
                    for (var i = 0; i < count; i++) {
                    if (rows[i] && buildQty) {
                        if (rows[i] && rows[i].amount != null) {
                        var temp = (temp + (Number.parseFloat(rows[i].amount) * Number.parseFloat(buildQty)));
                        }
                    }else{
                        count = 0;
                    }
                    }
                }
                return temp.toFixed(precision());
            },

        },
        mounted: function() {
            @if(saveTempData() == 'true' || $file)
            axios.get("{{route('temp.simpleBuild.getData')}}", {
                    params: {
                        type: 'simpleBuild'
                    }
                })
                .then(function(response) {
                    // console.log('myrespo1', response.data);
                    if (response.data) {
                        if (response.data.form) {
                            sales.date = response.data.form.date;
                            sales.description = response.data.form.description;
                            sales.buildQty = response.data.form.ref_no;
                            sales.number = response.data.form.number;
                            // sales.name = response.data.form.other_member_name;
                            
                            if (response.data.form.rate) {
                                sales.selected_site = _.find(sales.site, (k) => k.id == response.data.form.rate);
                            }
                        }
                        if (response.data.items) {
                            if (response.data.items.length > 0) {
                                sales.assemlby_items = [];
                                for (var r = 0; r < response.data.items.length; r++) {
                                    sales.assemlby_items.push({
                                        item: response.data.items[r], inventory: response.data.items[r], location: null
                                    });
                                }
                                for (var m = 1; m > response.data.items.length; m--) {
                                    sales.assemlby_items.push({
                                        item: null, inventory: null, location: null
                                    });
                                }
                            }
                        }
                        if (response.data.otherBuild) {
                            if (response.data.otherBuild.length > 0) {
                                sales.otherBuild = [];
                                for (var r = 0; r < response.data.otherBuild.length; r++) {
                                    sales.otherBuild.push({
                                        item: response.data.otherBuild[r], inventory: response.data.otherBuild[r].inventory
                                    });
                                }
                                for (var m = 4; m > response.data.otherBuild.length; m--) {
                                    sales.otherBuild.push({
                                        item: null, inventory: null
                                    });
                                }
                            }
                        }
                        if (response.data.expenses) {
                            if (response.data.expenses.length > 0) {
                                sales.expenses = [];
                                for (var r = 0; r < response.data.expenses.length; r++) {
                                    sales.expenses.push({
                                        expense_account: response.data.expenses[r].selected_account,
                                        description: response.data.expenses[r].description,
                                        amount: response.data.expenses[r].amount
                                    });
                                }
                                for (var m = 4; m > response.data.expenses.length; m--) {
                                    sales.expenses.push({
                                        expense_account: null,
                                        description: null,
                                        amount: null
                                    });
                                }
                            }
                        }
                        //begin formula item initialize
                        if (response.data.asseItem) {
                            sales.formula_items.push(response.data.asseItem);
                            sales.selected_assembly_item = sales.formula_items[0];
                        }

                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            @endif
            callSaveTemp();
        },
        methods: {

            select_percentage()
            {
                setTimeout((function () {
                    sales.select_percentages();
                }), 400)
            },
            select_percentages()
            {
                var buildQty = 0;
                sales.otherQuantity = 0;
                if(sales.percentage){
                    if (sales.otherBuild) {
                        for (var i = 0; i < sales.otherBuild.length; i++) {
                            if (sales.otherBuild[i].item){
                                if (sales.otherBuild[i].item.qty && sales.otherBuild[i].item.qty !=null){  
                                    var OnHand1=sales.otherBuild[i].item.qty;
                                    sales.otherQuantity += parseFloat(OnHand1);
                                }
                            }
                        }
                    }

                    if(sales.buildQty || sales.otherQuantity){
                        if(sales.assemlby_items){
                            buildQty = ((sales.buildQty)?Number.parseFloat(sales.buildQty):0) + ((sales.otherQuantity)?Number.parseFloat(sales.otherQuantity):0);
                            var perc = 0;

                            for (var i = 0; i < sales.assemlby_items.length; i++) 
                            {
                                if(sales.assemlby_items[i].item){
                                    if(sales.assemlby_items[i].item.percentage){
                                        perc = (perc + Number.parseFloat(sales.assemlby_items[i].item.percentage));
                                    }
                                }
                            }

                            for (var i = 0; i < sales.assemlby_items.length; i++) 
                            {
                                if(sales.assemlby_items[i].item){
                                    if(sales.assemlby_items[i].item.percentage && perc > 0){
                                        var percentage = Number.parseFloat(sales.assemlby_items[i].item.percentage);
                                        // console.log(222, percentage, buildQty, perc, buildQty);
                                        sales.assemlby_items[i].item.qty = Number.parseFloat((percentage * buildQty) / perc).toFixed(precision());
                                    }
                                }
                            }
                        }
                    }
                }
            },

            getBuildOnHand(item_measure_unit = null, selected_measure_unit = null, qty = null, on_hand = null, location = null) {
                var result = 0;
                if (on_hand != null) {
                    if (location) {
                        on_hand = location.OnHand;
                    }
                    if (qty) {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit) - (qty);
                    } else {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit);
                    }
                }
                return result.toFixed(precision());
            },
            getBuildOnHandWestage(item_measure_unit = null, selected_measure_unit = null, qty = null, on_hand = null) {
                var result = 0;
                if (on_hand != null) {
                    if (qty) {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit) + (qty);
                    } else {
                        result = (on_hand * item_measure_unit) / (selected_measure_unit);
                    }
                }
                return result.toFixed(precision());
            },

            setSite() {
                if (this.assemlby_items && this.selected_out_site) {
                var rows = this.assemlby_items;
                if (rows != null && rows.length > 0) {
                    for (var i = 0; i < rows.length; i++) {
                    if (rows[i] && rows[i].item != null) {
                        if (rows[i].item.item.site_list != null) {
                        rows[i].item.item.site  = _.find(rows[i].item.item.site_list, (o) => o.site_id == this.selected_out_site.id);
                        }
                    }
                    }
                }
                }
            },

            getItemCost(item_measure_unit = null, selected_measure_unit = null, cost = null) {
                var result = 0;
                if (cost != null) {
                    result = (cost * selected_measure_unit) / (item_measure_unit);

                }
                return result.toFixed(precision());
            },

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        regForm(e.target);
                    }
                });
            },

            // begin item search


            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            'formula': 'formula',
                            'limit_type': 'item',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        sales.formula_items = [];
                        if (response.data.length > 0) {
                            sales.formula_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            // end item search
            // items serarch method

            onItemsSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'AssemblyItemsSearch',
                            'type': 'assembaly',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        sales.temp_items = [];
                        if (response.data.length > 0) {
                            sales.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            onItemload(index) {
                if (sales.assemlby_items[index].inventory != null) {
                    var inventory_id = sales.assemlby_items[index].inventory.id;
                    let contract_id = (sales.selectedContract != undefined) ? sales.selectedContract.id : '';
                    let wagon_number = (sales.selectedWagon != undefined) ? sales.selectedWagon.name : '';
                    
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'items_search_assebley',
                                inventory_id: inventory_id,
                                contract_id: contract_id,
                                wagon_number: wagon_number
                            }
                        })
                        .then(function(response) {
                            sales.assemlby_items[index].item = null;
                            sales.assemlby_items[index].location = null;
                            if (response.data.length > 0) {
                                sales.assemlby_items[index].item = response.data[0];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            locationSearch: _.debounce((search, loading) => {
                loading(true);
                let inventory_id = (sales.assemlby_items[sales.selected_index]['inventory'] != undefined) ? sales.assemlby_items[sales.selected_index]['inventory'].id : '';
                // console.log(3333, sales.assemlby_items, sales.selected_index, inventory_id, search);
                if (inventory_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchLocation',
                            keyword: search,
                            inventory_id: inventory_id
                        }
                    })
                    .then(function(response) {
                        if (response) {
                            if (response.data.length > 0) {
                                sales.assemlby_items[sales.selected_index]['item']['locationList'] = response.data;
                            }
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                } else {
                    loading(false);
                }
            }, getDebounceTime()),

            locationItemload(index) {
                sales.selected_index = index;
                if (sales.assemlby_items[index].item != null && sales.assemlby_items[index].location != null) {
                    console.log(222, sales.assemlby_items[index].location);
                    var inventory_id = sales.assemlby_items[index].item.id;
                    var location = sales.assemlby_items[index].location.name;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSiteByLocation',
                                inventory_id: inventory_id,
                                location: location
                            }
                        })
                        .then(function(response) {
                            // console.log(4444, response.data, sales.assemlby_items[index].item);
                            if (response.data.item.length > 0) {
                                sales.assemlby_items[index].item.item.site_list = response.data.item;
                                sales.assemlby_items[index].item.site = response.data.selectItem;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            onOtherItemload(index) {
                // v.selected_index=index;
                if (sales.otherBuild[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = sales.otherBuild[index].inventory.id;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'items_search_assebley',
                                inventory_id: inventory_id
                            }
                        })
                        .then(function(response) {
                            sales.otherBuild[index].item = null;

                            if (response.data.length > 0) {
                                sales.otherBuild[index].item = response.data[0];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },


            setIndex(index) {
                sales.selected_index = index;
                // this.temp_items = [];
            },

            changeContract() {
                sales.assemlby_items = [];
                sales.assemlby_items.push({
                    item: null, inventory: null, location: null
                });
                this.wagon = this.wagonAll.filter((wagon) => {
                    return this.selectedContract.id == wagon.contract_id;
                });
            },
            contractWagon() {
                this.wagon = this.wagonAll;
                if (this.selectedContract) {
                    sales.assemlby_items = [];
                    sales.assemlby_items.push({
                        item: null, inventory: null, location: null
                    });
                }
            },
            addNew(type = null, index) {

                if (type != null) {
                    if (type == 'inventory') {
                        this.temp_items = [];
                        if (this.assemlby_items[index + 1] == undefined) {
                            this.assemlby_items.push({
                                inventory: null,
                                item: null, location: null
                            });
                        }
                    }
                    if (type == 'otherBuilds') {
                        this.temp_items = [];
                        if (this.otherBuild[index + 1] == undefined) {
                            this.otherBuild.push({
                                inventory: null,
                                item: null
                            });
                        }
                    }
                    if (type == 'expense') {
                        if (this.expenses[index + 1] == undefined) {
                            this.expenses.push({
                                expense_account: null
                            });
                        }
                    }


                }

            },
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        this.assemlby_items.splice(index, 1);
                    }
                    if (type == 'otherBuild') {
                        this.otherBuild.splice(index, 1);
                    }
                    if (type == 'expense') {
                        this.expenses.splice(index, 1);
                    }

                }

            },

            addItems(type) {
                if (type != null) {
                    if (type == "otherBuilds") {
                        this.temp_items = [];
                        this.otherBuild.push({
                            inventory: null,
                            item: null
                        });
                    }
                    if (type == "inventory") {
                        this.temp_items = [];
                        this.assemlby_items.push({
                            inventory: null,
                            item: null
                        });
                    }
                    if (type == "expense") {
                        this.expenses.push({
                            expense_account: null
                        });
                    }
                }

            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            sales.disabled = true;
                            var url = "{{route('simpleBuild.store')}}";
                            form_id = 'assembly-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    // console.log('sss11', response.data);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);

                                        location.reload();
                                    } else {
                                        sales.disabled = false;
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    sales.disabled = false;
                                    // console.log(error,v.disabled);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });
                        }
                    })
            },
            saveTemp() {
                var url = "{{route('temp.simpleBuild.store')}}";
                form_id = 'assembly-form';
                var data = $('#' + form_id).serialize();
                axios.post(url, data)
                    .then(function(response) {
                        // console.log('sss11', response);
                        callSaveTemp();
                    })
                    .catch(function(error) {
                        console.log(error);
                        callSaveTemp();
                    });
            },
            clearTemp() {
                axios.get("{{route('temp.clear')}}", {
                        params: {
                            type: 'simpleBuild'
                        }
                    })
                    .then(function(response) {
                        // console.log('sss11', response);
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },
        }
    });

    function sendFormData(e) {
        var el = $(e);
        var form = el.parents('form').get(0);
        var data = $('#import-form').serialize();
        console.log('test 22', data);
        swal({
            title: "@lang('layout.AreYouSure?')",
            icon: 'warning',
            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
            dangerMode: true,
        }).then((wichButton) => {
            if (wichButton) {
                form.submit();
                return true;
            }
            return false;
        });
    }
</script>


@endpush