@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop


@section('content')
{{-- {{dd($vendor)}} --}}
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ShareholderEdit') </span>
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::model($vendor,['method' => 'PATCH','route' => ['shareholder.update',$vendor->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body">
                    <h3 class="form-section">@lang('layout.PersonInfoo')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.FullName')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Code')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code', null, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                                </div>
                                
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                <div class="col-md-9">
                                      <input type="text" id="date_of_birth" name="date_of_birth" class="form-control date" autocomplete="off" value="{{$vendor->date_of_birth}}">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div id="genderApp">
                            <div class="col-md-6">
                                <label class="control-label col-md-3">@lang('layout.Gender')</label>
                                <div class="col-md-9">
                                    <div >
                                        <label class="radio-inline">
                                        <input type="radio" name="gender"  value="male" v-model="type"> @lang('layout.Male') </label>
                                        <label class="radio-inline">
                                        <input type="radio" name="gender" value="female"  v-model="type">
                                        @lang('layout.Female') </label>
                                    </div>
                                </div>
                            </div>
                            <!--/span-->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Membership')</label>
                                    <div class="col-md-9">
                                        <div>
                                            <label class="radio-inline">
                                            <input type="radio" name="membership" value="free" v-model="members"> @lang('layout.Free') </label>
                                            <label class="radio-inline">
                                            <input type="radio" name="membership" value="professiona" v-model="members">
                                            @lang('layout.Professional') </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Date')</label>
                                <div class="col-md-9">
                                    <input type="text" id="reg_date" name="reg_date" class="form-control date" autocomplete="off" value="{{$vendor->reg_date}}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <div class="col-md-9">
                                    {!! Form::file('photo', null, array('placeholder' => 'mm/dd/yy','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div> 
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Type')</label>
                                <div class="col-md-9">
                                 {!! Form::select('type[]', $type,$vendor->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                                </div>
                            </div>
                        </div>
                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Class')</label>
                                <div class="col-md-9">
                                    <select name="class" class="form-control select_style">
                                        <option value="">کلاس را انتخاب کنید</option>
                                        @forEach($class as $key => $value)
                                            <option value="{{$key}}" {{$vendor-> class_id == $key ? 'selected' : ''}}>{{$value}}</option>
                                        @endforeach
                                    </select>
                                    {{-- {{Form::select('class',$class,$vendor->class_id,['class' => 'form-control','placeholder' => 'Select Class'])}} --}}
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="row" id="app">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsReceivable')</label>
                                <div class="col-md-9">
                                    <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsPayable')</label>
                                <div class="col-md-9">
                                      <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3 class="form-section">@lang('layout.Address')</h3>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address1')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address2')</label>
                                <div class="col-md-9">
                                    {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div id="countries">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-7">
                                    {!! Form::text('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                                <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                    @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                </span>
                            </div>
                        </div>
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                <div class="col-md-9">
                                    {!! Form::number('phone2', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>

                        <!--/span-->
                        
                    </div>
                    <!--/row-->
                    <div class="row">
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>

						<div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9">
                                   <v-select label="name" v-model="selectedCountry" :options="countries">
                                    </v-select>
                                    <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                    <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                </div>
                            </div>
                        </div>

                    </div>
                    </div>
					<div class="row">
						
                        <h3>@lang('layout.JobTitle')</h3>

                        <div class="col-md-6">
                             <div class="form-group">
                                 <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                 <div class="col-md-9">

                                     {!! Form::select('job_title_id[]', $jobTitle,$vendor->memberJobtitle, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'job_title')) !!}
                                 </div>
                             </div>
                         </div>
                          <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.PostCode')</label>
                                <div class="col-md-9">
                                     {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->

                     <!--Begin Panels-->
                    <div class="tab-content">
                        <!-- GENERAL QUESTION TAB -->
                        <div class="tab-pane active" id="tab_1_1">
                            <div id="accordion1" class="panel-group">
                              
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <a class="accordion-toggle accordion-toggle-styled" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3"> @lang('layout.OtherInformations')</a>
                                        </h4>
                                    </div>
                                    <div id="accordion1_3" class="panel-collapse 
                                      {{(
                                        $vendor->company_license_number ||
                                        $vendor->license_issue_date ||
                                        $vendor->license_expire_date ||
                                        $vendor->passport ||
                                        $vendor->ss_id ||
                                        $vendor->boss_name ||
                                        $vendor->boss_ssn ||
                                        $vendor->boss_passport ||
                                        $vendor->assistant_name ||
                                        $vendor->assistant_ssn ||
                                        $vendor->assistant_passport
                                        )?'':'collapse'}}">
                                        <div class="panel-body">

                                       <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseNumber')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('company_license_number', null, array('placeholder' =>__('layout.LicenseNumber'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseIssueDate')</label>
                                                    <div class="col-md-9">
                                                         <input type="text"  name="license_issue_date" value="{{convertDate($vendor->license_issue_date)}}"  class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                             </div> 
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseExpireDate')</label>
                                                    <div class="col-md-9">
                                                          <input type="text"  name="license_expire_date"  
                                                          value="{{convertDate($vendor->license_expire_date)}}" class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                             </div>
                                        </div> 
                                       <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.PassportNumber')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('passport', null, array('placeholder' =>__('layout.PassportNumber'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.SSID')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('ss_id', null, array('placeholder' =>__('layout.SSID'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                         
                                        </div>  

                    
                                    <!--Begin Company Boss And Assistant Informations-->
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossName')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('boss_name', null, array('placeholder' =>__('layout.BossName'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossSSN')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('boss_ssn', null, array('placeholder' =>__('layout.BossSSN'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossPassport')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('boss_passport', null, array('placeholder' =>__('layout.BossPassport'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div>
                                        </div>                    

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantName')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('assistant_name', null, array('placeholder' =>__('layout.AssistantName'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantSSN')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('assistant_ssn', null, array('placeholder' =>__('layout.AssistantSSN'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantPassport')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('assistant_passport', null, array('placeholder' =>__('layout.AssistantPassport'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div>
                                        </div>
                                    <!--End Company Boss And Assistant Informations-->

                                        </div>
                                    </div>
                                </div>
                             
                            </div>
                        </div>
                        <!-- END GENERAL QUESTION TAB -->
                    </div>
            <!--END Panels-->
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <button type="button" class="btn default">@lang('layout.Cancel')</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection
@push('scripts')

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
script>
<script>

    Vue.component('v-select', VueSelect.VueSelect);
  
     var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $vendor !!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
    },
    mounted:function(){
        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
            //    if(this.receivable[j].id==this.customer.receivable_id)
            //   {
            //      this.selected_receivable=this.receivable[j];
            //   }
          }

          for(var r=0;r<this.receivable.length;r++)
          {
            //   if(this.payable[r].id==this.customer.payable_id)
            //   {
            //      this.selected_payable=this.payable[r];
            //   }
            if(this.receivable[r].id==this.customer.receivable_id)
              {
                  
                 this.selected_receivable=this.receivable[r];
              }
              
          }
    },

  });


    var gen = {!! json_encode($vendor) !!}
    // console.log('asdf',gen['membership'])
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });
	
	
	var countries = {!!$countries!!};
    var selectedCountry = {!!$selectedCountry!!};
	
     new Vue({
    el:'#countries',
    data:{
        countries:countries,
        selectedCountry:selectedCountry
    }
   
	});

    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });
    
</script>
@endpush