@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ServiceInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.ServiceNumber')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.ServiceName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-text-width"></i> @lang('layout.ServiceType')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-text-width"></i> @lang('layout.ServiceClass')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i>@lang('layout.TaxCode')
                        </th>
                        <th>
                            <i class="fa fa-shopping-cart"></i> @lang('layout.Rate')
                        </th>
                        <th>
                            <i class="fa fa-user"></i> @lang('layout.CreatedBy')
                        </th>
                        <th>
                            <i class="fa fa-paragraph"></i> @lang('layout.Description')
                        </th>
                        <th>

                            <i class="fa fa-clock-o"></i> @lang('layout.CreatedAt')
                        </th>

                        <th>
                            <i class="fa fa-history"></i> @lang('layout.UpdatedAt')
                        </th>
                        
                    </tr>
                    </thead>
                    <tbody>
                    <tr> 
                        <td class="hidden-xs"> {{ $serviceInfo->number}}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->name}}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->type }}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->service_class_name }}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->tax_code }}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->rate }}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->username}}  </td>
                        <td class="hidden-xs"> {{ $serviceInfo->description}}  </td>
                        <td class="hidden-xs"> {{ convertDate($serviceInfo->created_at) }}  </td>
                        <td class="hidden-xs"> {{ convertDate($serviceInfo->updated_at) }}  </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ServiceDetails')</span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="service_details"/>
                           <input type="hidden" name="id" value="{{$serviceInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="service_details"/>
                           <input type="hidden" name="id" value="{{$serviceInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="service">
                        <thead>
                        <tr>
                            <th>@lang('layout.Customer')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Price')</th>
                            <th>@lang('layout.MeasureUnit')</th> 
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

<script>
 
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#service').DataTable({
            ajax:'{{route("service.show",$serviceInfo->id)}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
                { data: 'customer', name: 'customer' },
                { data: 'date', name: 'date' },
                { data: 'qty', name: 'qty' },
                { data: 'sales_price', name: 'sales' },
                { data: 'unit_measure', name: 'unit_measure' },
        ]

        });


    });
</script>


@endpush
