@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'servicelist'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.ServiceClass'):</label>
                        
                        <v-select label="name"
                        v-model="selected_serviceClass" :options="serviceClass">
                        </v-select> 
                        <input type="hidden" name="service_class_id"
                            v-model.number="(!selected_serviceClass)?null:selected_serviceClass.id"> 
                    </div>
                </div> 
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ServicesList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('services-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission
                    @permission('services-create')
                    <a href="{{route('service.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="service">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.IncomeAccount')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.CostAccount')</th>
                            <th>@lang('layout.Cost') </th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {

            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#service').DataTable({
                ajax: '{{route("service.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    // {data: 'number', name: 'id', orderable: false, searchable: false},
                    {data: 'number', name: 'number'},
                    {data: 'name', name: 'name'},
                    {data: 'description', name: 'description'},
                    {data: 'income', name: 'income'},
                    {data: 'rate', name: 'account', orderable: false, searchable: false},
                    {data: 'measure', name: 'measure', searchable: false},
                    {data: 'cost_account', name: 'account', orderable: false, searchable: false},
                    {data: 'amount', name: 'account', orderable: false, searchable: false},
                    {data: 'actions', name: 'account', orderable: false, searchable: false}
                ]
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },
            });


        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

        
    let serviceClass = {!! $serviceClass !!};

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                serviceClass: serviceClass,
                selected_serviceClass : null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush
